/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.AutoValue_Heartbeat;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import java.io.Serializable;
import java.time.Instant;
import javax.annotation.Nonnull;

@InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
@AutoValue
public abstract class Heartbeat
implements ChangeStreamRecord,
Serializable {
    private static final long serialVersionUID = 7316215828353608504L;

    private static Heartbeat create(ChangeStreamContinuationToken changeStreamContinuationToken, Instant estimatedLowWatermark) {
        return new AutoValue_Heartbeat(changeStreamContinuationToken, estimatedLowWatermark);
    }

    static Heartbeat fromProto(@Nonnull ReadChangeStreamResponse.Heartbeat heartbeat) {
        return Heartbeat.create(ChangeStreamContinuationToken.fromProto(heartbeat.getContinuationToken()), Instant.ofEpochSecond(heartbeat.getEstimatedLowWatermark().getSeconds(), heartbeat.getEstimatedLowWatermark().getNanos()));
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public abstract ChangeStreamContinuationToken getChangeStreamContinuationToken();

    @ObsoleteApi(value="Use getEstimatedLowWatermarkTime() instead")
    public com.google.bigtable.repackaged.org.threeten.bp.Instant getEstimatedLowWatermark() {
        return TimeConversionUtils.toThreetenInstant(this.getEstimatedLowWatermarkTime());
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public abstract Instant getEstimatedLowWatermarkTime();
}

