/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.StreamContinuationTokens;
import com.google.bigtable.repackaged.com.google.bigtable.v2.StreamPartition;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import com.google.bigtable.repackaged.com.google.protobuf.Timestamp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
public final class ReadChangeStreamQuery
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 948588515749969176L;
    private final String tableId;
    private transient ReadChangeStreamRequest.Builder builder = ReadChangeStreamRequest.newBuilder();

    public static ReadChangeStreamQuery create(String tableId) {
        return new ReadChangeStreamQuery(tableId);
    }

    private ReadChangeStreamQuery(String tableId) {
        this.tableId = tableId;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadChangeStreamRequest.Builder)ReadChangeStreamRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public ReadChangeStreamQuery streamPartition(@Nonnull RowRange rowRange) {
        this.builder.setPartition(StreamPartition.newBuilder().setRowRange(rowRange).build());
        return this;
    }

    public ReadChangeStreamQuery streamPartition(String start, String end) {
        return this.streamPartition(ReadChangeStreamQuery.wrapKey(start), ReadChangeStreamQuery.wrapKey(end));
    }

    public ReadChangeStreamQuery streamPartition(@Nullable ByteString start, @Nullable ByteString end) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        if (start != null) {
            rangeBuilder.setStartKeyClosed(start);
        }
        if (end != null) {
            rangeBuilder.setEndKeyOpen(end);
        }
        return this.streamPartition(rangeBuilder.build());
    }

    public ReadChangeStreamQuery streamPartition(Range.ByteStringRange range) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        switch (range.getStartBound()) {
            case OPEN: {
                throw new IllegalStateException("Start bound should be closed.");
            }
            case CLOSED: {
                rangeBuilder.setStartKeyClosed((ByteString)range.getStart());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearStartKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown start bound: " + (Object)((Object)range.getStartBound()));
            }
        }
        switch (range.getEndBound()) {
            case OPEN: {
                rangeBuilder.setEndKeyOpen((ByteString)range.getEnd());
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("End bound should be open.");
            }
            case UNBOUNDED: {
                rangeBuilder.clearEndKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown end bound: " + (Object)((Object)range.getEndBound()));
            }
        }
        return this.streamPartition(rangeBuilder.build());
    }

    @ObsoleteApi(value="Use startTime(java.time.Instant) instead")
    public ReadChangeStreamQuery startTime(com.google.bigtable.repackaged.org.threeten.bp.Instant value) {
        return this.startTime(TimeConversionUtils.toJavaTimeInstant(value));
    }

    public ReadChangeStreamQuery startTime(Instant value) {
        Preconditions.checkState(!this.builder.hasContinuationTokens(), "startTime and continuationTokens can't be specified together");
        this.builder.setStartTime(Timestamp.newBuilder().setSeconds(value.getEpochSecond()).setNanos(value.getNano()).build());
        return this;
    }

    @ObsoleteApi(value="Use endTime(java.time.Instant) instead")
    public ReadChangeStreamQuery endTime(com.google.bigtable.repackaged.org.threeten.bp.Instant value) {
        return this.endTime(TimeConversionUtils.toJavaTimeInstant(value));
    }

    public ReadChangeStreamQuery endTime(Instant value) {
        this.builder.setEndTime(Timestamp.newBuilder().setSeconds(value.getEpochSecond()).setNanos(value.getNano()).build());
        return this;
    }

    public ReadChangeStreamQuery continuationTokens(List<ChangeStreamContinuationToken> changeStreamContinuationTokens) {
        Preconditions.checkState(!this.builder.hasStartTime(), "startTime and continuationTokens can't be specified together");
        StreamContinuationTokens.Builder streamContinuationTokensBuilder = StreamContinuationTokens.newBuilder();
        for (ChangeStreamContinuationToken changeStreamContinuationToken : changeStreamContinuationTokens) {
            streamContinuationTokensBuilder.addTokens(changeStreamContinuationToken.getTokenProto());
        }
        this.builder.setContinuationTokens(streamContinuationTokensBuilder);
        return this;
    }

    @ObsoleteApi(value="Use heartbeatDuration(java.time.Duration) instead")
    public ReadChangeStreamQuery heartbeatDuration(com.google.bigtable.repackaged.org.threeten.bp.Duration duration) {
        return this.heartbeatDuration(TimeConversionUtils.toJavaTimeDuration(duration));
    }

    public ReadChangeStreamQuery heartbeatDuration(java.time.Duration duration) {
        this.builder.setHeartbeatDuration(Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build());
        return this;
    }

    @InternalApi(value="Used in Changestream beam pipeline.")
    public ReadChangeStreamRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    public static ReadChangeStreamQuery fromProto(@Nonnull ReadChangeStreamRequest request) {
        ReadChangeStreamQuery query = new ReadChangeStreamQuery(NameUtil.extractTableIdFromTableName(request.getTableName()));
        query.builder = request.toBuilder();
        return query;
    }

    protected ReadChangeStreamQuery clone() {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create(this.tableId);
        query.builder = this.builder.clone();
        return query;
    }

    @Nullable
    private static ByteString wrapKey(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return ByteString.copyFromUtf8(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadChangeStreamQuery query = (ReadChangeStreamQuery)o;
        return Objects.equal(this.tableId, query.tableId) && Objects.equal(this.builder.getPartition(), query.builder.getPartition()) && Objects.equal(this.builder.getStartTime(), query.builder.getStartTime()) && Objects.equal(this.builder.getEndTime(), query.builder.getEndTime()) && Objects.equal(this.builder.getContinuationTokens(), query.builder.getContinuationTokens()) && Objects.equal(this.builder.getHeartbeatDuration(), query.builder.getHeartbeatDuration());
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.builder.getPartition(), this.builder.getStartTime(), this.builder.getEndTime(), this.builder.getContinuationTokens(), this.builder.getHeartbeatDuration());
    }

    public String toString() {
        ReadChangeStreamRequest request = this.builder.build();
        return MoreObjects.toStringHelper(this).add("tableId", this.tableId).add("partition", request.getPartition()).add("startTime", request.getStartTime()).add("endTime", request.getEndTime()).add("continuationTokens", request.getContinuationTokens()).add("heartbeatDuration", request.getHeartbeatDuration()).toString();
    }
}

