/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class SampleRowKeysRequest
implements Serializable {
    private final TargetId targetId;

    private SampleRowKeysRequest(TargetId targetId) {
        Preconditions.checkNotNull(targetId, "target id can't be null.");
        this.targetId = targetId;
    }

    public static SampleRowKeysRequest create(TargetId targetId) {
        return new SampleRowKeysRequest(targetId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest toProto(RequestContext requestContext) {
        SampleRowKeysRequest.Builder builder = com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest.newBuilder();
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForMaterializedView()) {
            builder.setMaterializedViewName(resourceName);
        } else if (this.targetId.scopedForAuthorizedView()) {
            builder.setAuthorizedViewName(resourceName);
        } else {
            builder.setTableName(resourceName);
        }
        return builder.setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @InternalApi
    public static SampleRowKeysRequest fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest request) {
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        String materializedViewName = request.getMaterializedViewName();
        SampleRowKeysRequest sampleRowKeysRequest = SampleRowKeysRequest.create(NameUtil.extractTargetId(tableName, authorizedViewName, materializedViewName));
        return sampleRowKeysRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleRowKeysRequest sampleRowKeysRequest = (SampleRowKeysRequest)o;
        return Objects.equal(this.targetId, sampleRowKeysRequest.targetId);
    }
}

