/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.Distribution;
import com.google.bigtable.repackaged.com.google.api.Metric;
import com.google.bigtable.repackaged.com.google.api.MetricDescriptor;
import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.com.google.common.base.Suppliers;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Point;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ProjectName;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeInterval;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TypedValue;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.HistogramData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.MetricData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.MetricDataType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.SumData;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class BigtableExporterUtils {
    private static final String CLIENT_NAME = "java-bigtable/" + Version.VERSION;
    private static final Logger logger = Logger.getLogger(BigtableExporterUtils.class.getName());
    private static final String BIGTABLE_RESOURCE_TYPE = "bigtable_client_raw";
    private static final Set<AttributeKey<String>> BIGTABLE_PROMOTED_RESOURCE_LABELS = ImmutableSet.of(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, BuiltinMetricsConstants.INSTANCE_ID_KEY, BuiltinMetricsConstants.TABLE_ID_KEY, BuiltinMetricsConstants.CLUSTER_ID_KEY, BuiltinMetricsConstants.ZONE_ID_KEY);
    private static final Map<GCPPlatformDetector.SupportedPlatform, String> SUPPORTED_PLATFORM_MAP = ImmutableMap.of(GCPPlatformDetector.SupportedPlatform.GOOGLE_COMPUTE_ENGINE, "gcp_compute_engine", GCPPlatformDetector.SupportedPlatform.GOOGLE_KUBERNETES_ENGINE, "gcp_kubernetes_engine");
    private static String defaultTaskValue = null;
    static final Supplier<String> DEFAULT_TASK_VALUE = Suppliers.memoize(BigtableExporterUtils::computeDefaultTaskValue);

    private BigtableExporterUtils() {
    }

    private static String computeDefaultTaskValue() {
        if (defaultTaskValue != null) {
            return defaultTaskValue;
        }
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + UUID.randomUUID() + "@" + hostname;
        }
        return "java-" + UUID.randomUUID() + jvmName;
    }

    static ProjectName getProjectName(PointData pointData) {
        return ProjectName.of(pointData.getAttributes().get(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY));
    }

    static Map<ProjectName, List<TimeSeries>> convertToBigtableTimeSeries(Collection<MetricData> collection, String taskId) {
        HashMap<ProjectName, List<TimeSeries>> allTimeSeries = new HashMap<ProjectName, List<TimeSeries>>();
        for (MetricData metricData : collection) {
            if (!metricData.getInstrumentationScopeInfo().getName().equals("bigtable.googleapis.com/internal/client/")) continue;
            for (PointData pd : metricData.getData().getPoints()) {
                ProjectName projectName = BigtableExporterUtils.getProjectName(pd);
                List current = allTimeSeries.computeIfAbsent(projectName, ignored -> new ArrayList());
                current.add(BigtableExporterUtils.convertPointToBigtableTimeSeries(metricData, pd, taskId));
                allTimeSeries.put(projectName, current);
            }
        }
        return allTimeSeries;
    }

    static List<TimeSeries> convertToApplicationResourceTimeSeries(Collection<MetricData> collection, MonitoredResource applicationResource) {
        Preconditions.checkNotNull(applicationResource, "convert application metrics is called when the supported resource is not detected");
        ArrayList<TimeSeries> allTimeSeries = new ArrayList<TimeSeries>();
        for (MetricData metricData : collection) {
            metricData.getData().getPoints().stream().map(pointData -> BigtableExporterUtils.createInternalMetricsTimeSeries(metricData, pointData, applicationResource)).filter(Optional::isPresent).forEach(ts -> ts.ifPresent(allTimeSeries::add));
        }
        return allTimeSeries;
    }

    @Nullable
    static MonitoredResource createInternalMonitoredResource(EnhancedBigtableStubSettings settings) {
        try {
            MonitoredResource monitoredResource = BigtableExporterUtils.detectResource(settings);
            logger.log(Level.FINE, "Internal metrics monitored resource: %s", monitoredResource);
            return monitoredResource;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to detect resource, will skip exporting application level metrics ", e);
            return null;
        }
    }

    @Nullable
    private static MonitoredResource detectResource(EnhancedBigtableStubSettings settings) {
        GCPPlatformDetector detector = GCPPlatformDetector.DEFAULT_INSTANCE;
        DetectedPlatform detectedPlatform = detector.detectPlatform();
        String cloud_platform = SUPPORTED_PLATFORM_MAP.get((Object)detectedPlatform.getSupportedPlatform());
        if (cloud_platform == null) {
            return null;
        }
        Map<String, String> attrs = detectedPlatform.getAttributes();
        ImmutableList<String> locationKeys = ImmutableList.of("cloud_region", "availability_zone", "REGION", "gke_cluster_location");
        String region = locationKeys.stream().map(attrs::get).filter(Objects::nonNull).findFirst().orElse("global");
        region = Arrays.stream(region.split("-")).limit(2L).collect(Collectors.joining("-"));
        String hostname = attrs.get("instance_hostname");
        if (hostname == null) {
            hostname = System.getenv("HOSTNAME");
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (hostname == null) {
            hostname = "";
        }
        return MonitoredResource.newBuilder().setType("bigtable_client").putLabels("project_id", settings.getProjectId()).putLabels("instance", settings.getInstanceId()).putLabels("app_profile", settings.getAppProfileId()).putLabels("client_project", detectedPlatform.getProjectId()).putLabels("region", region).putLabels("cloud_platform", cloud_platform).putLabels("host_id", attrs.get("instance_id")).putLabels("host_name", hostname).putLabels("client_name", CLIENT_NAME).putLabels("uuid", DEFAULT_TASK_VALUE.get()).build();
    }

    private static TimeSeries convertPointToBigtableTimeSeries(MetricData metricData, PointData pointData, String taskId) {
        TimeSeries.Builder builder = TimeSeries.newBuilder().setMetricKind(BigtableExporterUtils.convertMetricKind(metricData)).setValueType(BigtableExporterUtils.convertValueType(metricData.getType()));
        Metric.Builder metricBuilder = Metric.newBuilder().setType(metricData.getName());
        Attributes attributes = pointData.getAttributes();
        MonitoredResource.Builder monitoredResourceBuilder = MonitoredResource.newBuilder().setType(BIGTABLE_RESOURCE_TYPE);
        for (AttributeKey<?> key : attributes.asMap().keySet()) {
            if (BIGTABLE_PROMOTED_RESOURCE_LABELS.contains(key)) {
                monitoredResourceBuilder.putLabels(key.getKey(), String.valueOf(attributes.get(key)));
                continue;
            }
            metricBuilder.putLabels(key.getKey(), String.valueOf(attributes.get(key)));
        }
        builder.setResource(monitoredResourceBuilder.build());
        metricBuilder.putLabels(BuiltinMetricsConstants.CLIENT_UID_KEY.getKey(), taskId);
        builder.setMetric(metricBuilder.build());
        TimeInterval timeInterval = TimeInterval.newBuilder().setStartTime(Timestamps.fromNanos(pointData.getStartEpochNanos())).setEndTime(Timestamps.fromNanos(pointData.getEpochNanos())).build();
        builder.addPoints(BigtableExporterUtils.createPoint(metricData.getType(), pointData, timeInterval));
        return builder.build();
    }

    private static Optional<TimeSeries> createInternalMetricsTimeSeries(MetricData metricData, PointData pointData, MonitoredResource applicationResource) {
        Metric.Builder metricBuilder;
        TimeSeries.Builder builder = TimeSeries.newBuilder().setMetricKind(BigtableExporterUtils.convertMetricKind(metricData)).setValueType(BigtableExporterUtils.convertValueType(metricData.getType())).setResource(applicationResource);
        if (BuiltinMetricsConstants.INTERNAL_METRICS.contains(metricData.getName())) {
            metricBuilder = BigtableExporterUtils.newApplicationMetricBuilder(metricData.getName(), pointData.getAttributes());
        } else if (BuiltinMetricsConstants.GRPC_METRICS.containsKey(metricData.getName())) {
            metricBuilder = BigtableExporterUtils.newGrpcMetricBuilder(metricData.getName(), pointData.getAttributes());
        } else {
            logger.fine("Skipping unexpected internal metric: " + metricData.getName());
            return Optional.empty();
        }
        builder.setMetric(metricBuilder.build());
        TimeInterval timeInterval = TimeInterval.newBuilder().setStartTime(Timestamps.fromNanos(pointData.getStartEpochNanos())).setEndTime(Timestamps.fromNanos(pointData.getEpochNanos())).build();
        builder.addPoints(BigtableExporterUtils.createPoint(metricData.getType(), pointData, timeInterval));
        return Optional.of(builder.build());
    }

    private static Metric.Builder newApplicationMetricBuilder(String metricName, Attributes attributes) {
        Metric.Builder metricBuilder = Metric.newBuilder().setType(metricName);
        for (Map.Entry<AttributeKey<?>, Object> e : attributes.asMap().entrySet()) {
            metricBuilder.putLabels(e.getKey().getKey(), String.valueOf(e.getValue()));
        }
        return metricBuilder;
    }

    private static Metric.Builder newGrpcMetricBuilder(String grpcMetricName, Attributes attributes) {
        Set<String> allowedAttrs = BuiltinMetricsConstants.GRPC_METRICS.get(grpcMetricName);
        Metric.Builder metricBuilder = Metric.newBuilder().setType("bigtable.googleapis.com/internal/client/" + grpcMetricName.replace('.', '/'));
        for (Map.Entry<AttributeKey<?>, Object> e : attributes.asMap().entrySet()) {
            String attrKey = e.getKey().getKey();
            Object attrValue = e.getValue();
            if (!allowedAttrs.contains(attrKey)) continue;
            String normalizedKey = attrKey.replace('.', '_');
            metricBuilder.putLabels(normalizedKey, String.valueOf(attrValue));
        }
        return metricBuilder;
    }

    private static MetricDescriptor.MetricKind convertMetricKind(MetricData metricData) {
        switch (metricData.getType()) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return BigtableExporterUtils.convertHistogramType(metricData.getHistogramData());
            }
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return MetricDescriptor.MetricKind.GAUGE;
            }
            case LONG_SUM: {
                return BigtableExporterUtils.convertSumDataType(metricData.getLongSumData());
            }
            case DOUBLE_SUM: {
                return BigtableExporterUtils.convertSumDataType(metricData.getDoubleSumData());
            }
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertHistogramType(HistogramData histogramData) {
        if (histogramData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertSumDataType(SumData<?> sum) {
        if (!sum.isMonotonic()) {
            return MetricDescriptor.MetricKind.GAUGE;
        }
        if (sum.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.ValueType convertValueType(MetricDataType metricDataType) {
        switch (metricDataType) {
            case LONG_GAUGE: 
            case LONG_SUM: {
                return MetricDescriptor.ValueType.INT64;
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return MetricDescriptor.ValueType.DOUBLE;
            }
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return MetricDescriptor.ValueType.DISTRIBUTION;
            }
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    private static Point createPoint(MetricDataType type, PointData pointData, TimeInterval timeInterval) {
        Point.Builder builder = Point.newBuilder().setInterval(timeInterval);
        switch (type) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return builder.setValue(TypedValue.newBuilder().setDistributionValue(BigtableExporterUtils.convertHistogramData((HistogramPointData)pointData)).build()).build();
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return builder.setValue(TypedValue.newBuilder().setDoubleValue(((DoublePointData)pointData).getValue()).build()).build();
            }
            case LONG_GAUGE: 
            case LONG_SUM: {
                return builder.setValue(TypedValue.newBuilder().setInt64Value(((LongPointData)pointData).getValue())).build();
            }
        }
        logger.log(Level.WARNING, "unsupported metric type");
        return builder.build();
    }

    private static Distribution convertHistogramData(HistogramPointData pointData) {
        return Distribution.newBuilder().setCount(pointData.getCount()).setMean(pointData.getCount() == 0L ? 0.0 : pointData.getSum() / (double)pointData.getCount()).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds(pointData.getBoundaries()))).addAllBucketCounts(pointData.getCounts()).build();
    }
}

