/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracer;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;

class BigtableGrpcStreamTracer
extends ClientStreamTracer {
    private static final String GRPC_LB_LOCALITY_KEY = "grpc.lb.locality";
    private static final String GRPC_LB_BACKEND_SERVICE_KEY = "grpc.lb.backend_service";
    private final ClientStreamTracer.StreamInfo info;
    private final BigtableTracer tracer;
    private volatile String backendService = null;
    private volatile String locality = null;

    public BigtableGrpcStreamTracer(ClientStreamTracer.StreamInfo info, BigtableTracer tracer) {
        this.info = info;
        this.tracer = tracer;
    }

    @Override
    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        this.tracer.grpcMessageSent();
    }

    @Override
    public void addOptionalLabel(String key, String value) {
        switch (key) {
            case "grpc.lb.locality": {
                this.locality = value;
                break;
            }
            case "grpc.lb.backend_service": {
                this.backendService = value;
            }
        }
        super.addOptionalLabel(key, value);
    }

    @Override
    public void streamClosed(Status status) {
        this.tracer.setTransportAttrs(BuiltinMetricsTracer.TransportAttrs.create(this.locality, this.backendService));
        super.streamClosed(status);
    }

    static class Factory
    extends ClientStreamTracer.Factory {
        private final BigtableTracer tracer;

        Factory(BigtableTracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new BigtableGrpcStreamTracer(info, this.tracer);
        }
    }
}

