/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.AutoValue_BuiltinMetricsTracer_TransportAttrs;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.math.IntMath;
import com.google.bigtable.repackaged.com.google.gson.Gson;
import com.google.bigtable.repackaged.com.google.gson.reflect.TypeToken;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.DoubleHistogram;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongCounter;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class BuiltinMetricsTracer
extends BigtableTracer {
    private static final Logger logger = Logger.getLogger(BuiltinMetricsTracer.class.getName());
    private static final Gson GSON = new Gson();
    private static final TypeToken<Map<String, String>> LOCALITY_TYPE = new TypeToken<Map<String, String>>(){};
    private static final String NAME = "java-bigtable/" + Version.VERSION;
    private final ApiTracerFactory.OperationType operationType;
    private final SpanName spanName;
    private final AtomicBoolean operationFinishedEarly = new AtomicBoolean();
    private final AtomicBoolean opFinished = new AtomicBoolean();
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Stopwatch firstResponsePerOpTimer = Stopwatch.createStarted();
    private int attemptCount = 0;
    private Stopwatch attemptTimer;
    private volatile int attempt = 0;
    private final AtomicLong totalServerLatencyNano = new AtomicLong(0L);
    private final Stopwatch serverLatencyTimer = Stopwatch.createUnstarted();
    private final Object timerLock = new Object();
    private boolean flowControlIsDisabled = false;
    private final AtomicInteger requestLeft = new AtomicInteger(0);
    private String tableId = "<unspecified>";
    private String zone = "global";
    private String cluster = "<unspecified>";
    private final AtomicLong totalClientBlockingTime = new AtomicLong(0L);
    private final Attributes baseAttributes;
    private Long serverLatencies = null;
    private final AtomicLong grpcMessageSentDelay = new AtomicLong(0L);
    private Deadline operationDeadline = null;
    private volatile long remainingDeadlineAtAttemptStart = 0L;
    private TransportAttrs transportAttrs = null;
    private final DoubleHistogram operationLatenciesHistogram;
    private final DoubleHistogram attemptLatenciesHistogram;
    private final DoubleHistogram attemptLatencies2Histogram;
    private final DoubleHistogram serverLatenciesHistogram;
    private final DoubleHistogram firstResponseLatenciesHistogram;
    private final DoubleHistogram clientBlockingLatenciesHistogram;
    private final DoubleHistogram applicationBlockingLatenciesHistogram;
    private final DoubleHistogram remainingDeadlineHistogram;
    private final LongCounter connectivityErrorCounter;
    private final LongCounter retryCounter;

    BuiltinMetricsTracer(ApiTracerFactory.OperationType operationType, SpanName spanName, Attributes attributes, DoubleHistogram operationLatenciesHistogram, DoubleHistogram attemptLatenciesHistogram, DoubleHistogram attemptLatencies2Histogram, DoubleHistogram serverLatenciesHistogram, DoubleHistogram firstResponseLatenciesHistogram, DoubleHistogram clientBlockingLatenciesHistogram, DoubleHistogram applicationBlockingLatenciesHistogram, DoubleHistogram deadlineHistogram, LongCounter connectivityErrorCounter, LongCounter retryCounter) {
        this.operationType = operationType;
        this.spanName = spanName;
        this.baseAttributes = attributes;
        this.operationLatenciesHistogram = operationLatenciesHistogram;
        this.attemptLatenciesHistogram = attemptLatenciesHistogram;
        this.attemptLatencies2Histogram = attemptLatencies2Histogram;
        this.serverLatenciesHistogram = serverLatenciesHistogram;
        this.firstResponseLatenciesHistogram = firstResponseLatenciesHistogram;
        this.clientBlockingLatenciesHistogram = clientBlockingLatenciesHistogram;
        this.applicationBlockingLatenciesHistogram = applicationBlockingLatenciesHistogram;
        this.remainingDeadlineHistogram = deadlineHistogram;
        this.connectivityErrorCounter = connectivityErrorCounter;
        this.retryCounter = retryCounter;
    }

    @Override
    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void operationFinishEarly() {
        this.operationFinishedEarly.set(true);
        this.attemptTimer.stop();
        this.operationTimer.stop();
    }

    @Override
    public void operationSucceeded() {
        this.recordOperationCompletion(null);
    }

    @Override
    public void operationCancelled() {
        this.recordOperationCompletion(new CancellationException());
    }

    @Override
    public void operationFailed(Throwable error) {
        this.recordOperationCompletion(error);
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attemptStarted(null, attemptNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.attempt = attemptNumber;
        ++this.attemptCount;
        this.attemptTimer = Stopwatch.createStarted();
        if (this.operationDeadline != null) {
            this.remainingDeadlineAtAttemptStart = this.operationDeadline.timeRemaining(TimeUnit.MILLISECONDS);
        }
        if (request != null) {
            this.tableId = Util.extractTableId(request);
        }
        if (!this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimer.isRunning()) {
                    this.serverLatencyTimer.start();
                }
            }
        }
    }

    @Override
    public void attemptSucceeded() {
        this.recordAttemptCompletion(null);
    }

    @Override
    public void attemptCancelled() {
        this.recordAttemptCompletion(new CancellationException());
    }

    @Override
    @ObsoleteApi(value="Use attemptFailedDuration(Throwable, java.time.Duration) instead")
    public void attemptFailed(Throwable error, Duration delay) {
        this.attemptFailedDuration(error, TimeConversionUtils.toJavaTimeDuration(delay));
    }

    @Override
    public void attemptFailedDuration(Throwable error, java.time.Duration delay) {
        this.recordAttemptCompletion(error);
    }

    @Override
    public void attemptPermanentFailure(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(int requestCount) {
        this.requestLeft.accumulateAndGet(requestCount, IntMath::saturatedAdd);
        if (this.operationFinishedEarly.get()) {
            return;
        }
        if (this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimer.isRunning()) {
                    this.serverLatencyTimer.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived() {
        if (this.operationFinishedEarly.get()) {
            return;
        }
        if (this.firstResponsePerOpTimer.isRunning()) {
            this.firstResponsePerOpTimer.stop();
        }
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimer.isRunning()) {
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterResponse(long applicationLatency) {
        if (!this.flowControlIsDisabled || this.requestLeft.decrementAndGet() > 0) {
            if (this.operationFinishedEarly.get()) {
                return;
            }
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimer.isRunning()) {
                    this.serverLatencyTimer.start();
                }
            }
        }
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public void recordGfeMetadata(@Nullable Long latency, @Nullable Throwable throwable) {
        if (latency != null) {
            this.serverLatencies = latency;
        }
    }

    @Override
    public void setLocations(String zone, String cluster) {
        this.zone = zone;
        this.cluster = cluster;
    }

    @Override
    public void setTransportAttrs(TransportAttrs attrs) {
        this.transportAttrs = attrs;
    }

    @Override
    public void batchRequestThrottled(long throttledTimeNanos) {
        this.totalClientBlockingTime.addAndGet(java.time.Duration.ofNanos(throttledTimeNanos).toMillis());
    }

    @Override
    public void grpcMessageSent() {
        this.grpcMessageSentDelay.set(this.attemptTimer.elapsed(TimeUnit.NANOSECONDS));
    }

    @Override
    public void setTotalTimeoutDuration(java.time.Duration totalTimeoutDuration) {
        if (this.operationDeadline == null && !totalTimeoutDuration.isZero()) {
            this.operationDeadline = Deadline.after(totalTimeoutDuration.toMillis(), TimeUnit.MILLISECONDS);
            this.remainingDeadlineAtAttemptStart = totalTimeoutDuration.toMillis();
        }
    }

    @Override
    public void disableFlowControl() {
        this.flowControlIsDisabled = true;
    }

    private void recordOperationCompletion(@Nullable Throwable status) {
        if (this.operationFinishedEarly.get()) {
            status = null;
        }
        if (!this.opFinished.compareAndSet(false, true)) {
            return;
        }
        long operationLatencyNano = this.operationTimer.elapsed(TimeUnit.NANOSECONDS);
        boolean isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        String statusStr = Util.extractStatus(status);
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, this.tableId).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, this.cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, this.zone).put(BuiltinMetricsConstants.METHOD_KEY, this.spanName.toString()).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, NAME).put(BuiltinMetricsConstants.STREAMING_KEY, Boolean.valueOf(isStreaming)).put(BuiltinMetricsConstants.STATUS_KEY, statusStr).build();
        if (this.attemptCount > 1) {
            this.retryCounter.add(this.attemptCount - 1, attributes);
        }
        this.operationLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(operationLatencyNano), attributes);
        long applicationLatencyNano = operationLatencyNano - this.totalServerLatencyNano.get();
        this.applicationBlockingLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(applicationLatencyNano), attributes);
        if (this.operationType == ApiTracerFactory.OperationType.ServerStreaming && this.spanName.getMethodName().equals("ReadRows")) {
            this.firstResponseLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.firstResponsePerOpTimer.elapsed(TimeUnit.NANOSECONDS)), attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAttemptCompletion(@Nullable Throwable status) {
        boolean isStreaming;
        if (this.operationFinishedEarly.get()) {
            status = null;
        }
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimer.isRunning()) {
                this.requestLeft.decrementAndGet();
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
            }
        }
        boolean bl = isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        if (status instanceof ServerStreamingAttemptException) {
            status = status.getCause();
        }
        String statusStr = Util.extractStatus(status);
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, this.tableId).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, this.cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, this.zone).put(BuiltinMetricsConstants.METHOD_KEY, this.spanName.toString()).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, NAME).put(BuiltinMetricsConstants.STREAMING_KEY, Boolean.valueOf(isStreaming)).put(BuiltinMetricsConstants.STATUS_KEY, statusStr).build();
        this.totalClientBlockingTime.addAndGet(this.grpcMessageSentDelay.get());
        this.clientBlockingLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.totalClientBlockingTime.get()), attributes);
        this.attemptLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.attemptTimer.elapsed(TimeUnit.NANOSECONDS)), attributes);
        String transportType = "cloudpath";
        String transportRegion = "";
        String transportZone = "";
        String transportSubzone = "";
        try {
            if (this.transportAttrs != null && !Strings.isNullOrEmpty(this.transportAttrs.getLocality())) {
                transportType = "directpath";
                Map<String, String> localityMap = GSON.fromJson(this.transportAttrs.getLocality(), LOCALITY_TYPE);
                transportRegion = localityMap.getOrDefault("region", "");
                transportZone = localityMap.getOrDefault("zone", "");
                transportSubzone = localityMap.getOrDefault("sub_zone", "");
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to parse transport locality: " + this.transportAttrs.getLocality(), e);
        }
        this.attemptLatencies2Histogram.record(BuiltinMetricsTracer.convertToMs(this.attemptTimer.elapsed(TimeUnit.NANOSECONDS)), attributes.toBuilder().put(BuiltinMetricsConstants.TRANSPORT_TYPE, transportType).put(BuiltinMetricsConstants.TRANSPORT_REGION, transportRegion).put(BuiltinMetricsConstants.TRANSPORT_ZONE, transportZone).put(BuiltinMetricsConstants.TRANSPORT_SUBZONE, transportSubzone).build());
        if (this.operationDeadline != null) {
            this.remainingDeadlineHistogram.record(Math.max(0L, this.remainingDeadlineAtAttemptStart), attributes);
        }
        if (this.serverLatencies != null) {
            this.serverLatenciesHistogram.record(this.serverLatencies.longValue(), attributes);
            this.connectivityErrorCounter.add(0L, attributes);
        } else {
            this.connectivityErrorCounter.add(1L, attributes);
        }
    }

    private static double convertToMs(long nanoSeconds) {
        double toMs = 1.0E-6;
        return (double)nanoSeconds * toMs;
    }

    @AutoValue
    static abstract class TransportAttrs {
        TransportAttrs() {
        }

        @Nullable
        abstract String getLocality();

        @Nullable
        abstract String getBackendService();

        static TransportAttrs create(@Nullable String locality, @Nullable String backendService) {
            return new AutoValue_BuiltinMetricsTracer_TransportAttrs(locality, backendService);
        }
    }
}

