/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ExecuteQueryResumptionStrategy
implements StreamResumptionStrategy<ExecuteQueryCallContext, ExecuteQueryResponse> {
    private ByteString latestResumeToken = null;

    @Override
    @Nonnull
    public StreamResumptionStrategy<ExecuteQueryCallContext, ExecuteQueryResponse> createNew() {
        return new ExecuteQueryResumptionStrategy();
    }

    @Override
    @Nonnull
    public ExecuteQueryResponse processResponse(ExecuteQueryResponse response) {
        if (!response.getResults().getResumeToken().isEmpty()) {
            this.latestResumeToken = response.getResults().getResumeToken();
        }
        return response;
    }

    @Override
    @Nullable
    public ExecuteQueryCallContext getResumeRequest(ExecuteQueryCallContext originalRequest) {
        if (this.latestResumeToken != null) {
            originalRequest.setLatestResumeToken(this.latestResumeToken);
        }
        return originalRequest;
    }

    @Override
    public boolean canResume() {
        return true;
    }
}

