/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.PreparedStatementRefreshTimeoutException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.rpc.PreconditionFailure;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@InternalApi(value="For internal use only")
public class PlanRefreshingCallable
extends ServerStreamingCallable<ExecuteQueryCallContext, ExecuteQueryResponse> {
    private final ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> inner;
    private final RequestContext requestContext;

    public PlanRefreshingCallable(ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> inner, RequestContext requestContext) {
        this.inner = inner;
        this.requestContext = requestContext;
    }

    @Override
    public void call(ExecuteQueryCallContext executeQueryCallContext, ResponseObserver<ExecuteQueryResponse> responseObserver, @Nullable ApiCallContext apiCallContext) {
        ExecuteQueryRequest request;
        PlanRefreshingObserver observer = new PlanRefreshingObserver(responseObserver, executeQueryCallContext);
        GrpcCallContext grpcCallContext = (GrpcCallContext)apiCallContext;
        Deadline deadline = PlanRefreshingCallable.getDeadline(grpcCallContext, executeQueryCallContext.startTimeOfCall());
        try {
            request = executeQueryCallContext.buildRequestWithDeadline(this.requestContext, deadline);
        }
        catch (PreparedStatementRefreshTimeoutException e) {
            responseObserver.onError(e);
            return;
        }
        catch (Throwable throwable) {
            if (executeQueryCallContext.hasResumeToken()) {
                responseObserver.onError(new IllegalStateException("Unexpected plan refresh attempt after first token", throwable));
            }
            executeQueryCallContext.triggerImmediateRefreshOfPreparedQuery();
            responseObserver.onError(throwable);
            return;
        }
        ApiCallContext contextWithAbsoluteDeadline = Optional.ofNullable(grpcCallContext).map(c -> c.withCallOptions(grpcCallContext.getCallOptions().withDeadline(deadline))).orElse(null);
        this.inner.call(request, observer, contextWithAbsoluteDeadline);
    }

    @Nullable
    @VisibleForTesting
    static Deadline getDeadline(GrpcCallContext grpcCallContext, Instant startTimeOfOverallRequest) {
        Optional<Deadline> attemptDeadline = Optional.ofNullable(grpcCallContext).flatMap(c -> Optional.ofNullable(c.getTimeoutDuration())).map(d -> Deadline.after(d.toNanos(), TimeUnit.NANOSECONDS));
        if (attemptDeadline.isPresent()) {
            return attemptDeadline.get();
        }
        return Optional.ofNullable(grpcCallContext).flatMap(c -> Optional.ofNullable(c.getRetrySettings())).map(RetrySettings::getTotalTimeoutDuration).filter(duration -> !duration.isZero()).map(d -> {
            Duration elapsedTime = Duration.between(startTimeOfOverallRequest, Instant.now());
            Duration remaining = d.minus(elapsedTime);
            long adjusted = Math.max(remaining.toNanos(), 1L);
            return Deadline.after(adjusted, TimeUnit.NANOSECONDS);
        }).orElse(null);
    }

    @InternalApi
    static boolean isPlanRefreshError(Throwable t) {
        if (!(t instanceof ApiException)) {
            return false;
        }
        ApiException e = (ApiException)t;
        if (!e.getStatusCode().getCode().equals((Object)StatusCode.Code.FAILED_PRECONDITION)) {
            return false;
        }
        if (e.getErrorDetails() == null) {
            return false;
        }
        PreconditionFailure preconditionFailure = e.getErrorDetails().getPreconditionFailure();
        if (preconditionFailure == null) {
            return false;
        }
        for (PreconditionFailure.Violation violation : preconditionFailure.getViolationsList()) {
            if (!violation.getType().contains("PREPARED_QUERY_EXPIRED")) continue;
            return true;
        }
        return false;
    }

    static final class PlanRefreshingObserver
    extends SafeResponseObserver<ExecuteQueryResponse> {
        private final ExecuteQueryCallContext callContext;
        private final ResponseObserver<ExecuteQueryResponse> outerObserver;
        private boolean hasReceivedResumeToken;

        PlanRefreshingObserver(ResponseObserver<ExecuteQueryResponse> outerObserver, ExecuteQueryCallContext callContext) {
            super(outerObserver);
            this.outerObserver = outerObserver;
            this.callContext = callContext;
            this.hasReceivedResumeToken = false;
        }

        @Override
        protected void onStartImpl(StreamController streamController) {
            this.outerObserver.onStart(streamController);
        }

        @Override
        protected void onResponseImpl(ExecuteQueryResponse response) {
            if (!this.hasReceivedResumeToken && !response.getResults().getResumeToken().isEmpty()) {
                this.callContext.finalizeMetadata();
                this.hasReceivedResumeToken = true;
            }
            this.outerObserver.onResponse(response);
        }

        @Override
        protected void onErrorImpl(Throwable throwable) {
            boolean refreshPlan = PlanRefreshingCallable.isPlanRefreshError(throwable);
            if (refreshPlan && !this.hasReceivedResumeToken) {
                this.callContext.triggerImmediateRefreshOfPreparedQuery();
                this.outerObserver.onError(new ApiException(throwable, GrpcStatusCode.of(Status.Code.FAILED_PRECONDITION), true));
            } else if (refreshPlan) {
                this.outerObserver.onError(new IllegalStateException("Unexpected plan refresh attempt after first token", throwable));
            } else {
                this.outerObserver.onError(throwable);
            }
        }

        @Override
        protected void onCompleteImpl() {
            if (!this.callContext.resultSetMetadataFuture().isDone()) {
                this.callContext.finalizeMetadata();
            }
            this.outerObserver.onComplete();
        }
    }
}

