/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PartialResultSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.ProtoRowsMergingStateMachine;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;

@InternalApi
public final class SqlRowMerger
implements Reframer<SqlRow, ExecuteQueryResponse> {
    private final Queue<SqlRow> queue = new ArrayDeque<SqlRow>();
    private final ProtoRowsMergingStateMachine stateMachine;

    public SqlRowMerger(Supplier<ResultSetMetadata> metadataSupplier) {
        this.stateMachine = new ProtoRowsMergingStateMachine(metadataSupplier);
    }

    @Override
    public void push(ExecuteQueryResponse response) {
        Preconditions.checkState(response.hasResults(), "Expected results response, but received: %s", (Object)response.getResponseCase().name());
        PartialResultSet results = response.getResults();
        this.processProtoRows(results);
    }

    private void processProtoRows(PartialResultSet results) {
        this.stateMachine.addPartialResultSet(results);
        if (this.stateMachine.hasCompleteBatches()) {
            this.stateMachine.populateQueue(this.queue);
        }
    }

    @Override
    public boolean hasFullFrame() {
        return !this.queue.isEmpty();
    }

    @Override
    public boolean hasPartialFrame() {
        return this.hasFullFrame() || this.stateMachine.isBatchInProgress();
    }

    @Override
    public SqlRow pop() {
        return Preconditions.checkNotNull(this.queue.poll(), "SqlRowMerger.pop() called when there are no complete rows.");
    }
}

