/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.googleapis;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.io.CharStreams;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolverRegistry;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.alts.InternalCheckGcpEnvironment;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GoogleCloudToProdNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(GoogleCloudToProdNameResolver.class.getName());
    @VisibleForTesting
    static final String METADATA_URL_ZONE = "http://metadata.google.internal/computeMetadata/v1/instance/zone";
    @VisibleForTesting
    static final String METADATA_URL_SUPPORT_IPV6 = "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ipv6s";
    static final String C2P_AUTHORITY = "traffic-director-c2p.xds.googleapis.com";
    @VisibleForTesting
    static boolean isOnGcp = InternalCheckGcpEnvironment.isOnGcp();
    @VisibleForTesting
    static boolean xdsBootstrapProvided = System.getenv("GRPC_XDS_BOOTSTRAP") != null || System.getProperty("com.google.bigtable.repackaged.io.grpc.xds.bootstrap") != null || System.getenv("GRPC_XDS_BOOTSTRAP_CONFIG") != null || System.getProperty("com.google.bigtable.repackaged.io.grpc.xds.bootstrapConfig") != null;
    @VisibleForTesting
    static boolean enableFederation = Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_XDS_FEDERATION")) || Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_XDS_FEDERATION"));
    private static final String serverUriOverride = System.getenv("GRPC_TEST_ONLY_GOOGLE_C2P_RESOLVER_TRAFFIC_DIRECTOR_URI");
    private HttpConnectionProvider httpConnectionProvider = HttpConnectionFactory.INSTANCE;
    private final String authority;
    private final SynchronizationContext syncContext;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final BootstrapSetter bootstrapSetter;
    private final NameResolver delegate;
    private final Random rand;
    private final boolean usingExecutorResource;
    private final String schemeOverride = !isOnGcp || xdsBootstrapProvided && !enableFederation ? "dns" : "xds";
    private Executor executor;
    private NameResolver.Listener2 listener;
    private boolean succeeded;
    private boolean resolving;
    private boolean shutdown;

    GoogleCloudToProdNameResolver(URI targetUri, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, BootstrapSetter bootstrapSetter) {
        this(targetUri, args, executorResource, new Random(), bootstrapSetter, NameResolverRegistry.getDefaultRegistry().asFactory());
    }

    @VisibleForTesting
    GoogleCloudToProdNameResolver(URI targetUri, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, Random rand, BootstrapSetter bootstrapSetter, NameResolver.Factory nameResolverFactory) {
        this.executorResource = Preconditions.checkNotNull(executorResource, "executorResource");
        this.bootstrapSetter = Preconditions.checkNotNull(bootstrapSetter, "bootstrapSetter");
        this.rand = Preconditions.checkNotNull(rand, "rand");
        String targetPath = Preconditions.checkNotNull(Preconditions.checkNotNull(targetUri, "targetUri").getPath(), "targetPath");
        Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
        this.authority = GrpcUtil.checkAuthority(targetPath.substring(1));
        this.syncContext = Preconditions.checkNotNull(args, "args").getSynchronizationContext();
        targetUri = GoogleCloudToProdNameResolver.overrideUriScheme(targetUri, this.schemeOverride);
        if (this.schemeOverride.equals("xds") && enableFederation) {
            targetUri = GoogleCloudToProdNameResolver.overrideUriAuthority(targetUri, C2P_AUTHORITY);
        }
        this.delegate = Preconditions.checkNotNull(nameResolverFactory, "nameResolverFactory").newNameResolver(targetUri, args);
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        if (this.delegate == null) {
            listener.onError(Status.INTERNAL.withDescription("Delegate resolver not found, scheme: " + this.schemeOverride));
            return;
        }
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    private void resolve() {
        if (this.resolving || this.shutdown || this.delegate == null) {
            return;
        }
        this.resolving = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("resolve with schemaOverride = " + this.schemeOverride);
        }
        if (this.schemeOverride.equals("dns")) {
            this.delegate.start(this.listener);
            this.succeeded = true;
            this.resolving = false;
            return;
        }
        if (this.executor == null) {
            this.executor = SharedResourceHolder.get(this.executorResource);
        }
        class Resolve
        implements Runnable {
            Resolve() {
            }

            @Override
            public void run() {
                ImmutableMap rawBootstrap = null;
                try {
                    if (!enableFederation || !xdsBootstrapProvided) {
                        rawBootstrap = GoogleCloudToProdNameResolver.this.generateBootstrap(GoogleCloudToProdNameResolver.this.queryZoneMetadata(GoogleCloudToProdNameResolver.METADATA_URL_ZONE), GoogleCloudToProdNameResolver.this.queryIpv6SupportMetadata(GoogleCloudToProdNameResolver.METADATA_URL_SUPPORT_IPV6));
                    }
                    ImmutableMap finalRawBootstrap = rawBootstrap;
                    GoogleCloudToProdNameResolver.this.syncContext.execute(new Runnable(finalRawBootstrap){
                        final /* synthetic */ ImmutableMap val$finalRawBootstrap;
                        {
                            this.val$finalRawBootstrap = immutableMap;
                        }

                        @Override
                        public void run() {
                            if (!GoogleCloudToProdNameResolver.this.shutdown) {
                                if (this.val$finalRawBootstrap != null) {
                                    GoogleCloudToProdNameResolver.this.bootstrapSetter.setBootstrap(this.val$finalRawBootstrap);
                                }
                                GoogleCloudToProdNameResolver.this.delegate.start(GoogleCloudToProdNameResolver.this.listener);
                                GoogleCloudToProdNameResolver.this.succeeded = true;
                            }
                            GoogleCloudToProdNameResolver.this.resolving = false;
                        }
                    });
                }
                catch (IOException e) {
                    try {
                        GoogleCloudToProdNameResolver.this.listener.onError(Status.INTERNAL.withDescription("Unable to get metadata").withCause(e));
                        ImmutableMap finalRawBootstrap = rawBootstrap;
                        GoogleCloudToProdNameResolver.this.syncContext.execute(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Throwable throwable) {
                        ImmutableMap finalRawBootstrap = rawBootstrap;
                        GoogleCloudToProdNameResolver.this.syncContext.execute(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
        }
        this.executor.execute(new Resolve());
    }

    private ImmutableMap<String, ?> generateBootstrap(String zone, boolean supportIpv6) {
        ImmutableMap.Builder<String, Object> nodeBuilder = ImmutableMap.builder();
        nodeBuilder.put("id", "C2P-" + (this.rand.nextInt() & Integer.MAX_VALUE));
        if (!zone.isEmpty()) {
            nodeBuilder.put("locality", ImmutableMap.of("zone", zone));
        }
        if (supportIpv6) {
            nodeBuilder.put("metadata", ImmutableMap.of("TRAFFICDIRECTOR_DIRECTPATH_C2P_IPV6_CAPABLE", true));
        }
        ImmutableMap.Builder<String, Object> serverBuilder = ImmutableMap.builder();
        String serverUri = "directpath-pa.googleapis.com";
        if (serverUriOverride != null && serverUriOverride.length() > 0) {
            serverUri = serverUriOverride;
        }
        serverBuilder.put("server_uri", serverUri);
        serverBuilder.put("channel_creds", ImmutableList.of(ImmutableMap.of("type", "google_default")));
        serverBuilder.put("server_features", ImmutableList.of("xds_v3", "ignore_resource_deletion"));
        ImmutableMap.Builder authoritiesBuilder = ImmutableMap.builder();
        authoritiesBuilder.put(C2P_AUTHORITY, ImmutableMap.of("xds_servers", ImmutableList.of(serverBuilder.buildOrThrow())));
        return ImmutableMap.of("node", nodeBuilder.buildOrThrow(), "xds_servers", ImmutableList.of(serverBuilder.buildOrThrow()), "authorities", authoritiesBuilder.buildOrThrow());
    }

    @Override
    public void refresh() {
        if (this.succeeded) {
            this.delegate.refresh();
        } else if (!this.resolving) {
            this.resolve();
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryZoneMetadata(String url) throws IOException {
        String respBody;
        HttpURLConnection con = null;
        try {
            con = this.httpConnectionProvider.createConnection(url);
            if (con.getResponseCode() != 200) {
                String string = "";
                return string;
            }
            try (InputStreamReader reader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);){
                respBody = CharStreams.toString(reader);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        int index = respBody.lastIndexOf(47);
        return index == -1 ? "" : respBody.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryIpv6SupportMetadata(String url) throws IOException {
        HttpURLConnection con = null;
        try {
            int c;
            con = this.httpConnectionProvider.createConnection(url);
            if (con.getResponseCode() != 200) {
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = con.getInputStream();
            boolean bl = inputStream != null && (c = inputStream.read()) != -1 && !Character.isWhitespace(c);
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @VisibleForTesting
    void setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
    }

    private static URI overrideUriScheme(URI uri, String scheme) {
        URI res;
        try {
            res = new URI(scheme, uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid scheme: " + scheme, ex);
        }
        return res;
    }

    private static URI overrideUriAuthority(URI uri, String authority) {
        URI res;
        try {
            res = new URI(uri.getScheme(), authority, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid authority: " + authority, ex);
        }
        return res;
    }

    public static interface BootstrapSetter {
        public void setBootstrap(Map<String, ?> var1);
    }

    @VisibleForTesting
    static interface HttpConnectionProvider {
        public HttpURLConnection createConnection(String var1) throws IOException;
    }

    private static enum HttpConnectionFactory implements HttpConnectionProvider
    {
        INSTANCE;


        @Override
        public HttpURLConnection createConnection(String url) throws IOException {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(10000);
            con.setRequestProperty("Metadata-Flavor", "Google");
            return con;
        }
    }
}

