/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.rls;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Converter;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Ticker;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.io.grpc.ChannelLogger;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LongCounterMetricInstrument;
import com.google.bigtable.repackaged.io.grpc.LongGaugeMetricInstrument;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MetricInstrumentRegistry;
import com.google.bigtable.repackaged.io.grpc.MetricRecorder;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.ExponentialBackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.lookup.v1.RouteLookupRequest;
import com.google.bigtable.repackaged.io.grpc.lookup.v1.RouteLookupResponse;
import com.google.bigtable.repackaged.io.grpc.lookup.v1.RouteLookupServiceGrpc;
import com.google.bigtable.repackaged.io.grpc.rls.ChildLoadBalancerHelper;
import com.google.bigtable.repackaged.io.grpc.rls.LbPolicyConfiguration;
import com.google.bigtable.repackaged.io.grpc.rls.LinkedHashLruCache;
import com.google.bigtable.repackaged.io.grpc.rls.LruCache;
import com.google.bigtable.repackaged.io.grpc.rls.ResolvedAddressFactory;
import com.google.bigtable.repackaged.io.grpc.rls.RlsProtoConverters;
import com.google.bigtable.repackaged.io.grpc.rls.RlsProtoData;
import com.google.bigtable.repackaged.io.grpc.rls.RlsRequestFactory;
import com.google.bigtable.repackaged.io.grpc.rls.SubchannelStateManagerImpl;
import com.google.bigtable.repackaged.io.grpc.rls.Throttler;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancerHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CachingRlsLbClient {
    private static final Converter<RlsProtoData.RouteLookupRequest, RouteLookupRequest> REQUEST_CONVERTER = new RlsProtoConverters.RouteLookupRequestConverter().reverse();
    private static final Converter<RlsProtoData.RouteLookupResponse, RouteLookupResponse> RESPONSE_CONVERTER = new RlsProtoConverters.RouteLookupResponseConverter().reverse();
    public static final long MIN_EVICTION_TIME_DELTA_NANOS = TimeUnit.SECONDS.toNanos(5L);
    public static final int BYTES_PER_CHAR = 2;
    public static final int STRING_OVERHEAD_BYTES = 38;
    public static final int OBJ_OVERHEAD_B = 16;
    private static final LongCounterMetricInstrument DEFAULT_TARGET_PICKS_COUNTER;
    private static final LongCounterMetricInstrument TARGET_PICKS_COUNTER;
    private static final LongCounterMetricInstrument FAILED_PICKS_COUNTER;
    private static final LongGaugeMetricInstrument CACHE_ENTRIES_GAUGE;
    private static final LongGaugeMetricInstrument CACHE_SIZE_GAUGE;
    private final MetricRecorder.Registration gaugeRegistration;
    private final String metricsInstanceUuid = UUID.randomUUID().toString();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final RlsAsyncLruCache linkedHashLruCache;
    private final Future<?> periodicCleaner;
    @GuardedBy(value="lock")
    private final Map<RlsProtoData.RouteLookupRequest, PendingCacheEntry> pendingCallCache = new HashMap<RlsProtoData.RouteLookupRequest, PendingCacheEntry>();
    private final ScheduledExecutorService scheduledExecutorService;
    private final Ticker ticker;
    private final Throttler throttler;
    private final LbPolicyConfiguration lbPolicyConfig;
    private final BackoffPolicy.Provider backoffProvider;
    private final long maxAgeNanos;
    private final long staleAgeNanos;
    private final long callTimeoutNanos;
    private final RlsLbHelper helper;
    private final ManagedChannel rlsChannel;
    private final RouteLookupServiceGrpc.RouteLookupServiceStub rlsStub;
    private final RlsPicker rlsPicker;
    private final ResolvedAddressFactory childLbResolvedAddressFactory;
    @GuardedBy(value="lock")
    private final LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory refCountedChildPolicyWrapperFactory;
    private final ChannelLogger logger;
    @VisibleForTesting
    static final Metadata.Key<String> RLS_DATA_KEY;

    private CachingRlsLbClient(Builder builder) {
        this.helper = new RlsLbHelper(Preconditions.checkNotNull(builder.helper, "helper"));
        this.scheduledExecutorService = this.helper.getScheduledExecutorService();
        this.lbPolicyConfig = Preconditions.checkNotNull(builder.lbPolicyConfig, "lbPolicyConfig");
        final RlsProtoData.RouteLookupConfig rlsConfig = this.lbPolicyConfig.getRouteLookupConfig();
        this.maxAgeNanos = rlsConfig.maxAgeInNanos();
        this.staleAgeNanos = rlsConfig.staleAgeInNanos();
        this.callTimeoutNanos = rlsConfig.lookupServiceTimeoutInNanos();
        this.ticker = Preconditions.checkNotNull(builder.ticker, "ticker");
        this.throttler = Preconditions.checkNotNull(builder.throttler, "throttler");
        this.linkedHashLruCache = new RlsAsyncLruCache(rlsConfig.cacheSizeBytes(), new AutoCleaningEvictionListener(builder.evictionListener), this.ticker, this.helper);
        this.periodicCleaner = this.scheduledExecutorService.scheduleAtFixedRate(this::periodicClean, 1L, 1L, TimeUnit.MINUTES);
        this.logger = this.helper.getChannelLogger();
        String serverHost = null;
        try {
            serverHost = new URI(null, this.helper.getAuthority(), null, null, null).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (serverHost == null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Can not get hostname from authority: {0}", this.helper.getAuthority());
            serverHost = this.helper.getAuthority();
        }
        RlsRequestFactory requestFactory = new RlsRequestFactory(this.lbPolicyConfig.getRouteLookupConfig(), serverHost);
        this.rlsPicker = new RlsPicker(requestFactory, rlsConfig.lookupService());
        ManagedChannelBuilder<?> rlsChannelBuilder = this.helper.createResolvingOobChannelBuilder(rlsConfig.lookupService(), this.helper.getUnsafeChannelCredentials());
        rlsChannelBuilder.overrideAuthority(this.helper.getAuthority());
        Map<String, ?> routeLookupChannelServiceConfig = this.lbPolicyConfig.getRouteLookupChannelServiceConfig();
        if (routeLookupChannelServiceConfig != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS channel service config: {0}", routeLookupChannelServiceConfig);
            rlsChannelBuilder.defaultServiceConfig(routeLookupChannelServiceConfig);
            rlsChannelBuilder.disableServiceConfigLookUp();
        }
        this.rlsChannel = rlsChannelBuilder.build();
        this.rlsStub = RouteLookupServiceGrpc.newStub(this.rlsChannel);
        this.childLbResolvedAddressFactory = Preconditions.checkNotNull(builder.resolvedAddressFactory, "resolvedAddressFactory");
        this.backoffProvider = builder.backoffProvider;
        ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider = new ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider(this.helper, new SubchannelStateManagerImpl(), this.rlsPicker);
        this.refCountedChildPolicyWrapperFactory = new LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory(this.lbPolicyConfig.getLoadBalancingPolicy(), this.childLbResolvedAddressFactory, childLbHelperProvider, new BackoffRefreshListener());
        this.gaugeRegistration = this.helper.getMetricRecorder().registerBatchCallback(new MetricRecorder.BatchCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(MetricRecorder.BatchRecorder recorder) {
                long estimatedSizeBytes;
                int estimatedSize;
                Object object = CachingRlsLbClient.this.lock;
                synchronized (object) {
                    estimatedSize = CachingRlsLbClient.this.linkedHashLruCache.estimatedSize();
                    estimatedSizeBytes = CachingRlsLbClient.this.linkedHashLruCache.estimatedSizeBytes();
                }
                recorder.recordLongGauge(CACHE_ENTRIES_GAUGE, estimatedSize, Arrays.asList(CachingRlsLbClient.this.helper.getChannelTarget(), rlsConfig.lookupService(), CachingRlsLbClient.this.metricsInstanceUuid), Collections.emptyList());
                recorder.recordLongGauge(CACHE_SIZE_GAUGE, estimatedSizeBytes, Arrays.asList(CachingRlsLbClient.this.helper.getChannelTarget(), rlsConfig.lookupService(), CachingRlsLbClient.this.metricsInstanceUuid), Collections.emptyList());
            }
        }, CACHE_ENTRIES_GAUGE, CACHE_SIZE_GAUGE);
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        Object object = this.lock;
        synchronized (object) {
            this.refCountedChildPolicyWrapperFactory.init();
        }
    }

    static Status convertRlsServerStatus(Status status, String serverName) {
        return Status.UNAVAILABLE.withCause(status.getCause()).withDescription(String.format("Unable to retrieve RLS targets from RLS server %s.  RLS server returned: %s: %s", new Object[]{serverName, status.getCode(), status.getDescription()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicClean() {
        Object object = this.lock;
        synchronized (object) {
            this.linkedHashLruCache.cleanupExpiredEntries();
        }
    }

    @GuardedBy(value="lock")
    private CachedRouteLookupResponse asyncRlsCall(final RlsProtoData.RouteLookupRequest request, @Nullable BackoffPolicy backoffPolicy) {
        if (this.throttler.shouldThrottle()) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Throttled RouteLookup", request);
            return CachedRouteLookupResponse.backoffEntry(this.createBackOffEntry(request, Status.RESOURCE_EXHAUSTED.withDescription("RLS throttled"), backoffPolicy));
        }
        final SettableFuture<RlsProtoData.RouteLookupResponse> response = SettableFuture.create();
        RouteLookupRequest routeLookupRequest = REQUEST_CONVERTER.convert(request);
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Starting RouteLookup: {1}", request, routeLookupRequest);
        ((RouteLookupServiceGrpc.RouteLookupServiceStub)this.rlsStub.withDeadlineAfter(this.callTimeoutNanos, TimeUnit.NANOSECONDS)).routeLookup(routeLookupRequest, new StreamObserver<RouteLookupResponse>(){

            @Override
            public void onNext(RouteLookupResponse value) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] RouteLookup succeeded: {1}", request, value);
                response.set((RlsProtoData.RouteLookupResponse)RESPONSE_CONVERTER.reverse().convert(value));
            }

            @Override
            public void onError(Throwable t) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] RouteLookup failed: {1}", request, t);
                response.setException(t);
                CachingRlsLbClient.this.throttler.registerBackendResponse(true);
            }

            @Override
            public void onCompleted() {
                CachingRlsLbClient.this.throttler.registerBackendResponse(false);
            }
        });
        return CachedRouteLookupResponse.pendingResponse(this.createPendingEntry(request, response, backoffPolicy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    final CachedRouteLookupResponse get(RlsProtoData.RouteLookupRequest request) {
        Object object = this.lock;
        synchronized (object) {
            CacheEntry cacheEntry = (CacheEntry)this.linkedHashLruCache.read(request);
            if (cacheEntry == null) {
                PendingCacheEntry pendingEntry = this.pendingCallCache.get(request);
                if (pendingEntry != null) {
                    return CachedRouteLookupResponse.pendingResponse(pendingEntry);
                }
                return this.asyncRlsCall(request, null);
            }
            if (cacheEntry instanceof DataCacheEntry) {
                DataCacheEntry dataEntry = (DataCacheEntry)cacheEntry;
                if (dataEntry.isStaled(this.ticker.read())) {
                    dataEntry.maybeRefresh();
                }
                return CachedRouteLookupResponse.dataEntry((DataCacheEntry)cacheEntry);
            }
            return CachedRouteLookupResponse.backoffEntry((BackoffCacheEntry)cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient closed");
        Object object = this.lock;
        synchronized (object) {
            this.periodicCleaner.cancel(false);
            this.linkedHashLruCache.close();
            this.pendingCallCache.clear();
            this.rlsChannel.shutdownNow();
            this.rlsPicker.close();
            this.gaugeRegistration.close();
        }
    }

    void requestConnection() {
        this.rlsChannel.getState(true);
    }

    @GuardedBy(value="lock")
    private PendingCacheEntry createPendingEntry(RlsProtoData.RouteLookupRequest request, ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall, @Nullable BackoffPolicy backoffPolicy) {
        PendingCacheEntry entry = new PendingCacheEntry(request, pendingCall, backoffPolicy);
        this.pendingCallCache.put(request, entry);
        pendingCall.addListener(() -> this.pendingRpcComplete(entry), MoreExecutors.directExecutor());
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pendingRpcComplete(PendingCacheEntry entry) {
        Object object = this.lock;
        synchronized (object) {
            boolean clientClosed;
            boolean bl = clientClosed = this.pendingCallCache.remove(entry.request) == null;
            if (clientClosed) {
                return;
            }
            try {
                this.createDataEntry(entry.request, (RlsProtoData.RouteLookupResponse)Futures.getDone(entry.pendingCall));
            }
            catch (Exception e) {
                this.createBackOffEntry(entry.request, Status.fromThrowable(e), entry.backoffPolicy);
                this.helper.triggerPendingRpcProcessing();
            }
        }
    }

    @GuardedBy(value="lock")
    private DataCacheEntry createDataEntry(RlsProtoData.RouteLookupRequest request, RlsProtoData.RouteLookupResponse routeLookupResponse) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Transition to data cache: routeLookupResponse={1}", request, routeLookupResponse);
        DataCacheEntry entry = new DataCacheEntry(request, routeLookupResponse);
        this.linkedHashLruCache.cacheAndClean(request, entry);
        return entry;
    }

    @GuardedBy(value="lock")
    private BackoffCacheEntry createBackOffEntry(RlsProtoData.RouteLookupRequest request, Status status, @Nullable BackoffPolicy backoffPolicy) {
        if (backoffPolicy == null) {
            backoffPolicy = this.backoffProvider.get();
        }
        long delayNanos = backoffPolicy.nextBackoffNanos();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Transition to back off: status={1}, delayNanos={2}", request, status, delayNanos);
        BackoffCacheEntry entry = new BackoffCacheEntry(request, status, backoffPolicy);
        entry.scheduledFuture = this.scheduledExecutorService.schedule(() -> this.refreshBackoffEntry(entry), delayNanos, TimeUnit.NANOSECONDS);
        this.linkedHashLruCache.cacheAndClean(request, entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBackoffEntry(BackoffCacheEntry entry) {
        Object object = this.lock;
        synchronized (object) {
            if (!entry.scheduledFuture.cancel(false)) {
                return;
            }
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Calling RLS for transition to pending", entry.request);
            this.linkedHashLruCache.invalidate(entry.request);
            this.asyncRlsCall(entry.request, entry.backoffPolicy);
        }
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static {
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        DEFAULT_TARGET_PICKS_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.rls.default_target_picks", "EXPERIMENTAL. Number of LB picks sent to the default target", "{pick}", Arrays.asList("grpc.target", "grpc.lb.rls.server_target", "grpc.lb.rls.data_plane_target", "grpc.lb.pick_result"), Collections.emptyList(), false);
        TARGET_PICKS_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.rls.target_picks", "EXPERIMENTAL. Number of LB picks sent to each RLS target. Note that if the default target is also returned by the RLS server, RPCs sent to that target from the cache will be counted in this metric, not in grpc.rls.default_target_picks.", "{pick}", Arrays.asList("grpc.target", "grpc.lb.rls.server_target", "grpc.lb.rls.data_plane_target", "grpc.lb.pick_result"), Collections.emptyList(), false);
        FAILED_PICKS_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.rls.failed_picks", "EXPERIMENTAL. Number of LB picks failed due to either a failed RLS request or the RLS channel being throttled", "{pick}", Arrays.asList("grpc.target", "grpc.lb.rls.server_target"), Collections.emptyList(), false);
        CACHE_ENTRIES_GAUGE = metricInstrumentRegistry.registerLongGauge("grpc.lb.rls.cache_entries", "EXPERIMENTAL. Number of entries in the RLS cache", "{entry}", Arrays.asList("grpc.target", "grpc.lb.rls.server_target", "grpc.lb.rls.instance_uuid"), Collections.emptyList(), false);
        CACHE_SIZE_GAUGE = metricInstrumentRegistry.registerLongGauge("grpc.lb.rls.cache_size", "EXPERIMENTAL. The current size of the RLS cache", "By", Arrays.asList("grpc.target", "grpc.lb.rls.server_target", "grpc.lb.rls.instance_uuid"), Collections.emptyList(), false);
        RLS_DATA_KEY = Metadata.Key.of("X-Google-RLS-Data", Metadata.ASCII_STRING_MARSHALLER);
    }

    final class RlsPicker
    extends LoadBalancer.SubchannelPicker {
        private final RlsRequestFactory requestFactory;
        private final String lookupService;
        private LbPolicyConfiguration.ChildPolicyWrapper fallbackChildPolicyWrapper;

        RlsPicker(RlsRequestFactory requestFactory, String lookupService) {
            this.requestFactory = Preconditions.checkNotNull(requestFactory, "requestFactory");
            this.lookupService = Preconditions.checkNotNull(lookupService, "rlsConfig");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            String defaultTarget;
            boolean hasFallback;
            String methodName;
            String serviceName = args.getMethodDescriptor().getServiceName();
            RlsProtoData.RouteLookupRequest request = this.requestFactory.create(serviceName, methodName = args.getMethodDescriptor().getBareMethodName(), args.getHeaders());
            CachedRouteLookupResponse response = CachingRlsLbClient.this.get(request);
            if (response.getHeaderData() != null && !response.getHeaderData().isEmpty()) {
                Metadata headers = args.getHeaders();
                headers.discardAll(RLS_DATA_KEY);
                headers.put(RLS_DATA_KEY, response.getHeaderData());
            }
            boolean bl = hasFallback = (defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().defaultTarget()) != null && !defaultTarget.isEmpty();
            if (response.hasData()) {
                LoadBalancer.SubchannelPicker picker;
                LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper = response.getChildPolicyWrapper();
                LoadBalancer.SubchannelPicker subchannelPicker = picker = childPolicyWrapper != null ? childPolicyWrapper.getPicker() : null;
                if (picker == null) {
                    return LoadBalancer.PickResult.withNoResult();
                }
                LoadBalancer.PickResult pickResult = picker.pickSubchannel(args);
                if (pickResult.hasResult()) {
                    CachingRlsLbClient.this.helper.getMetricRecorder().addLongCounter(TARGET_PICKS_COUNTER, 1L, Arrays.asList(CachingRlsLbClient.this.helper.getChannelTarget(), this.lookupService, childPolicyWrapper.getTarget(), this.determineMetricsPickResult(pickResult)), Collections.emptyList());
                }
                return pickResult;
            }
            if (response.hasError()) {
                if (hasFallback) {
                    return this.useFallback(args);
                }
                CachingRlsLbClient.this.helper.getMetricRecorder().addLongCounter(FAILED_PICKS_COUNTER, 1L, Arrays.asList(CachingRlsLbClient.this.helper.getChannelTarget(), this.lookupService), Collections.emptyList());
                return LoadBalancer.PickResult.withError(CachingRlsLbClient.convertRlsServerStatus(response.getStatus(), CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().lookupService()));
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        private LoadBalancer.PickResult useFallback(LoadBalancer.PickSubchannelArgs args) {
            this.startFallbackChildPolicy();
            LoadBalancer.SubchannelPicker picker = this.fallbackChildPolicyWrapper.getPicker();
            if (picker == null) {
                return LoadBalancer.PickResult.withNoResult();
            }
            LoadBalancer.PickResult pickResult = picker.pickSubchannel(args);
            if (pickResult.hasResult()) {
                CachingRlsLbClient.this.helper.getMetricRecorder().addLongCounter(DEFAULT_TARGET_PICKS_COUNTER, 1L, Arrays.asList(CachingRlsLbClient.this.helper.getChannelTarget(), this.lookupService, this.fallbackChildPolicyWrapper.getTarget(), this.determineMetricsPickResult(pickResult)), Collections.emptyList());
            }
            return pickResult;
        }

        private String determineMetricsPickResult(LoadBalancer.PickResult pickResult) {
            if (pickResult.getStatus().isOk()) {
                return "complete";
            }
            if (pickResult.isDrop()) {
                return "drop";
            }
            return "fail";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFallbackChildPolicy() {
            String defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().defaultTarget();
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.fallbackChildPolicyWrapper != null) {
                    return;
                }
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "starting fallback to {0}", defaultTarget);
                this.fallbackChildPolicyWrapper = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet(defaultTarget);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.fallbackChildPolicyWrapper != null) {
                    CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(this.fallbackChildPolicyWrapper);
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("target", CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().lookupService()).toString();
        }
    }

    private final class BackoffRefreshListener
    implements LbPolicyConfiguration.ChildLbStatusListener {
        @Nullable
        private ConnectivityState prevState = null;

        private BackoffRefreshListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(ConnectivityState newState) {
            if (this.prevState == ConnectivityState.TRANSIENT_FAILURE && newState == ConnectivityState.READY) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Transitioning from TRANSIENT_FAILURE to READY");
                Object object = CachingRlsLbClient.this.lock;
                synchronized (object) {
                    for (CacheEntry value : CachingRlsLbClient.this.linkedHashLruCache.values()) {
                        if (!(value instanceof BackoffCacheEntry)) continue;
                        CachingRlsLbClient.this.refreshBackoffEntry((BackoffCacheEntry)value);
                    }
                }
            }
            this.prevState = newState;
        }
    }

    private static final class RlsAsyncLruCache
    extends LinkedHashLruCache<RlsProtoData.RouteLookupRequest, CacheEntry> {
        private final RlsLbHelper helper;

        RlsAsyncLruCache(long maxEstimatedSizeBytes, @Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener, Ticker ticker, RlsLbHelper helper) {
            super(maxEstimatedSizeBytes, evictionListener, ticker);
            this.helper = Preconditions.checkNotNull(helper, "helper");
        }

        @Override
        protected boolean isExpired(RlsProtoData.RouteLookupRequest key, CacheEntry value, long nowNanos) {
            return value.isExpired(nowNanos);
        }

        @Override
        protected int estimateSizeOf(RlsProtoData.RouteLookupRequest key, CacheEntry value) {
            return value.getSizeBytes();
        }

        @Override
        protected boolean shouldInvalidateEldestEntry(RlsProtoData.RouteLookupRequest eldestKey, CacheEntry eldestValue, long now) {
            if (!eldestValue.isOldEnoughToBeEvicted(now)) {
                return false;
            }
            return this.estimatedSizeBytes() > this.estimatedMaxSizeBytes();
        }

        public CacheEntry cacheAndClean(RlsProtoData.RouteLookupRequest key, CacheEntry value) {
            CacheEntry newEntry = this.cache(key, value);
            if (this.fitToLimit()) {
                this.helper.triggerPendingRpcProcessing();
            }
            return newEntry;
        }
    }

    private static final class HappyThrottler
    implements Throttler {
        private HappyThrottler() {
        }

        @Override
        public boolean shouldThrottle() {
            return false;
        }

        @Override
        public void registerBackendResponse(boolean throttled) {
        }
    }

    private static final class AutoCleaningEvictionListener
    implements LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> {
        private final LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate;

        AutoCleaningEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEviction(RlsProtoData.RouteLookupRequest key, CacheEntry value, LruCache.EvictionType cause) {
            if (this.delegate != null) {
                this.delegate.onEviction(key, value, cause);
            }
            value.cleanup();
        }
    }

    static final class Builder {
        private LoadBalancer.Helper helper;
        private LbPolicyConfiguration lbPolicyConfig;
        private Throttler throttler = new HappyThrottler();
        private ResolvedAddressFactory resolvedAddressFactory;
        private Ticker ticker = Ticker.systemTicker();
        private LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener;
        private BackoffPolicy.Provider backoffProvider = new ExponentialBackoffPolicy.Provider();

        Builder() {
        }

        Builder setHelper(LoadBalancer.Helper helper) {
            this.helper = Preconditions.checkNotNull(helper, "helper");
            return this;
        }

        Builder setLbPolicyConfig(LbPolicyConfiguration lbPolicyConfig) {
            this.lbPolicyConfig = Preconditions.checkNotNull(lbPolicyConfig, "lbPolicyConfig");
            return this;
        }

        Builder setThrottler(Throttler throttler) {
            this.throttler = Preconditions.checkNotNull(throttler, "throttler");
            return this;
        }

        Builder setResolvedAddressesFactory(ResolvedAddressFactory resolvedAddressFactory) {
            this.resolvedAddressFactory = Preconditions.checkNotNull(resolvedAddressFactory, "resolvedAddressFactory");
            return this;
        }

        Builder setTicker(Ticker ticker) {
            this.ticker = Preconditions.checkNotNull(ticker, "ticker");
            return this;
        }

        Builder setEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener) {
            this.evictionListener = evictionListener;
            return this;
        }

        Builder setBackoffProvider(BackoffPolicy.Provider provider) {
            this.backoffProvider = Preconditions.checkNotNull(provider, "provider");
            return this;
        }

        CachingRlsLbClient build() {
            CachingRlsLbClient client = new CachingRlsLbClient(this);
            client.init();
            return client;
        }
    }

    private static final class BackoffCacheEntry
    extends CacheEntry {
        private final Status status;
        private final BackoffPolicy backoffPolicy;
        private Future<?> scheduledFuture;

        BackoffCacheEntry(RlsProtoData.RouteLookupRequest request, Status status, BackoffPolicy backoffPolicy) {
            super(request);
            this.status = Preconditions.checkNotNull(status, "status");
            this.backoffPolicy = Preconditions.checkNotNull(backoffPolicy, "backoffPolicy");
        }

        Status getStatus() {
            return this.status;
        }

        @Override
        int getSizeBytes() {
            return 120;
        }

        @Override
        boolean isExpired(long now) {
            return this.scheduledFuture.isDone();
        }

        @Override
        void cleanup() {
            this.scheduledFuture.cancel(false);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("request", this.request).add("status", this.status).toString();
        }
    }

    final class DataCacheEntry
    extends CacheEntry {
        private final RlsProtoData.RouteLookupResponse response;
        private final long minEvictionTime;
        private final long expireTime;
        private final long staleTime;
        private final List<LbPolicyConfiguration.ChildPolicyWrapper> childPolicyWrappers;

        DataCacheEntry(RlsProtoData.RouteLookupRequest request, RlsProtoData.RouteLookupResponse response) {
            super(request);
            this.response = Preconditions.checkNotNull(response, "response");
            Preconditions.checkState(!response.targets().isEmpty(), "No targets returned by RLS");
            this.childPolicyWrappers = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet(response.targets());
            long now = CachingRlsLbClient.this.ticker.read();
            this.minEvictionTime = now + MIN_EVICTION_TIME_DELTA_NANOS;
            this.expireTime = now + CachingRlsLbClient.this.maxAgeNanos;
            this.staleTime = now + CachingRlsLbClient.this.staleAgeNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeRefresh() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (CachingRlsLbClient.this.pendingCallCache.containsKey(this.request)) {
                    return;
                }
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[RLS Entry {0}] Cache entry is stale, refreshing", this.request);
                CachingRlsLbClient.this.asyncRlsCall(this.request, null);
            }
        }

        @VisibleForTesting
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper(String target) {
            for (LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper : this.childPolicyWrappers) {
                if (!childPolicyWrapper.getTarget().equals(target)) continue;
                return childPolicyWrapper;
            }
            throw new RuntimeException("Target not found:" + target);
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            for (LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper : this.childPolicyWrappers) {
                if (childPolicyWrapper.getState() == ConnectivityState.TRANSIENT_FAILURE) continue;
                return childPolicyWrapper;
            }
            return this.childPolicyWrappers.get(0);
        }

        String getHeaderData() {
            return this.response.getHeaderData();
        }

        int calcStringSize(String target) {
            return target.length() * 2 + 38;
        }

        @Override
        int getSizeBytes() {
            int targetSize = 0;
            for (String target : this.response.targets()) {
                targetSize += this.calcStringSize(target);
            }
            return targetSize + this.calcStringSize(this.response.getHeaderData()) + 16 + 128 + 16;
        }

        @Override
        boolean isExpired(long now) {
            return this.expireTime - now <= 0L;
        }

        boolean isStaled(long now) {
            return this.staleTime - now <= 0L;
        }

        @Override
        protected boolean isOldEnoughToBeEvicted(long now) {
            return this.minEvictionTime - now <= 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void cleanup() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                for (LbPolicyConfiguration.ChildPolicyWrapper policyWrapper : this.childPolicyWrappers) {
                    CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(policyWrapper);
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("request", this.request).add("response", this.response).add("expireTime", this.expireTime).add("staleTime", this.staleTime).add("childPolicyWrappers", this.childPolicyWrappers).toString();
        }
    }

    static abstract class CacheEntry {
        protected final RlsProtoData.RouteLookupRequest request;

        CacheEntry(RlsProtoData.RouteLookupRequest request) {
            this.request = Preconditions.checkNotNull(request, "request");
        }

        abstract int getSizeBytes();

        abstract boolean isExpired(long var1);

        abstract void cleanup();

        protected boolean isOldEnoughToBeEvicted(long now) {
            return true;
        }
    }

    static final class PendingCacheEntry {
        private final ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall;
        private final RlsProtoData.RouteLookupRequest request;
        @Nullable
        private final BackoffPolicy backoffPolicy;

        PendingCacheEntry(RlsProtoData.RouteLookupRequest request, ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall, @Nullable BackoffPolicy backoffPolicy) {
            this.request = Preconditions.checkNotNull(request, "request");
            this.pendingCall = Preconditions.checkNotNull(pendingCall, "pendingCall");
            this.backoffPolicy = backoffPolicy;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("request", this.request).toString();
        }
    }

    static final class CachedRouteLookupResponse {
        @Nullable
        private final DataCacheEntry dataCacheEntry;
        @Nullable
        private final PendingCacheEntry pendingCacheEntry;
        @Nullable
        private final BackoffCacheEntry backoffCacheEntry;

        CachedRouteLookupResponse(DataCacheEntry dataCacheEntry, PendingCacheEntry pendingCacheEntry, BackoffCacheEntry backoffCacheEntry) {
            this.dataCacheEntry = dataCacheEntry;
            this.pendingCacheEntry = pendingCacheEntry;
            this.backoffCacheEntry = backoffCacheEntry;
            Preconditions.checkState(dataCacheEntry != null ^ pendingCacheEntry != null ^ backoffCacheEntry != null && (dataCacheEntry == null || pendingCacheEntry == null || backoffCacheEntry == null), "Expected only 1 cache entry value provided");
        }

        static CachedRouteLookupResponse pendingResponse(PendingCacheEntry pendingEntry) {
            return new CachedRouteLookupResponse(null, pendingEntry, null);
        }

        static CachedRouteLookupResponse backoffEntry(BackoffCacheEntry backoffEntry) {
            return new CachedRouteLookupResponse(null, null, backoffEntry);
        }

        static CachedRouteLookupResponse dataEntry(DataCacheEntry dataEntry) {
            return new CachedRouteLookupResponse(dataEntry, null, null);
        }

        boolean hasData() {
            return this.dataCacheEntry != null;
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getChildPolicyWrapper();
        }

        @Nullable
        @VisibleForTesting
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper(String target) {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getChildPolicyWrapper(target);
        }

        @Nullable
        String getHeaderData() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getHeaderData();
        }

        boolean hasError() {
            return this.backoffCacheEntry != null;
        }

        boolean isPending() {
            return this.pendingCacheEntry != null;
        }

        @Nullable
        Status getStatus() {
            if (!this.hasError()) {
                return null;
            }
            return this.backoffCacheEntry.getStatus();
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
            if (this.dataCacheEntry != null) {
                toStringHelper.add("dataCacheEntry", this.dataCacheEntry);
            }
            if (this.pendingCacheEntry != null) {
                toStringHelper.add("pendingCacheEntry", this.pendingCacheEntry);
            }
            if (this.backoffCacheEntry != null) {
                toStringHelper.add("backoffCacheEntry", this.backoffCacheEntry);
            }
            return toStringHelper.toString();
        }
    }

    private static final class RlsLbHelper
    extends ForwardingLoadBalancerHelper {
        final LoadBalancer.Helper helper;
        private ConnectivityState state;
        private LoadBalancer.SubchannelPicker picker;

        RlsLbHelper(LoadBalancer.Helper helper) {
            this.helper = helper;
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.helper;
        }

        @Override
        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.state = newState;
            this.picker = newPicker;
            super.updateBalancingState(newState, newPicker);
        }

        void triggerPendingRpcProcessing() {
            Preconditions.checkState(this.state != null, "updateBalancingState hasn't yet been called");
            this.helper.getSynchronizationContext().execute(() -> super.updateBalancingState(this.state, this.picker));
        }
    }
}

