/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.IdTokenCredentials;
import com.google.bigtable.repackaged.com.google.common.primitives.UnsignedLongs;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.io.grpc.CallCredentials;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.CompositeCallCredentials;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.auth.MoreCallCredentials;
import com.google.bigtable.repackaged.io.grpc.xds.ConfigOrError;
import com.google.bigtable.repackaged.io.grpc.xds.Filter;
import com.google.bigtable.repackaged.io.grpc.xds.MetadataRegistry;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.Audience;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.GcpAuthnFilterConfig;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.TokenCacheConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;

final class GcpAuthenticationFilter
implements Filter,
Filter.ClientInterceptorBuilder {
    static final String TYPE_URL = "type.googleapis.com/envoy.extensions.filters.http.gcp_authn.v3.GcpAuthnFilterConfig";

    GcpAuthenticationFilter() {
    }

    @Override
    public String[] typeUrls() {
        return new String[]{TYPE_URL};
    }

    @Override
    public ConfigOrError<? extends Filter.FilterConfig> parseFilterConfig(Message rawProtoMessage) {
        GcpAuthnFilterConfig gcpAuthnProto;
        if (!(rawProtoMessage instanceof Any)) {
            return ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
        }
        Any anyMessage = (Any)rawProtoMessage;
        try {
            gcpAuthnProto = anyMessage.unpack(GcpAuthnFilterConfig.class);
        }
        catch (InvalidProtocolBufferException e) {
            return ConfigOrError.fromError("Invalid proto: " + e);
        }
        long cacheSize = 10L;
        if (gcpAuthnProto.hasCacheConfig()) {
            TokenCacheConfig cacheConfig = gcpAuthnProto.getCacheConfig();
            cacheSize = cacheConfig.getCacheSize().getValue();
            if (cacheSize == 0L) {
                return ConfigOrError.fromError("cache_config.cache_size must be greater than zero");
            }
            cacheSize = UnsignedLongs.min(cacheSize, 0x7FFFFFFEL);
        }
        GcpAuthenticationConfig config = new GcpAuthenticationConfig((int)cacheSize);
        return ConfigOrError.fromConfig(config);
    }

    @Override
    public ConfigOrError<? extends Filter.FilterConfig> parseFilterConfigOverride(Message rawProtoMessage) {
        return this.parseFilterConfig(rawProtoMessage);
    }

    @Override
    @Nullable
    public ClientInterceptor buildClientInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig, LoadBalancer.PickSubchannelArgs args, ScheduledExecutorService scheduler) {
        final ComputeEngineCredentials credentials = ComputeEngineCredentials.create();
        final LruCache callCredentialsCache = new LruCache(((GcpAuthenticationConfig)config).getCacheSize());
        return new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                String audience = "TEST_AUDIENCE";
                try {
                    CallCredentials existingCallCredentials = callOptions.getCredentials();
                    CallCredentials newCallCredentials = GcpAuthenticationFilter.this.getCallCredentials(callCredentialsCache, audience, credentials);
                    callOptions = existingCallCredentials != null ? callOptions.withCallCredentials(new CompositeCallCredentials(existingCallCredentials, newCallCredentials)) : callOptions.withCallCredentials(newCallCredentials);
                }
                catch (Exception e) {
                    return new FailingClientCall(Status.UNAUTHENTICATED.withDescription("Failed to attach CallCredentials.").withCause(e));
                }
                return next.newCall(method, callOptions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallCredentials getCallCredentials(LruCache<String, CallCredentials> cache, String audience, ComputeEngineCredentials credentials) {
        LruCache<String, CallCredentials> lruCache = cache;
        synchronized (lruCache) {
            return cache.getOrInsert(audience, key -> {
                IdTokenCredentials creds = IdTokenCredentials.newBuilder().setIdTokenProvider(credentials).setTargetAudience(audience).build();
                return MoreCallCredentials.from(creds);
            });
        }
    }

    static class AudienceMetadataParser
    implements MetadataRegistry.MetadataValueParser {
        AudienceMetadataParser() {
        }

        @Override
        public String getTypeUrl() {
            return "type.googleapis.com/envoy.extensions.filters.http.gcp_authn.v3.Audience";
        }

        @Override
        public String parse(Any any) throws InvalidProtocolBufferException {
            Audience audience = any.unpack(Audience.class);
            String url = audience.getUrl();
            if (url.isEmpty()) {
                throw new InvalidProtocolBufferException("Audience URL is empty. Metadata value must contain a valid URL.");
            }
            return url;
        }
    }

    private static final class LruCache<K, V> {
        private final Map<K, V> cache;

        LruCache(final int maxSize) {
            this.cache = new LinkedHashMap<K, V>(maxSize, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > maxSize;
                }
            };
        }

        V getOrInsert(K key, Function<K, V> create) {
            return this.cache.computeIfAbsent(key, create);
        }
    }

    private static final class FailingClientCall<ReqT, RespT>
    extends ClientCall<ReqT, RespT> {
        private final Status error;

        public FailingClientCall(Status error) {
            this.error = error;
        }

        @Override
        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
            listener.onClose(this.error, new Metadata());
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void cancel(String message, Throwable cause) {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void sendMessage(ReqT message) {
        }
    }

    static final class GcpAuthenticationConfig
    implements Filter.FilterConfig {
        private final int cacheSize;

        public GcpAuthenticationConfig(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public String typeUrl() {
            return GcpAuthenticationFilter.TYPE_URL;
        }
    }
}

