/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.client;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Internal
public final class XdsLogger {
    private static final Logger logger = Logger.getLogger("com.google.bigtable.repackaged.io.grpc.xds.XdsLogger");
    private final String prefix;

    public static XdsLogger withLogId(InternalLogId logId) {
        Preconditions.checkNotNull(logId, "logId");
        return new XdsLogger(logId.toString());
    }

    static XdsLogger withPrefix(String prefix) {
        return new XdsLogger(prefix);
    }

    private XdsLogger(String prefix) {
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
    }

    public boolean isLoggable(XdsLogLevel level) {
        Level javaLevel = XdsLogger.toJavaLogLevel(level);
        return logger.isLoggable(javaLevel);
    }

    void log(XdsLogLevel level, String msg) {
        Level javaLevel = XdsLogger.toJavaLogLevel(level);
        XdsLogger.logOnly(this.prefix, javaLevel, msg);
    }

    public void log(XdsLogLevel level, String messageFormat, Object ... args) {
        Level javaLogLevel = XdsLogger.toJavaLogLevel(level);
        if (logger.isLoggable(javaLogLevel)) {
            String msg = MessageFormat.format(messageFormat, args);
            XdsLogger.logOnly(this.prefix, javaLogLevel, msg);
        }
    }

    private static void logOnly(String prefix, Level logLevel, String msg) {
        if (logger.isLoggable(logLevel)) {
            LogRecord lr = new LogRecord(logLevel, "[" + prefix + "] " + msg);
            lr.setLoggerName(logger.getName());
            lr.setSourceClassName(logger.getName());
            lr.setSourceMethodName("log");
            logger.log(lr);
        }
    }

    private static Level toJavaLogLevel(XdsLogLevel level) {
        switch (level) {
            case ERROR: 
            case WARNING: {
                return Level.FINE;
            }
            case INFO: {
                return Level.FINER;
            }
            case FORCE_INFO: {
                return Level.INFO;
            }
            case FORCE_WARNING: {
                return Level.WARNING;
            }
        }
        return Level.FINEST;
    }

    public static enum XdsLogLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FORCE_INFO,
        FORCE_WARNING;

    }
}

