/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import com.google.bigtable.repackaged.com.google.protobuf.util.Durations;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.JsonUtil;
import com.google.bigtable.repackaged.io.grpc.internal.TimeProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.CertificateProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.CertificateProviderProvider;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.certprovider.FileWatcherCertificateProvider;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public final class FileWatcherCertificateProviderProvider
implements CertificateProviderProvider {
    @VisibleForTesting
    public static boolean enableSpiffe = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_SPIFFE_TRUST_BUNDLE_MAP", false);
    private static final String CERT_FILE_KEY = "certificate_file";
    private static final String KEY_FILE_KEY = "private_key_file";
    private static final String ROOT_FILE_KEY = "ca_certificate_file";
    private static final String SPIFFE_TRUST_MAP_FILE_KEY = "spiffe_trust_bundle_map_file";
    private static final String REFRESH_INTERVAL_KEY = "refresh_interval";
    @VisibleForTesting
    static final long REFRESH_INTERVAL_DEFAULT = 600L;
    static final String FILE_WATCHER_PROVIDER_NAME = "file_watcher";
    final FileWatcherCertificateProvider.Factory fileWatcherCertificateProviderFactory;
    private final ScheduledExecutorServiceFactory scheduledExecutorServiceFactory;
    private final TimeProvider timeProvider;

    FileWatcherCertificateProviderProvider() {
        this(FileWatcherCertificateProvider.Factory.getInstance(), ScheduledExecutorServiceFactory.DEFAULT_INSTANCE, TimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @VisibleForTesting
    FileWatcherCertificateProviderProvider(FileWatcherCertificateProvider.Factory fileWatcherCertificateProviderFactory, ScheduledExecutorServiceFactory scheduledExecutorServiceFactory, TimeProvider timeProvider) {
        this.fileWatcherCertificateProviderFactory = fileWatcherCertificateProviderFactory;
        this.scheduledExecutorServiceFactory = scheduledExecutorServiceFactory;
        this.timeProvider = timeProvider;
    }

    @Override
    public String getName() {
        return FILE_WATCHER_PROVIDER_NAME;
    }

    @Override
    public CertificateProvider createCertificateProvider(Object config, CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates) {
        Config configObj = FileWatcherCertificateProviderProvider.validateAndTranslateConfig(config);
        return this.fileWatcherCertificateProviderFactory.create(watcher, notifyCertUpdates, configObj.certFile, configObj.keyFile, configObj.rootFile, configObj.spiffeTrustMapFile, configObj.refrehInterval, this.scheduledExecutorServiceFactory.create(), this.timeProvider);
    }

    private static String checkForNullAndGet(Map<String, ?> map, String key) {
        return Preconditions.checkNotNull(JsonUtil.getString(map, key), "'" + key + "' is required in the config");
    }

    private static Config validateAndTranslateConfig(Object config) {
        Preconditions.checkArgument(config instanceof Map, "Only Map supported for config");
        Map map = (Map)config;
        Config configObj = new Config();
        configObj.certFile = FileWatcherCertificateProviderProvider.checkForNullAndGet(map, CERT_FILE_KEY);
        configObj.keyFile = FileWatcherCertificateProviderProvider.checkForNullAndGet(map, KEY_FILE_KEY);
        if (enableSpiffe) {
            if (!map.containsKey(ROOT_FILE_KEY) && !map.containsKey(SPIFFE_TRUST_MAP_FILE_KEY)) {
                throw new NullPointerException(String.format("either '%s' or '%s' is required in the config", ROOT_FILE_KEY, SPIFFE_TRUST_MAP_FILE_KEY));
            }
            if (map.containsKey(SPIFFE_TRUST_MAP_FILE_KEY)) {
                configObj.spiffeTrustMapFile = JsonUtil.getString(map, SPIFFE_TRUST_MAP_FILE_KEY);
            } else {
                configObj.rootFile = JsonUtil.getString(map, ROOT_FILE_KEY);
            }
        } else {
            configObj.rootFile = FileWatcherCertificateProviderProvider.checkForNullAndGet(map, ROOT_FILE_KEY);
        }
        String refreshIntervalString = JsonUtil.getString(map, REFRESH_INTERVAL_KEY);
        if (refreshIntervalString != null) {
            try {
                Duration duration = Durations.parse(refreshIntervalString);
                configObj.refrehInterval = duration.getSeconds();
                Preconditions.checkArgument(configObj.refrehInterval > 0L, "refreshInterval needs to be greater than 0");
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (configObj.refrehInterval == null) {
            configObj.refrehInterval = 600L;
        }
        return configObj;
    }

    @VisibleForTesting
    static class Config {
        String certFile;
        String keyFile;
        String rootFile;
        String spiffeTrustMapFile;
        Long refrehInterval;

        Config() {
        }
    }

    static abstract class ScheduledExecutorServiceFactory {
        private static final ScheduledExecutorServiceFactory DEFAULT_INSTANCE = new ScheduledExecutorServiceFactory(){

            @Override
            ScheduledExecutorService create() {
                return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("fileWatcher-%d").setDaemon(true).build());
            }
        };

        ScheduledExecutorServiceFactory() {
        }

        abstract ScheduledExecutorService create();
    }
}

