/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.baggage.propagation;

import com.google.bigtable.repackaged.io.opentelemetry.api.baggage.Baggage;
import com.google.bigtable.repackaged.io.opentelemetry.api.baggage.BaggageBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.baggage.BaggageEntry;
import com.google.bigtable.repackaged.io.opentelemetry.api.baggage.propagation.Parser;
import com.google.bigtable.repackaged.io.opentelemetry.api.internal.PercentEscaper;
import com.google.bigtable.repackaged.io.opentelemetry.api.internal.StringUtils;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.context.propagation.TextMapGetter;
import com.google.bigtable.repackaged.io.opentelemetry.context.propagation.TextMapPropagator;
import com.google.bigtable.repackaged.io.opentelemetry.context.propagation.TextMapSetter;
import com.google.bigtable.repackaged.io.opentelemetry.context.propagation.internal.ExtendedTextMapGetter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class W3CBaggagePropagator
implements TextMapPropagator {
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private static final W3CBaggagePropagator INSTANCE = new W3CBaggagePropagator();
    private static final PercentEscaper URL_ESCAPER = PercentEscaper.create();

    public static W3CBaggagePropagator getInstance() {
        return INSTANCE;
    }

    private W3CBaggagePropagator() {
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        Baggage baggage = Baggage.fromContext(context);
        if (baggage.isEmpty()) {
            return;
        }
        String headerContent = W3CBaggagePropagator.baggageToString(baggage);
        if (!headerContent.isEmpty()) {
            setter.set(carrier, FIELD, headerContent);
        }
    }

    private static String baggageToString(Baggage baggage) {
        StringBuilder headerContent = new StringBuilder();
        baggage.forEach((key, baggageEntry) -> {
            if (W3CBaggagePropagator.baggageIsInvalid(key, baggageEntry)) {
                return;
            }
            headerContent.append((String)key).append("=").append(W3CBaggagePropagator.encodeValue(baggageEntry.getValue()));
            String metadataValue = baggageEntry.getMetadata().getValue();
            if (metadataValue != null && !metadataValue.isEmpty()) {
                headerContent.append(";").append(W3CBaggagePropagator.encodeValue(metadataValue));
            }
            headerContent.append(",");
        });
        if (headerContent.length() == 0) {
            return "";
        }
        headerContent.setLength(headerContent.length() - 1);
        return headerContent.toString();
    }

    private static String encodeValue(String value) {
        return URL_ESCAPER.escape(value);
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        if (getter instanceof ExtendedTextMapGetter) {
            return W3CBaggagePropagator.extractMulti(context, carrier, (ExtendedTextMapGetter)getter);
        }
        return W3CBaggagePropagator.extractSingle(context, carrier, getter);
    }

    private static <C> Context extractSingle(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        String baggageHeader = getter.get(carrier, FIELD);
        if (baggageHeader == null) {
            return context;
        }
        if (baggageHeader.isEmpty()) {
            return context;
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            W3CBaggagePropagator.extractEntries(baggageHeader, baggageBuilder);
        }
        catch (RuntimeException e) {
            return context;
        }
        return context.with(baggageBuilder.build());
    }

    private static <C> Context extractMulti(Context context, @Nullable C carrier, ExtendedTextMapGetter<C> getter) {
        Iterator<String> baggageHeaders = getter.getAll(carrier, FIELD);
        if (baggageHeaders == null) {
            return context;
        }
        boolean extracted = false;
        BaggageBuilder baggageBuilder = Baggage.builder();
        while (baggageHeaders.hasNext()) {
            String header = baggageHeaders.next();
            if (header.isEmpty()) continue;
            try {
                W3CBaggagePropagator.extractEntries(header, baggageBuilder);
                extracted = true;
            }
            catch (RuntimeException runtimeException) {}
        }
        return extracted ? context.with(baggageBuilder.build()) : context;
    }

    private static void extractEntries(String baggageHeader, BaggageBuilder baggageBuilder) {
        new Parser(baggageHeader).parseInto(baggageBuilder);
    }

    private static boolean baggageIsInvalid(String key, BaggageEntry baggageEntry) {
        return !W3CBaggagePropagator.isValidBaggageKey(key) || !W3CBaggagePropagator.isValidBaggageValue(baggageEntry.getValue());
    }

    private static boolean isValidBaggageKey(String name) {
        return name != null && !name.trim().isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValidBaggageValue(String value) {
        return value != null;
    }

    public String toString() {
        return "W3CBaggagePropagator";
    }
}

