/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.logs;

import com.google.bigtable.repackaged.io.opentelemetry.api.logs.LogRecordBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.Logger;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.LoggerProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.IncubatingUtil;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.LoggerSharedState;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.internal.LoggerConfig;

class SdkLogger
implements Logger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get("noop");
    private static final boolean INCUBATOR_AVAILABLE;
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean loggerEnabled;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    static SdkLogger create(LoggerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedLogger(sharedState, instrumentationScopeInfo, loggerConfig) : new SdkLogger(sharedState, instrumentationScopeInfo, loggerConfig);
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerEnabled) {
            return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo) : new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("com.google.bigtable.repackaged.io.opentelemetry.api.incubator.logs.ExtendedDefaultLoggerProvider");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
    }
}

