/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.logs;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Value;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.Severity;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.SpanContext;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.AttributesMap;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.LogLimits;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.SdkLogRecordData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    private final LogLimits logLimits;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    @Nullable
    private final String eventName;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    @Nullable
    private final Value<?> body;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    private SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, @Nullable String eventName, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.eventName = eventName;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.attributes = attributes;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, @Nullable String eventName, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, eventName, timestampEpochNanos, observedTimestampEpochNanos, spanContext, severity, severityText, body, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.eventName, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues());
        }
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    @Nullable
    public Value<?> getBodyValue() {
        return this.body;
    }

    @Override
    public Attributes getAttributes() {
        return this.getImmutableAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes.get(key);
        }
    }
}

