/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

final class InstrumentBuilder {
    private final String name;
    private final SdkMeter sdkMeter;
    private final InstrumentValueType valueType;
    private InstrumentType type;
    private Advice.AdviceBuilder adviceBuilder = Advice.builder();
    private String description = "";
    private String unit = "";

    InstrumentBuilder(String name, InstrumentType type, InstrumentValueType valueType, SdkMeter sdkMeter) {
        this.name = name;
        this.type = type;
        this.valueType = valueType;
        this.sdkMeter = sdkMeter;
    }

    InstrumentBuilder setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    InstrumentBuilder setAdviceBuilder(Advice.AdviceBuilder adviceBuilder) {
        this.adviceBuilder = adviceBuilder;
        return this;
    }

    InstrumentBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.sdkMeter, this.name, this.description, this.unit, this.adviceBuilder);
    }

    <I extends AbstractInstrument> I buildSynchronousInstrument(SynchronousInstrumentConstructor<I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.newDescriptor();
        WriteableMetricStorage storage = this.sdkMeter.registerSynchronousMetricStorage(descriptor);
        return instrumentFactory.createInstrument(descriptor, this.sdkMeter, storage);
    }

    SdkObservableInstrument buildDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.sdkMeter.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.sdkMeter, callbackRegistration);
    }

    SdkObservableInstrument buildLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.sdkMeter.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.sdkMeter, callbackRegistration);
    }

    SdkObservableMeasurement buildObservableMeasurement(InstrumentType type) {
        this.type = type;
        InstrumentDescriptor descriptor = this.newDescriptor();
        return this.sdkMeter.registerObservableMeasurement(descriptor);
    }

    private InstrumentDescriptor newDescriptor() {
        return InstrumentDescriptor.create(this.name, this.description, this.unit, this.type, this.valueType, this.adviceBuilder.build());
    }

    public String toString() {
        return this.toStringHelper(this.getClass().getSimpleName());
    }

    String toStringHelper(String className) {
        return className + "{descriptor=" + this.newDescriptor() + "}";
    }

    void setAdviceAttributes(List<AttributeKey<?>> attributes) {
        this.adviceBuilder.setAttributes(attributes);
    }

    void setExplicitBucketBoundaries(List<Double> bucketBoundaries) {
        this.adviceBuilder.setExplicitBucketBoundaries(bucketBoundaries);
    }

    @FunctionalInterface
    static interface SwapBuilder<T> {
        public T newBuilder(SdkMeter var1, String var2, String var3, String var4, Advice.AdviceBuilder var5);
    }

    @FunctionalInterface
    static interface SynchronousInstrumentConstructor<I extends AbstractInstrument> {
        public I createInstrument(InstrumentDescriptor var1, SdkMeter var2, WriteableMetricStorage var3);
    }
}

