/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.DoubleGauge;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongGaugeBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableDoubleGauge;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkLongGauge;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

class SdkDoubleGauge
extends AbstractInstrument
implements DoubleGauge {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkDoubleGauge(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void set(double value, Attributes attributes) {
        this.storage.recordDouble(value, attributes, Context.current());
    }

    @Override
    public void set(double value, Attributes attributes, Context context) {
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void set(double increment) {
        this.set(increment, Attributes.empty());
    }

    static class SdkDoubleGaugeBuilder
    implements DoubleGaugeBuilder {
        final InstrumentBuilder builder;

        SdkDoubleGaugeBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.DOUBLE, sdkMeter);
        }

        @Override
        public DoubleGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.builder.buildSynchronousInstrument(SdkDoubleGauge::new);
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

