/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongGauge;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongGaugeBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableLongGauge;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

class SdkLongGauge
extends AbstractInstrument
implements LongGauge {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkLongGauge(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void set(long value, Attributes attributes) {
        this.storage.recordLong(value, attributes, Context.current());
    }

    @Override
    public void set(long value, Attributes attributes, Context context) {
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void set(long increment) {
        this.set(increment, Attributes.empty());
    }

    static class SdkLongGaugeBuilder
    implements LongGaugeBuilder {
        final InstrumentBuilder builder;

        SdkLongGaugeBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.LONG, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongGauge build() {
            return this.builder.buildSynchronousInstrument(SdkLongGauge::new);
        }

        @Override
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

