/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.ScopeConfigurator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.ViewBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public final class SdkMeterProviderUtil {
    private SdkMeterProviderUtil() {
    }

    public static void setExemplarFilter(SdkMeterProviderBuilder sdkMeterProviderBuilder, ExemplarFilter exemplarFilter) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setExemplarFilter", ExemplarFilter.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, exemplarFilter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setExemplarFilter on SdkMeterProviderBuilder", e);
        }
    }

    public static void setMeterConfigurator(SdkMeterProviderBuilder sdkMeterProviderBuilder, ScopeConfigurator<MeterConfig> meterConfigurator) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setMeterConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, meterConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setMeterConfigurator on SdkMeterProviderBuilder", e);
        }
    }

    public static void addMeterConfiguratorCondition(SdkMeterProviderBuilder sdkMeterProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("addMeterConfiguratorCondition", Predicate.class, MeterConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, scopeMatcher, meterConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addMeterConfiguratorCondition on SdkMeterProviderBuilder", e);
        }
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> keyFilter) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(keyFilter));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("addAttributesProcessor", AttributesProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, attributesProcessor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error adding AttributesProcessor to ViewBuilder", e);
        }
    }

    public static void setCardinalityLimit(ViewBuilder viewBuilder, int cardinalityLimit) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("setCardinalityLimit", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, cardinalityLimit);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error setting cardinalityLimit on ViewBuilder", e);
        }
    }

    public static void resetForTest(SdkMeterProvider sdkMeterProvider) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod("resetForTest", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling resetForTest on SdkMeterProvider", e);
        }
    }
}

