/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace;

import com.google.bigtable.repackaged.io.opentelemetry.api.trace.SpanBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.Tracer;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.TracerProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.IncubatingUtil;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.TracerSharedState;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.internal.TracerConfig;

class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get("noop");
    private static final boolean INCUBATOR_AVAILABLE;
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    protected boolean tracerEnabled;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerEnabled = tracerConfig.isEnabled();
    }

    static SdkTracer create(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedTracer(sharedState, instrumentationScopeInfo, tracerConfig) : new SdkTracer(sharedState, instrumentationScopeInfo, tracerConfig);
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (!this.tracerEnabled) {
            return NOOP_TRACER.spanBuilder(spanName);
        }
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            return NOOP_TRACER.spanBuilder(spanName);
        }
        return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits()) : new SdkSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    boolean isEnabled() {
        return this.tracerEnabled;
    }

    void updateTracerConfig(TracerConfig tracerConfig) {
        this.tracerEnabled = tracerConfig.isEnabled();
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("com.google.bigtable.repackaged.io.opentelemetry.api.incubator.trace.ExtendedDefaultTracerProvider");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
    }
}

