/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.Clock;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.CompletableResultCode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.resources.Resource;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.IdGenerator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.RandomIdGenerator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SpanLimits;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SpanProcessor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class TracerSharedState {
    private final Object lock = new Object();
    private final Clock clock;
    private final IdGenerator idGenerator;
    private final boolean idGeneratorSafeToSkipIdValidation;
    private final Resource resource;
    private final Supplier<SpanLimits> spanLimitsSupplier;
    private final Sampler sampler;
    private final SpanProcessor activeSpanProcessor;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    TracerSharedState(Clock clock, IdGenerator idGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors) {
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.idGeneratorSafeToSkipIdValidation = idGenerator instanceof RandomIdGenerator;
        this.resource = resource;
        this.spanLimitsSupplier = spanLimitsSupplier;
        this.sampler = sampler;
        this.activeSpanProcessor = SpanProcessor.composite(spanProcessors);
    }

    Clock getClock() {
        return this.clock;
    }

    IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    boolean isIdGeneratorSafeToSkipIdValidation() {
        return this.idGeneratorSafeToSkipIdValidation;
    }

    Resource getResource() {
        return this.resource;
    }

    SpanLimits getSpanLimits() {
        return this.spanLimitsSupplier.get();
    }

    Sampler getSampler() {
        return this.sampler;
    }

    SpanProcessor getActiveSpanProcessor() {
        return this.activeSpanProcessor;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.activeSpanProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

