/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.CompletableResultCode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.SpanData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export.MultiSpanExporter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export.NoopSpanExporter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface SpanExporter
extends Closeable {
    public static SpanExporter composite(SpanExporter ... exporters) {
        return SpanExporter.composite(Arrays.asList(exporters));
    }

    public static SpanExporter composite(Iterable<SpanExporter> exporters) {
        ArrayList<SpanExporter> exportersList = new ArrayList<SpanExporter>();
        for (SpanExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopSpanExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (SpanExporter)exportersList.get(0);
        }
        return MultiSpanExporter.create(exportersList);
    }

    public CompletableResultCode export(Collection<SpanData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

