/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase.util.FutureUtil;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase2_x.BigtableAsyncAdmin;
import com.google.cloud.bigtable.hbase2_x.BigtableAsyncBufferedMutator;
import com.google.cloud.bigtable.hbase2_x.BigtableAsyncTable;
import com.google.cloud.bigtable.hbase2_x.BigtableAsyncTableRegionLocator;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.security.User;

@InternalApi(value="For internal usage only")
public class BigtableAsyncConnection
implements AsyncConnection,
CommonConnection,
Closeable {
    private final Logger LOG = new Logger(this.getClass());
    private final BigtableApi bigtableApi;
    private final BigtableHBaseSettings settings;
    private volatile boolean closed = false;
    private final Set<TableName> disabledTables = Collections.synchronizedSet(new HashSet());
    private HBaseRequestAdapter.MutationAdapters mutationAdapters;

    public BigtableAsyncConnection(Configuration conf) throws IOException {
        this(conf, null, null, null);
    }

    public BigtableAsyncConnection(Configuration conf, Object ignoredAsyncRegistry, String ignoredClusterId, User ignoredUser) throws IOException {
        this.LOG.debug("Creating BigtableAsyncConnection", new Object[0]);
        try {
            this.settings = BigtableHBaseSettings.create(conf);
        }
        catch (IOException ioe) {
            this.LOG.error("Error loading BigtableOptions from Configuration.", ioe, new Object[0]);
            throw ioe;
        }
        this.closed = false;
        this.bigtableApi = BigtableApi.create(this.settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseRequestAdapter createAdapter(TableName tableName) {
        if (this.mutationAdapters == null) {
            BigtableAsyncConnection bigtableAsyncConnection = this;
            synchronized (bigtableAsyncConnection) {
                if (this.mutationAdapters == null) {
                    this.mutationAdapters = new HBaseRequestAdapter.MutationAdapters(this.settings);
                }
            }
        }
        return new HBaseRequestAdapter(this.settings, tableName, this.mutationAdapters);
    }

    @Override
    public BigtableApi getBigtableApi() {
        return this.bigtableApi;
    }

    @Override
    public BigtableHBaseSettings getBigtableSettings() {
        return this.settings;
    }

    @Override
    public Set<TableName> getDisabledTables() {
        return this.disabledTables;
    }

    @Override
    public void close() throws IOException {
        this.LOG.debug("closing BigtableAsyncConnection", new Object[0]);
        if (!this.closed) {
            this.bigtableApi.close();
            this.closed = true;
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.settings.getConfiguration();
    }

    public AsyncAdminBuilder getAdminBuilder() {
        return new AsyncAdminBuilder(){

            public AsyncAdminBuilder setStartLogErrorsCnt(int arg0) {
                return this;
            }

            public AsyncAdminBuilder setRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncAdminBuilder setRetryPause(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncAdminBuilder setRetryPauseForCQTBE(long l, TimeUnit timeUnit) {
                return this;
            }

            public AsyncAdminBuilder setOperationTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncAdminBuilder setMaxAttempts(int arg0) {
                return this;
            }

            public AsyncAdminBuilder setRetryPauseForServerOverloaded(long l, TimeUnit timeUnit) {
                return this;
            }

            public AsyncAdmin build() {
                try {
                    return BigtableAsyncAdmin.createInstance(BigtableAsyncConnection.this);
                }
                catch (IOException e) {
                    BigtableAsyncConnection.this.LOG.error("failed to build BigtableAsyncAdmin", e, new Object[0]);
                    throw new UncheckedIOException("failed to build BigtableAsyncAdmin", e);
                }
            }
        };
    }

    public AsyncAdminBuilder getAdminBuilder(ExecutorService arg0) {
        return this.getAdminBuilder();
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(final TableName tableName) {
        return new AsyncBufferedMutatorBuilder(){

            public AsyncBufferedMutatorBuilder setWriteBufferSize(long arg0) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setMaxKeyValueSize(int i) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setStartLogErrorsCnt(int arg0) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setRetryPause(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setOperationTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncBufferedMutatorBuilder setMaxAttempts(int arg0) {
                return this;
            }

            public AsyncBufferedMutator build() {
                return new BigtableAsyncBufferedMutator(BigtableAsyncConnection.this.bigtableApi, BigtableAsyncConnection.this.settings, BigtableAsyncConnection.this.createAdapter(tableName));
            }
        };
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName, ExecutorService es) {
        return this.getBufferedMutatorBuilder(tableName);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(final TableName tableName) {
        return new AsyncTableBuilder<AdvancedScanResultConsumer>(){

            public AsyncTableBuilder<AdvancedScanResultConsumer> setWriteRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setStartLogErrorsCnt(int arg0) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setScanTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setRetryPause(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setRetryPauseForCQTBE(long l, TimeUnit timeUnit) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setReadRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setOperationTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setMaxAttempts(int arg0) {
                return this;
            }

            public AsyncTableBuilder<AdvancedScanResultConsumer> setRetryPauseForServerOverloaded(long l, TimeUnit timeUnit) {
                return this;
            }

            public AsyncTable build() {
                return new BigtableAsyncTable(BigtableAsyncConnection.this, BigtableAsyncConnection.this.createAdapter(tableName));
            }
        };
    }

    public AsyncTableRegionLocator getRegionLocator(TableName tableName) {
        return new BigtableAsyncTableRegionLocator(tableName, this.settings, this.bigtableApi.getDataClient());
    }

    public void clearRegionLocationCache() {
        throw new UnsupportedOperationException("clearRegionLocationCache is not supported.");
    }

    public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(final TableName tableName, ExecutorService ignored) {
        return new AsyncTableBuilder<ScanResultConsumer>(){

            public AsyncTable build() {
                return new BigtableAsyncTable(BigtableAsyncConnection.this, BigtableAsyncConnection.this.createAdapter(tableName));
            }

            public AsyncTableBuilder<ScanResultConsumer> setMaxAttempts(int arg0) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setOperationTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setReadRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setRetryPause(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setRetryPauseForCQTBE(long l, TimeUnit timeUnit) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setScanTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setStartLogErrorsCnt(int arg0) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setWriteRpcTimeout(long arg0, TimeUnit arg1) {
                return this;
            }

            public AsyncTableBuilder<ScanResultConsumer> setRetryPauseForServerOverloaded(long l, TimeUnit timeUnit) {
                return this;
            }
        };
    }

    @Override
    public List<HRegionInfo> getAllRegionInfos(TableName tableName) throws IOException {
        ServerName serverName = ServerName.valueOf((String)this.settings.getDataHost(), (int)this.settings.getPort(), (long)0L);
        SampleRowKeysRequest.Builder request = SampleRowKeysRequest.newBuilder();
        request.setTableName(NameUtil.formatTableName(this.settings.getProjectId(), this.settings.getInstanceId(), tableName.getNameAsString()));
        List<KeyOffset> sampleRowKeyResponse = FutureUtil.unwrap(this.bigtableApi.getDataClient().sampleRowKeysAsync(tableName.getNameAsString()));
        return this.getSampledRowKeysAdapter(tableName, serverName).adaptResponse(sampleRowKeyResponse).stream().map(HRegionLocation::getRegionInfo).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    public Hbck getHbck(ServerName serverName) {
        throw new UnsupportedOperationException("getHbck is not supported.");
    }

    public CompletableFuture<Hbck> getHbck() {
        throw new UnsupportedOperationException("getHbck is not supported.");
    }

    private SampledRowKeysAdapter getSampledRowKeysAdapter(final TableName tableNameAdapter, final ServerName serverNameAdapter) {
        return new SampledRowKeysAdapter(tableNameAdapter, serverNameAdapter){

            @Override
            protected HRegionLocation createRegionLocation(byte[] startKey, byte[] endKey) {
                RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableNameAdapter).setStartKey(startKey).setEndKey(endKey).build();
                return new HRegionLocation(regionInfo, serverNameAdapter);
            }
        };
    }

    static {
        Adapters.class.getName();
    }
}

