/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.client.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.UrlEncodedContent;
import com.google.bigtable.repackaged.com.google.api.client.util.Data;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BearerToken {
    static final String PARAM_NAME = "access_token";
    static final Pattern INVALID_TOKEN_ERROR = Pattern.compile("\\s*error\\s*=\\s*\"?invalid_token\"?");

    public static Credential.AccessMethod authorizationHeaderAccessMethod() {
        return new AuthorizationHeaderAccessMethod();
    }

    public static Credential.AccessMethod formEncodedBodyAccessMethod() {
        return new FormEncodedBodyAccessMethod();
    }

    public static Credential.AccessMethod queryParameterAccessMethod() {
        return new QueryParameterAccessMethod();
    }

    static final class QueryParameterAccessMethod
    implements Credential.AccessMethod {
        QueryParameterAccessMethod() {
        }

        @Override
        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getUrl().set(BearerToken.PARAM_NAME, accessToken);
        }

        @Override
        public String getAccessTokenFromRequest(HttpRequest request) {
            Object param = request.getUrl().get(BearerToken.PARAM_NAME);
            return param == null ? null : param.toString();
        }
    }

    static final class FormEncodedBodyAccessMethod
    implements Credential.AccessMethod {
        FormEncodedBodyAccessMethod() {
        }

        @Override
        public void intercept(HttpRequest request, String accessToken) throws IOException {
            Preconditions.checkArgument(!"GET".equals(request.getRequestMethod()), "HTTP GET method is not supported");
            FormEncodedBodyAccessMethod.getData(request).put(BearerToken.PARAM_NAME, accessToken);
        }

        @Override
        public String getAccessTokenFromRequest(HttpRequest request) {
            Object bodyParam = FormEncodedBodyAccessMethod.getData(request).get(BearerToken.PARAM_NAME);
            return bodyParam == null ? null : bodyParam.toString();
        }

        private static Map<String, Object> getData(HttpRequest request) {
            return Data.mapOf(UrlEncodedContent.getContent(request).getData());
        }
    }

    static final class AuthorizationHeaderAccessMethod
    implements Credential.AccessMethod {
        static final String HEADER_PREFIX = "Bearer ";

        AuthorizationHeaderAccessMethod() {
        }

        @Override
        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getHeaders().setAuthorization(HEADER_PREFIX + accessToken);
        }

        @Override
        public String getAccessTokenFromRequest(HttpRequest request) {
            List<String> authorizationAsList = request.getHeaders().getAuthorizationAsList();
            if (authorizationAsList != null) {
                for (String header : authorizationAsList) {
                    if (!header.startsWith(HEADER_PREFIX)) continue;
                    return header.substring(HEADER_PREFIX.length());
                }
            }
            return null;
        }
    }
}

