/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonStatusRuntimeException;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ProtoMessageJsonStreamIterator;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class HttpJsonClientCallImpl<RequestT, ResponseT>
extends HttpJsonClientCall<RequestT, ResponseT>
implements HttpRequestRunnable.ResultListener {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean inDelivery = false;
    @GuardedBy(value="lock")
    private final Queue<NotificationTask<ResponseT>> pendingNotifications = new ArrayDeque<NotificationTask<ResponseT>>();
    private final HttpJsonCallOptions callOptions;
    private final String endpoint;
    private final ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final HttpTransport httpTransport;
    private final Executor executor;
    @GuardedBy(value="lock")
    private HttpJsonMetadata requestHeaders;
    @GuardedBy(value="lock")
    private HttpJsonClientCall.Listener<ResponseT> listener;
    @GuardedBy(value="lock")
    private int pendingNumMessages;
    @GuardedBy(value="lock")
    private HttpRequestRunnable<RequestT, ResponseT> requestRunnable;
    @GuardedBy(value="lock")
    private HttpRequestRunnable.RunnableResult runnableResult;
    @GuardedBy(value="lock")
    private ProtoMessageJsonStreamIterator responseStreamIterator;
    @GuardedBy(value="lock")
    private boolean closed;

    HttpJsonClientCallImpl(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, String endpoint, HttpJsonCallOptions callOptions, HttpTransport httpTransport, Executor executor) {
        this.methodDescriptor = methodDescriptor;
        this.endpoint = endpoint;
        this.callOptions = callOptions;
        this.httpTransport = httpTransport;
        this.executor = executor;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResult(HttpRequestRunnable.RunnableResult runnableResult) {
        Preconditions.checkNotNull(runnableResult);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            Preconditions.checkState(this.runnableResult == null, "The call result is already set");
            this.runnableResult = runnableResult;
            if (runnableResult.getResponseHeaders() != null) {
                this.pendingNotifications.offer(new OnHeadersNotificationTask<ResponseT>(this.listener, runnableResult.getResponseHeaders()));
            }
        }
        this.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(HttpJsonClientCall.Listener<ResponseT> responseListener, HttpJsonMetadata requestHeaders) {
        Preconditions.checkNotNull(responseListener);
        Preconditions.checkNotNull(requestHeaders);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            Preconditions.checkState(this.listener == null, "The call is already started");
            this.listener = responseListener;
            this.requestHeaders = requestHeaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(int numMessages) {
        if (numMessages < 0) {
            throw new IllegalArgumentException("numMessages must be non-negative");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.pendingNumMessages += numMessages;
        }
        this.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        Throwable actualCause = cause;
        if (actualCause == null) {
            actualCause = new CancellationException(message);
        }
        Object object = this.lock;
        synchronized (object) {
            this.close(499, message, actualCause, true);
        }
        this.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(RequestT message) {
        HttpRequestRunnable<RequestT, ResponseT> localRunnable;
        Preconditions.checkNotNull(message);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            Preconditions.checkState(this.listener != null, "The call hasn't been started");
            Preconditions.checkState(this.requestRunnable == null, "The message has already been sent. Bidirectional streaming calls are not supported");
            localRunnable = this.requestRunnable = new HttpRequestRunnable<RequestT, ResponseT>(message, this.methodDescriptor, this.endpoint, this.callOptions, this.httpTransport, this.requestHeaders, this);
        }
        this.executor.execute(localRunnable);
    }

    @Override
    public void halfClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deliver() {
        boolean newActiveDeliveryLoop = true;
        boolean allMessagesConsumed = false;
        while (true) {
            try {
                while (true) {
                    Object object = this.lock;
                    // MONITORENTER : object
                    if (this.inDelivery && newActiveDeliveryLoop) {
                        // MONITOREXIT : object
                        return;
                    }
                    newActiveDeliveryLoop = false;
                    this.inDelivery = true;
                    // MONITOREXIT : object
                    if (Thread.interrupted()) {
                        throw new InterruptedException("Message delivery has been interrupted");
                    }
                    this.notifyListeners();
                    object = this.lock;
                    // MONITORENTER : object
                    if (allMessagesConsumed) {
                        allMessagesConsumed = false;
                        this.close(this.runnableResult.getStatusCode(), this.runnableResult.getTrailers().getStatusMessage(), this.runnableResult.getTrailers().getException(), false);
                    }
                    if (this.runnableResult == null || this.pendingNumMessages <= 0 || this.closed) {
                        if (this.pendingNotifications.isEmpty()) {
                            this.inDelivery = false;
                            // MONITOREXIT : object
                            return;
                        }
                        // MONITOREXIT : object
                        continue;
                    }
                    --this.pendingNumMessages;
                    allMessagesConsumed = this.consumeMessageFromStream();
                    // MONITOREXIT : object
                }
            }
            catch (Throwable e) {
                HttpJsonStatusRuntimeException ex = new HttpJsonStatusRuntimeException(499, "Exception in message delivery", e);
                Object object = this.lock;
                // MONITORENTER : object
                this.close(ex.getStatusCode(), ex.getMessage(), ex, true);
                // MONITOREXIT : object
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        while (true) {
            NotificationTask<ResponseT> notification;
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingNotifications.isEmpty()) {
                    return;
                }
                notification = this.pendingNotifications.poll();
            }
            notification.call();
        }
    }

    @GuardedBy(value="lock")
    private boolean consumeMessageFromStream() throws IOException {
        boolean allMessagesConsumed;
        Reader responseReader;
        if (this.runnableResult.getTrailers().getException() != null || this.runnableResult.getResponseContent() == null) {
            return true;
        }
        if (this.methodDescriptor.getType() == ApiMethodDescriptor.MethodType.SERVER_STREAMING) {
            if (this.responseStreamIterator == null) {
                this.responseStreamIterator = new ProtoMessageJsonStreamIterator(new InputStreamReader(this.runnableResult.getResponseContent(), StandardCharsets.UTF_8));
            }
            if (!this.responseStreamIterator.hasNext()) {
                return true;
            }
            responseReader = this.responseStreamIterator.next();
            allMessagesConsumed = !this.responseStreamIterator.hasNext();
        } else {
            responseReader = new InputStreamReader(this.runnableResult.getResponseContent(), StandardCharsets.UTF_8);
            allMessagesConsumed = true;
        }
        ResponseT message = this.methodDescriptor.getResponseParser().parse(responseReader, this.callOptions.getTypeRegistry());
        this.pendingNotifications.offer(new OnMessageNotificationTask<ResponseT>(this.listener, message));
        return allMessagesConsumed;
    }

    @GuardedBy(value="lock")
    private void close(int statusCode, String message, Throwable cause, boolean terminateImmediatelly) {
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.requestRunnable != null) {
                this.requestRunnable.cancel();
                this.requestRunnable = null;
            }
            HttpJsonMetadata.Builder meatadaBuilder = HttpJsonMetadata.newBuilder();
            if (this.runnableResult != null && this.runnableResult.getTrailers() != null) {
                meatadaBuilder = this.runnableResult.getTrailers().toBuilder();
            }
            meatadaBuilder.setException(cause);
            meatadaBuilder.setStatusMessage(message);
            if (this.responseStreamIterator != null) {
                this.responseStreamIterator.close();
            }
            if (this.runnableResult != null && this.runnableResult.getResponseContent() != null) {
                this.runnableResult.getResponseContent().close();
            }
            if (terminateImmediatelly) {
                this.pendingNotifications.clear();
            }
            this.pendingNotifications.offer(new OnCloseNotificationTask<ResponseT>(this.listener, statusCode, meatadaBuilder.build()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class OnCloseNotificationTask<ResponseT>
    extends NotificationTask<ResponseT> {
        private final int statusCode;
        private final HttpJsonMetadata trailers;

        OnCloseNotificationTask(HttpJsonClientCall.Listener<ResponseT> listener, int statusCode, HttpJsonMetadata trailers) {
            super(listener);
            this.statusCode = statusCode;
            this.trailers = trailers;
        }

        @Override
        public void call() {
            this.getListener().onClose(this.statusCode, this.trailers);
        }
    }

    private static class OnMessageNotificationTask<ResponseT>
    extends NotificationTask<ResponseT> {
        private final ResponseT message;

        OnMessageNotificationTask(HttpJsonClientCall.Listener<ResponseT> listener, ResponseT message) {
            super(listener);
            this.message = message;
        }

        @Override
        public void call() {
            this.getListener().onMessage(this.message);
        }
    }

    private static class OnHeadersNotificationTask<ResponseT>
    extends NotificationTask<ResponseT> {
        private final HttpJsonMetadata responseHeaders;

        OnHeadersNotificationTask(HttpJsonClientCall.Listener<ResponseT> listener, HttpJsonMetadata responseHeaders) {
            super(listener);
            this.responseHeaders = responseHeaders;
        }

        @Override
        public void call() {
            this.getListener().onHeaders(this.responseHeaders);
        }
    }

    private static abstract class NotificationTask<ResponseT> {
        private final HttpJsonClientCall.Listener<ResponseT> listener;

        NotificationTask(HttpJsonClientCall.Listener<ResponseT> listener) {
            this.listener = listener;
        }

        protected HttpJsonClientCall.Listener<ResponseT> getListener() {
            return this.listener;
        }

        abstract void call();
    }
}

