/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.FieldsExtractor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import java.util.List;
import java.util.Map;

public class ProtoMessageRequestFormatter<RequestT extends Message>
implements HttpRequestFormatter<RequestT> {
    private final FieldsExtractor<RequestT, String> requestBodyExtractor;
    private final FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor;
    private final String rawPath;
    private final PathTemplate pathTemplate;
    private final FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor;

    private ProtoMessageRequestFormatter(FieldsExtractor<RequestT, String> requestBodyExtractor, FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor, String rawPath, PathTemplate pathTemplate, FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor) {
        this.requestBodyExtractor = requestBodyExtractor;
        this.queryParamsExtractor = queryParamsExtractor;
        this.rawPath = rawPath;
        this.pathTemplate = pathTemplate;
        this.pathVarsExtractor = pathVarsExtractor;
    }

    public static <RequestT extends Message> Builder<RequestT> newBuilder() {
        return new Builder();
    }

    public Builder<RequestT> toBuilder() {
        return new Builder<RequestT>().setPath(this.rawPath, this.pathVarsExtractor).setQueryParamsExtractor(this.queryParamsExtractor).setRequestBodyExtractor(this.requestBodyExtractor);
    }

    @Override
    public Map<String, List<String>> getQueryParamNames(RequestT apiMessage) {
        return this.queryParamsExtractor.extract(apiMessage);
    }

    @Override
    public String getRequestBody(RequestT apiMessage) {
        return this.requestBodyExtractor.extract(apiMessage);
    }

    @Override
    public String getPath(RequestT apiMessage) {
        return this.pathTemplate.instantiate(this.pathVarsExtractor.extract(apiMessage));
    }

    @Override
    public PathTemplate getPathTemplate() {
        return this.pathTemplate;
    }

    public static class Builder<RequestT extends Message> {
        private FieldsExtractor<RequestT, String> requestBodyExtractor;
        private FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor;
        private String rawPath;
        private FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor;

        public Builder<RequestT> setRequestBodyExtractor(FieldsExtractor<RequestT, String> requestBodyExtractor) {
            this.requestBodyExtractor = requestBodyExtractor;
            return this;
        }

        public Builder<RequestT> setQueryParamsExtractor(FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor) {
            this.queryParamsExtractor = queryParamsExtractor;
            return this;
        }

        public Builder<RequestT> setPath(String rawPath, FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor) {
            this.rawPath = rawPath;
            this.pathVarsExtractor = pathVarsExtractor;
            return this;
        }

        @InternalApi
        public Builder<RequestT> updateRawPath(String target, String replacement) {
            this.rawPath = this.rawPath.replace(target, replacement);
            return this;
        }

        public ProtoMessageRequestFormatter<RequestT> build() {
            return new ProtoMessageRequestFormatter(this.requestBodyExtractor, this.queryParamsExtractor, this.rawPath, PathTemplate.create(this.rawPath), this.pathVarsExtractor);
        }
    }
}

