/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LocationName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import javax.annotation.Nonnull;

public class Cluster {
    @Nonnull
    private final com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster stateProto;

    @InternalApi
    public static Cluster fromProto(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster proto) {
        return new Cluster(proto);
    }

    private Cluster(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster proto) {
        Preconditions.checkNotNull(proto);
        Preconditions.checkArgument(!proto.getName().isEmpty(), "Name must be set");
        this.stateProto = proto;
    }

    public String getId() {
        ClusterName fullName = Verify.verifyNotNull(ClusterName.parse(this.stateProto.getName()), "Name can never be null", new Object[0]);
        return fullName.getCluster();
    }

    public String getInstanceId() {
        ClusterName fullName = Verify.verifyNotNull(ClusterName.parse(this.stateProto.getName()), "Name can never be null", new Object[0]);
        return fullName.getInstance();
    }

    public String getZone() {
        LocationName location = Verify.verifyNotNull(LocationName.parse(this.stateProto.getLocation()));
        return location.getLocation();
    }

    public State getState() {
        return State.fromProto(this.stateProto.getState());
    }

    public int getServeNodes() {
        return this.stateProto.getServeNodes();
    }

    public int getAutoscalingMinServeNodes() {
        return this.stateProto.getClusterConfig().getClusterAutoscalingConfig().getAutoscalingLimits().getMinServeNodes();
    }

    public int getAutoscalingMaxServeNodes() {
        return this.stateProto.getClusterConfig().getClusterAutoscalingConfig().getAutoscalingLimits().getMaxServeNodes();
    }

    public int getAutoscalingCpuPercentageTarget() {
        return this.stateProto.getClusterConfig().getClusterAutoscalingConfig().getAutoscalingTargets().getCpuUtilizationPercent();
    }

    public StorageType getStorageType() {
        return StorageType.fromProto(this.stateProto.getDefaultStorageType());
    }

    public String getKmsKeyName() {
        if (this.stateProto.hasEncryptionConfig()) {
            return this.stateProto.getEncryptionConfig().getKmsKeyName();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return Objects.equal(this.stateProto, cluster.stateProto);
    }

    public int hashCode() {
        return Objects.hashCode(this.stateProto);
    }

    public static enum State {
        NOT_KNOWN(Cluster.State.STATE_NOT_KNOWN),
        READY(Cluster.State.READY),
        CREATING(Cluster.State.CREATING),
        RESIZING(Cluster.State.RESIZING),
        DISABLED(Cluster.State.DISABLED),
        UNRECOGNIZED(Cluster.State.UNRECOGNIZED);

        private final Cluster.State proto;

        @InternalApi
        public static State fromProto(Cluster.State proto) {
            for (State state : State.values()) {
                if (!state.proto.equals(proto)) continue;
                return state;
            }
            return UNRECOGNIZED;
        }

        private State(Cluster.State proto) {
            this.proto = proto;
        }

        @InternalApi
        public Cluster.State toProto() {
            return this.proto;
        }
    }
}

