/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@InternalExtensionOnly
public class RetryOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static int DEFAULT_STREAMING_BUFFER_SIZE = 60;
    @InternalApi(value="For internal usage only")
    public static final boolean DEFAULT_ENABLE_GRPC_RETRIES = true;
    @InternalApi(value="For internal usage only")
    public static final Set<Status.Code> DEFAULT_ENABLE_GRPC_RETRIES_SET = ImmutableSet.of(Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE, Status.Code.ABORTED);
    @InternalApi(value="For internal usage only")
    public static final int DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS = (int)TimeUnit.MINUTES.toMillis(5L);
    @InternalApi(value="For internal usage only")
    public static final int DEFAULT_INITIAL_BACKOFF_MILLIS = 10;
    @InternalApi(value="For internal usage only")
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 2.0;
    @InternalApi(value="For internal usage only")
    public static final int DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS = (int)TimeUnit.MINUTES.toMillis(10L);
    @InternalApi(value="For internal usage only")
    public static final int DEFAULT_MAX_SCAN_TIMEOUT_RETRIES = 10;
    private boolean retriesEnabled;
    private boolean allowRetriesWithoutTimestamp;
    private int initialBackoffMillis;
    private int maxElapsedBackoffMillis;
    private double backoffMultiplier;
    @Deprecated
    private int streamingBufferSize;
    private int readPartialRowTimeoutMillis;
    private int maxScanTimeoutRetries;
    private Set<Status.Code> statusToRetryOn;

    public static RetryOptions getDefaultOptions() {
        return RetryOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public RetryOptions(boolean retriesEnabled, boolean allowRetriesWithoutTimestamp, int initialBackoffMillis, double backoffMultiplier, int maxElapsedBackoffMillis, int streamingBufferSize, int readPartialRowTimeoutMillis, int maxScanTimeoutRetries, Set<Status.Code> statusToRetryOn) {
        this.retriesEnabled = retriesEnabled;
        this.allowRetriesWithoutTimestamp = allowRetriesWithoutTimestamp;
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxElapsedBackoffMillis = maxElapsedBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.streamingBufferSize = streamingBufferSize;
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
        this.maxScanTimeoutRetries = maxScanTimeoutRetries;
        this.statusToRetryOn = ImmutableSet.copyOf(statusToRetryOn);
    }

    private RetryOptions() {
    }

    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public int getMaxElapsedBackoffMillis() {
        return this.maxElapsedBackoffMillis;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public boolean enableRetries() {
        return this.retriesEnabled;
    }

    public boolean allowRetriesWithoutTimestamp() {
        return this.allowRetriesWithoutTimestamp;
    }

    public boolean retryOnDeadlineExceeded() {
        return this.statusToRetryOn.contains((Object)Status.Code.DEADLINE_EXCEEDED);
    }

    @Deprecated
    public int getStreamingBufferSize() {
        return this.streamingBufferSize;
    }

    public int getReadPartialRowTimeoutMillis() {
        return this.readPartialRowTimeoutMillis;
    }

    public int getMaxScanTimeoutRetries() {
        return this.maxScanTimeoutRetries;
    }

    public boolean isRetryable(Status.Code code) {
        return this.statusToRetryOn.contains((Object)code);
    }

    public Set<Status.Code> getRetryableStatusCodes() {
        return ImmutableSet.copyOf(this.statusToRetryOn);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RetryOptions.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RetryOptions other = (RetryOptions)obj;
        return this.retriesEnabled == other.retriesEnabled && this.allowRetriesWithoutTimestamp == other.allowRetriesWithoutTimestamp && Objects.equals(this.statusToRetryOn, other.statusToRetryOn) && this.initialBackoffMillis == other.initialBackoffMillis && this.maxElapsedBackoffMillis == other.maxElapsedBackoffMillis && this.backoffMultiplier == other.backoffMultiplier && this.streamingBufferSize == other.streamingBufferSize && this.readPartialRowTimeoutMillis == other.readPartialRowTimeoutMillis && this.maxScanTimeoutRetries == other.maxScanTimeoutRetries;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("retriesEnabled", this.retriesEnabled).add("allowRetriesWithoutTimestamp", this.allowRetriesWithoutTimestamp).add("statusToRetryOn", this.statusToRetryOn).add("initialBackoffMillis", this.initialBackoffMillis).add("maxElapsedBackoffMillis", this.maxElapsedBackoffMillis).add("backoffMultiplier", this.backoffMultiplier).add("streamingBufferSize", this.streamingBufferSize).add("readPartialRowTimeoutMillis", this.readPartialRowTimeoutMillis).add("maxScanTimeoutRetries", this.maxScanTimeoutRetries).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RetryOptions clone() {
        try {
            return (RetryOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone RetryOptions.");
        }
    }

    public static class Builder {
        private RetryOptions options;

        @Deprecated
        public Builder() {
            this.options = new RetryOptions();
            this.options.retriesEnabled = true;
            this.options.allowRetriesWithoutTimestamp = false;
            this.options.initialBackoffMillis = 10;
            this.options.maxElapsedBackoffMillis = DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS;
            this.options.backoffMultiplier = 2.0;
            this.options.streamingBufferSize = DEFAULT_STREAMING_BUFFER_SIZE;
            this.options.readPartialRowTimeoutMillis = DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS;
            this.options.maxScanTimeoutRetries = 10;
            this.options.statusToRetryOn = new HashSet<Status.Code>(DEFAULT_ENABLE_GRPC_RETRIES_SET);
        }

        public Builder(RetryOptions options) {
            this.options = options.clone();
        }

        public Builder setEnableRetries(boolean enabled) {
            this.options.retriesEnabled = enabled;
            return this;
        }

        public Builder setRetryOnDeadlineExceeded(boolean enabled) {
            if (enabled) {
                this.options.statusToRetryOn.add(Status.Code.DEADLINE_EXCEEDED);
            } else {
                this.options.statusToRetryOn.remove((Object)Status.Code.DEADLINE_EXCEEDED);
            }
            return this;
        }

        public Builder setInitialBackoffMillis(int initialBackoffMillis) {
            this.options.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        public Builder setBackoffMultiplier(double multiplier) {
            this.options.backoffMultiplier = multiplier;
            return this;
        }

        public Builder setMaxElapsedBackoffMillis(int maxElapsedBackoffMillis) {
            this.options.maxElapsedBackoffMillis = maxElapsedBackoffMillis;
            return this;
        }

        public Builder setStreamingBufferSize(int streamingBufferSize) {
            this.options.streamingBufferSize = streamingBufferSize;
            return this;
        }

        public Builder setReadPartialRowTimeoutMillis(int timeout) {
            this.options.readPartialRowTimeoutMillis = timeout;
            return this;
        }

        public Builder setMaxScanTimeoutRetries(int maxScanTimeoutRetries) {
            this.options.maxScanTimeoutRetries = maxScanTimeoutRetries;
            return this;
        }

        public Builder addStatusToRetryOn(Status.Code code) {
            this.options.statusToRetryOn.add(code);
            return this;
        }

        public Builder setAllowRetriesWithoutTimestamp(boolean allowRetriesWithoutTimestamp) {
            this.options.allowRetriesWithoutTimestamp = allowRetriesWithoutTimestamp;
            return this;
        }

        public RetryOptions build() {
            return this.options;
        }
    }
}

