/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalExtensionOnly
public class BigtableClusterName {
    private static final Pattern PATTERN = Pattern.compile("projects/[^/]+/instances/([^/]+)/clusters/([^/]+)");
    private final String clusterName;
    private final String instanceId;
    private final String clusterId;

    @InternalApi(value="For internal usage only")
    public BigtableClusterName(String clusterName) {
        this.clusterName = clusterName;
        Matcher matcher = PATTERN.matcher(clusterName);
        Preconditions.checkArgument(matcher.matches(), "Malformed cluster name");
        this.instanceId = matcher.group(1);
        this.clusterId = matcher.group(2);
    }

    public String toString() {
        return this.clusterName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    @Deprecated
    public String toSnapshotName(String snapshotId) {
        return this.clusterName + "/snapshots/" + snapshotId;
    }

    public String toBackupName(String backupId) {
        return this.clusterName + "/backups/" + backupId;
    }
}

