/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.longrunning.GetOperationRequest;
import com.google.bigtable.repackaged.com.google.longrunning.Operation;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;

@InternalExtensionOnly
public class BigtableClusterUtilities
implements AutoCloseable {
    private static Logger logger = new Logger(BigtableClusterUtilities.class);
    private final BigtableInstanceName instanceName;
    private final ManagedChannel channel;
    private final BigtableInstanceClient client;

    public static BigtableClusterUtilities forInstance(String projectId, String instanceId) throws IOException, GeneralSecurityException {
        return new BigtableClusterUtilities(BigtableOptions.builder().setProjectId(projectId).setInstanceId(instanceId).build());
    }

    public static BigtableClusterUtilities forAllInstances(String projectId) throws IOException, GeneralSecurityException {
        return new BigtableClusterUtilities(BigtableOptions.builder().setProjectId(projectId).setInstanceId("-").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupInstanceId(String projectId, String clusterId, String zoneId) throws IOException {
        BigtableClusterUtilities utils;
        try {
            utils = BigtableClusterUtilities.forAllInstances(projectId);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not initialize BigtableClusterUtilities", e);
        }
        try {
            Cluster cluster = utils.getCluster(clusterId, zoneId);
            String string = new BigtableClusterName(cluster.getName()).getInstanceId();
            return string;
        }
        finally {
            try {
                utils.close();
            }
            catch (Exception e) {
                logger.warn("Error closing BigtableClusterUtilities: ", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster lookupCluster(String projectId, String instanceId) throws IOException {
        BigtableClusterUtilities utils;
        try {
            utils = BigtableClusterUtilities.forInstance(projectId, instanceId);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not initialize BigtableClusterUtilities", e);
        }
        try {
            Cluster cluster = utils.getSingleCluster();
            return cluster;
        }
        finally {
            try {
                utils.close();
            }
            catch (Exception e) {
                logger.warn("Error closing BigtableClusterUtilities: ", e, new Object[0]);
            }
        }
    }

    public static String getZoneId(Cluster cluster) {
        Preconditions.checkState(cluster != null, "Cluster doesn't exist");
        return BigtableClusterUtilities.getZoneId(cluster.getLocation());
    }

    @VisibleForTesting
    static String getZoneId(String name) {
        String prefix = "/locations/";
        return name.substring(name.lastIndexOf("/locations/") + "/locations/".length());
    }

    public BigtableClusterUtilities(BigtableOptions options) throws IOException, GeneralSecurityException {
        this.instanceName = Preconditions.checkNotNull(options.getInstanceName(), "ProjectId and instanceId have to be set in the options.  Use '-' for all instanceIds.");
        ClientInterceptor[] interceptors = BigtableSession.createAdminApiInterceptors(options).toArray(new ClientInterceptor[0]);
        this.channel = BigtableSession.createNettyChannel(options.getAdminHost(), options, false, interceptors);
        this.client = new BigtableInstanceGrpcClient(this.channel);
    }

    @Deprecated
    public int getClusterSize(String clusterId, String zoneId) {
        Cluster cluster = this.getCluster(clusterId, zoneId);
        String message = String.format("Cluster %s/%s was not found.", clusterId, zoneId);
        Preconditions.checkNotNull(cluster, message);
        return cluster.getServeNodes();
    }

    public int getClusterSize() {
        return this.getSingleCluster().getServeNodes();
    }

    public ListClustersResponse getClusters() {
        logger.info("Reading clusters.", new Object[0]);
        return this.client.listCluster(ListClustersRequest.newBuilder().setParent(this.instanceName.getInstanceName()).build());
    }

    public void setClusterSize(String clusterId, String zoneId, int newSize) throws InterruptedException {
        this.setClusterSize(this.instanceName.toClusterName(clusterId).getClusterName(), newSize);
    }

    public void setClusterSize(int newSize) throws InterruptedException {
        this.setClusterSize(this.getSingleCluster().getName(), newSize);
    }

    private void setClusterSize(String clusterName, int newSize) throws InterruptedException {
        Preconditions.checkArgument(newSize > 0, "Cluster size must be > 0");
        logger.info("Updating cluster %s to size %d", clusterName, newSize);
        Operation operation = this.client.updateCluster(Cluster.newBuilder().setName(clusterName).setServeNodes(newSize).build());
        this.waitForOperation(operation.getName(), 60);
        logger.info("Done updating cluster %s.", clusterName);
    }

    public Cluster getSingleCluster() {
        ListClustersResponse response = this.getClusters();
        Preconditions.checkState(response.getClustersCount() != 0, "The instance does not exist.");
        Preconditions.checkState(response.getClustersCount() == 1, "There can only be one cluster for this method to work.");
        return response.getClusters(0);
    }

    public void waitForOperation(String operationName, int maxSeconds) throws InterruptedException {
        long endTimeMillis = TimeUnit.SECONDS.toMillis(maxSeconds) + System.currentTimeMillis();
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(operationName).build();
        do {
            Thread.sleep(500L);
            Operation response = this.client.getOperation(request);
            if (!response.getDone()) continue;
            switch (response.getResultCase()) {
                case RESPONSE: {
                    return;
                }
                case ERROR: {
                    throw new RuntimeException("Cluster could not be resized: " + response.getError());
                }
                case RESULT_NOT_SET: {
                    throw new IllegalStateException("System returned invalid response for Operation check: " + response);
                }
            }
        } while (System.currentTimeMillis() < endTimeMillis);
        throw new IllegalStateException(String.format("Waited %d seconds and cluster was not resized yet.", maxSeconds));
    }

    public int getClusterNodeCount(String clusterId, String zoneId) {
        return this.getCluster(clusterId, zoneId).getServeNodes();
    }

    public Cluster getCluster(String clusterId, String zoneId) {
        Cluster response = null;
        for (Cluster cluster : this.getClusters().getClustersList()) {
            if (!cluster.getName().endsWith("/clusters/" + clusterId) || !cluster.getLocation().endsWith("/locations/" + zoneId)) continue;
            if (response == null) {
                response = cluster;
                continue;
            }
            throw new IllegalStateException(String.format("Got multiple clusters named %s in zone %z.", clusterId, zoneId));
        }
        return Preconditions.checkNotNull(response, String.format("Cluster %s in zone %s was not found.", clusterId, zoneId));
    }

    @Override
    public void close() {
        this.channel.shutdownNow();
    }
}

