/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.CallController;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.contrib.grpc.util.StatusConverter;
import com.google.bigtable.repackaged.io.opencensus.trace.Annotation;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.io.opencensus.trace.EndSpanOptions;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.ChronoUnit;
import com.google.cloud.bigtable.metrics.Timer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@InternalApi(value="For internal usage only")
public abstract class AbstractRetryingOperation<RequestT, ResponseT, ResultT>
extends ClientCall.Listener<ResponseT> {
    protected static final Logger LOG = new Logger(AbstractRetryingOperation.class);
    private static final Tracer TRACER = Tracing.getTracer();
    private static final EndSpanOptions END_SPAN_OPTIONS_WITH_SAMPLE_STORE = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final ExponentialRetryAlgorithm exponentialRetryAlgorithm;
    private final ApiClock clock;
    private TimedAttemptSettings currentBackoff;
    protected final BigtableAsyncRpc<RequestT, ResponseT> rpc;
    protected final RetryOptions retryOptions;
    protected final ScheduledExecutorService retryExecutorService;
    private final RequestT request;
    private final DeadlineGenerator deadlineGenerator;
    private final Metadata originalMetadata;
    protected int failedCount = 0;
    protected final GrpcFuture<ResultT> completionFuture;
    protected final CallController<RequestT, ResponseT> callWrapper;
    protected Timer.Context operationTimerContext;
    protected Timer.Context rpcTimerContext;
    protected final Span operationSpan;

    private static String makeSpanName(String prefix, String fullMethodName) {
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    public AbstractRetryingOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService retryExecutorService, Metadata originalMetadata, ApiClock clock) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.rpc = retryableRpc;
        this.deadlineGenerator = deadlineGenerator;
        this.retryExecutorService = retryExecutorService;
        this.originalMetadata = originalMetadata;
        this.completionFuture = new GrpcFuture();
        String spanName = AbstractRetryingOperation.makeSpanName("Operation", this.rpc.getMethodDescriptor().getFullMethodName());
        this.operationSpan = TRACER.spanBuilder(spanName).setRecordEvents(true).startSpan();
        this.clock = clock;
        this.exponentialRetryAlgorithm = this.createRetryAlgorithm(clock);
        this.callWrapper = this.createCallController();
    }

    protected CallController<RequestT, ResponseT> createCallController() {
        return new CallController();
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        try (Scope scope = TRACER.withSpan(this.operationSpan);){
            this.callWrapper.resetCall();
            this.rpcTimerContext.close();
            if (status.isOk()) {
                if (this.onOK(trailers)) {
                    this.finalizeStats(status);
                }
            } else {
                this.onError(status, trailers);
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    protected void finalizeStats(Status status) {
        this.operationTimerContext.close();
        if (this.operationSpan != null) {
            this.operationSpan.setStatus(StatusConverter.fromGrpcStatus(status));
            this.operationSpan.end(END_SPAN_OPTIONS_WITH_SAMPLE_STORE);
        }
    }

    protected void onError(Status status, Metadata trailers) {
        Status.Code code = status.getCode();
        if (code == Status.Code.CANCELLED) {
            this.setException(status.asRuntimeException());
            this.finalizeStats(status);
            return;
        }
        String channelId = ChannelPool.extractIdentifier(trailers);
        if (!this.retryOptions.enableRetries() || !this.isStatusRetryable(status) || !this.isRequestRetryable() && code != Status.Code.UNAUTHENTICATED && code != Status.Code.UNAVAILABLE) {
            LOG.error("Could not complete RPC. Failure #%d, got: %s on channel %s.\nTrailers: %s", status.getCause(), this.failedCount, status, channelId, trailers);
            this.rpc.getRpcMetrics().markFailure();
            this.finalizeStats(status);
            this.setException(status.asRuntimeException());
            return;
        }
        Long nextBackOff = this.getNextBackoff();
        ++this.failedCount;
        if (nextBackOff == null) {
            LOG.error("All retries were exhausted. Failure #%d, got: %s on channel %s.\nTrailers: %s", status.getCause(), this.failedCount, status, channelId, trailers);
            this.setException(this.getExhaustedRetriesException(status));
        } else {
            LOG.warn("Retrying failed call. Failure #%d, got: %s on channel %s.\nTrailers: %s", status.getCause(), this.failedCount, status, channelId, trailers);
            this.performRetry(nextBackOff);
        }
    }

    protected BigtableRetriesExhaustedException getExhaustedRetriesException(Status status) {
        this.operationSpan.addAnnotation("exhaustedRetries");
        this.rpc.getRpcMetrics().markRetriesExhasted();
        this.finalizeStats(status);
        String message = String.format("Exhausted retries after %d failures.", this.failedCount);
        return new BigtableRetriesExhaustedException(message, status.asRuntimeException());
    }

    protected void performRetry(long nextBackOff) {
        this.operationSpan.addAnnotation("retryWithBackoff", ImmutableMap.of("backoff", AttributeValue.longAttributeValue(nextBackOff)));
        this.rpc.getRpcMetrics().markRetry();
        this.retryExecutorService.schedule(this.getRunnable(), nextBackOff, TimeUnit.MILLISECONDS);
    }

    protected Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractRetryingOperation.this.run();
            }
        };
    }

    protected boolean isRequestRetryable() {
        return this.rpc.isRetryable(this.getRetryRequest());
    }

    protected boolean isStatusRetryable(Status status) {
        return this.retryOptions.isRetryable(status.getCode());
    }

    protected void setException(Exception exception) {
        this.completionFuture.setException(exception);
    }

    protected abstract boolean onOK(Metadata var1);

    protected Long getNextBackoff() {
        this.currentBackoff = this.exponentialRetryAlgorithm.createNextAttempt(this.currentBackoff);
        if (!this.exponentialRetryAlgorithm.shouldRetry(this.currentBackoff)) {
            long timeLeftNs = this.currentBackoff.getGlobalSettings().getTotalTimeout().toNanos() - (this.clock.nanoTime() - this.currentBackoff.getFirstAttemptStartTimeNanos());
            long timeLeftMs = TimeUnit.NANOSECONDS.toMillis(timeLeftNs);
            if (timeLeftMs > this.currentBackoff.getGlobalSettings().getInitialRetryDelay().toMillis()) {
                return timeLeftMs;
            }
            return null;
        }
        return this.currentBackoff.getRandomizedRetryDelay().toMillis();
    }

    @VisibleForTesting
    public boolean inRetryMode() {
        return this.currentBackoff != null && this.currentBackoff.getAttemptCount() > 0;
    }

    protected void resetStatusBasedBackoff() {
        this.currentBackoff = this.exponentialRetryAlgorithm.createFirstAttempt();
        this.failedCount = 0;
    }

    private ExponentialRetryAlgorithm createRetryAlgorithm(ApiClock clock) {
        Optional<Long> operationTimeoutMs = this.deadlineGenerator.getOperationTimeoutMs();
        long timeoutMs = operationTimeoutMs.or(Long.valueOf(this.retryOptions.getMaxElapsedBackoffMillis()));
        RetrySettings retrySettings = RetrySettings.newBuilder().setJittered(true).setInitialRetryDelay(AbstractRetryingOperation.toDuration(this.retryOptions.getInitialBackoffMillis())).setRetryDelayMultiplier(this.retryOptions.getBackoffMultiplier()).setMaxRetryDelay(Duration.of(1L, ChronoUnit.MINUTES)).setTotalTimeout(AbstractRetryingOperation.toDuration(timeoutMs)).build();
        return new ExponentialRetryAlgorithm(retrySettings, clock);
    }

    private static Duration toDuration(long millis) {
        return Duration.of(millis, ChronoUnit.MILLIS);
    }

    protected void run() {
        if (this.currentBackoff == null) {
            this.currentBackoff = this.exponentialRetryAlgorithm.createFirstAttempt();
        }
        try (Scope scope = TRACER.withSpan(this.operationSpan);){
            this.rpcTimerContext = this.rpc.getRpcMetrics().timeRpc();
            this.operationSpan.addAnnotation(Annotation.fromDescriptionAndAttributes("rpcStart", ImmutableMap.of("attempt", AttributeValue.longAttributeValue(this.failedCount))));
            Metadata metadata = new Metadata();
            metadata.merge(this.originalMetadata);
            Optional<Deadline> rpcAttemptDeadline = this.deadlineGenerator.getRpcAttemptDeadline();
            CallOptions callOptions = rpcAttemptDeadline.isPresent() ? CallOptions.DEFAULT.withDeadline(rpcAttemptDeadline.get()) : CallOptions.DEFAULT;
            this.callWrapper.setCallAndStart(this.rpc, callOptions, this.getRetryRequest(), this, metadata);
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    protected RequestT getRetryRequest() {
        return this.request;
    }

    public ListenableFuture<ResultT> getAsyncResult() {
        Preconditions.checkState(this.operationTimerContext == null);
        this.operationTimerContext = this.rpc.getRpcMetrics().timeOperation();
        this.run();
        return this.completionFuture;
    }

    public void cancel() {
        this.cancel("User requested cancellation.");
    }

    public ResultT getBlockingResult() {
        try {
            return (ResultT)this.getAsyncResult().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.cancel();
            throw Status.CANCELLED.withCause(e).asRuntimeException();
        }
        catch (ExecutionException e) {
            this.cancel();
            throw Status.fromThrowable(e).asRuntimeException();
        }
    }

    protected void cancel(String message) {
        this.callWrapper.cancel(message, null);
    }

    protected class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        protected GrpcFuture() {
        }

        @Override
        protected void interruptTask() {
            if (!this.isDone()) {
                AbstractRetryingOperation.this.cancel("Request interrupted.");
            }
        }

        @Override
        public boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

