/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.core.IBulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ApiFutureUtil;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;

@InternalApi(value="For internal usage only - please use BulkMutation")
public class BulkMutationWrapper
implements IBulkMutation {
    private final BulkMutation delegate;
    private boolean isClosed;

    public BulkMutationWrapper(BulkMutation bulkMutation) {
        this.delegate = bulkMutation;
    }

    @Override
    public ApiFuture<Void> add(RowMutationEntry rowMutation) {
        Preconditions.checkState(!this.isClosed, "can't mutate when the bulk mutation is closed.");
        return ApiFutureUtil.transformAndAdapt(this.delegate.add(rowMutation.toProto()), new Function<MutateRowResponse, Void>(){

            @Override
            public Void apply(MutateRowResponse response) {
                return null;
            }
        });
    }

    @Override
    public void sendUnsent() {
        this.delegate.sendUnsent();
    }

    @Override
    public void flush() throws InterruptedException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }
}

