/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@InternalApi(value="For internal usage only")
public class MutateRowsRequestManager {
    private static final com.google.bigtable.repackaged.com.google.rpc.Status STATUS_INTERNAL = com.google.bigtable.repackaged.com.google.rpc.Status.newBuilder().setCode(Status.Code.INTERNAL.value()).setMessage("Response was not returned for this index.").build();
    private volatile MutateRowsRequest currentRequest;
    private int[] mapToOriginalIndex;
    private final com.google.bigtable.repackaged.com.google.rpc.Status[] results;
    private final RetryOptions retryOptions;
    private final MutateRowsRequest originalRequest;
    private boolean messageIsInvalid = false;

    private static Status.Code getGrpcCode(com.google.bigtable.repackaged.com.google.rpc.Status status) {
        return status == null ? null : Status.fromCodeValue(status.getCode()).getCode();
    }

    private static MutateRowsResponse.Entry createEntry(int i, com.google.bigtable.repackaged.com.google.rpc.Status status) {
        return MutateRowsResponse.Entry.newBuilder().setIndex(i).setStatus(status).build();
    }

    public MutateRowsRequestManager(RetryOptions retryOptions, MutateRowsRequest originalRequest) {
        this.currentRequest = originalRequest;
        this.originalRequest = originalRequest;
        this.retryOptions = retryOptions;
        this.results = new com.google.bigtable.repackaged.com.google.rpc.Status[originalRequest.getEntriesCount()];
        this.mapToOriginalIndex = new int[originalRequest.getEntriesCount()];
        for (int i = 0; i < this.mapToOriginalIndex.length; ++i) {
            this.mapToOriginalIndex[i] = i;
        }
    }

    public void onMessage(MutateRowsResponse message) {
        for (MutateRowsResponse.Entry entry : message.getEntriesList()) {
            int index = (int)entry.getIndex();
            if (index >= this.mapToOriginalIndex.length || index < 0) {
                this.messageIsInvalid = true;
                break;
            }
            this.results[this.mapToOriginalIndex[index]] = entry.getStatus();
        }
    }

    public ProcessingStatus onOK() {
        if (!this.messageIsInvalid) {
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] != null) continue;
                this.messageIsInvalid = true;
                break;
            }
        }
        if (this.messageIsInvalid) {
            return ProcessingStatus.INVALID;
        }
        ArrayList<Integer> toRetry = new ArrayList<Integer>();
        ProcessingStatus processingStatus = ProcessingStatus.SUCCESS;
        for (int i = 0; i < this.results.length; ++i) {
            com.google.bigtable.repackaged.com.google.rpc.Status status = this.results[i];
            if (status.getCode() == Status.Code.OK.value()) continue;
            if (this.retryOptions.isRetryable(MutateRowsRequestManager.getGrpcCode(status))) {
                toRetry.add(i);
                if (processingStatus != ProcessingStatus.SUCCESS) continue;
                processingStatus = ProcessingStatus.RETRYABLE;
                continue;
            }
            processingStatus = ProcessingStatus.NOT_RETRYABLE;
            break;
        }
        if (!toRetry.isEmpty()) {
            this.currentRequest = this.createRetryRequest(toRetry);
        }
        return processingStatus;
    }

    public MutateRowsRequest getRetryRequest() {
        return this.currentRequest;
    }

    private MutateRowsRequest createRetryRequest(List<Integer> indicesToRetry) {
        MutateRowsRequest.Builder updatedRequest = MutateRowsRequest.newBuilder().setTableName(this.originalRequest.getTableName());
        this.mapToOriginalIndex = new int[indicesToRetry.size()];
        for (int i = 0; i < indicesToRetry.size(); ++i) {
            this.mapToOriginalIndex[i] = indicesToRetry.get(i);
            updatedRequest.addEntries(this.originalRequest.getEntries(indicesToRetry.get(i)));
        }
        return updatedRequest.build();
    }

    public MutateRowsResponse buildResponse() {
        ArrayList<MutateRowsResponse.Entry> entries = new ArrayList<MutateRowsResponse.Entry>();
        for (int i = 0; i < this.results.length; ++i) {
            com.google.bigtable.repackaged.com.google.rpc.Status status = this.results[i] == null ? STATUS_INTERNAL : this.results[i];
            entries.add(MutateRowsRequestManager.createEntry(i, status));
        }
        return MutateRowsResponse.newBuilder().addAllEntries(entries).build();
    }

    public String getResultString() {
        TreeMap resultCounts = new TreeMap();
        for (com.google.bigtable.repackaged.com.google.rpc.Status result : this.results) {
            TreeMap<String, Long> msgCounts;
            if (result == null) {
                result = STATUS_INTERNAL;
            }
            if ((msgCounts = (TreeMap<String, Long>)resultCounts.get(result.getCode())) == null) {
                msgCounts = new TreeMap<String, Long>();
                resultCounts.put(result.getCode(), msgCounts);
            }
            String msg = MoreObjects.firstNonNull(result.getMessage(), "");
            Long count = MoreObjects.firstNonNull(msgCounts.get(msg), 0L);
            msgCounts.put(msg, count + 1L);
        }
        StringBuilder buffer = new StringBuilder();
        boolean isFirstCode = true;
        for (Map.Entry codeEntry : resultCounts.entrySet()) {
            if (!isFirstCode) {
                buffer.append("; ");
            } else {
                isFirstCode = false;
            }
            buffer.append((Object)Status.fromCodeValue((Integer)codeEntry.getKey()).getCode());
            buffer.append(": ");
            boolean isFirstMsg = true;
            for (Map.Entry msgEntry : ((Map)codeEntry.getValue()).entrySet()) {
                if (!isFirstMsg) {
                    buffer.append(", ");
                } else {
                    isFirstMsg = false;
                }
                buffer.append((String)msgEntry.getKey());
                buffer.append("(" + msgEntry.getValue() + ")");
            }
        }
        return buffer.toString();
    }

    public static enum ProcessingStatus {
        SUCCESS,
        RETRYABLE,
        NOT_RETRYABLE,
        INVALID;

    }
}

