/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CredentialFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.CredentialsInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import java.io.IOException;
import java.security.GeneralSecurityException;

@InternalApi(value="For internal usage only")
public class CredentialInterceptorCache {
    private static CredentialInterceptorCache instance = new CredentialInterceptorCache();
    private ClientInterceptor defaultCredentialInterceptor;

    public static CredentialInterceptorCache getInstance() {
        return instance;
    }

    private CredentialInterceptorCache() {
    }

    public synchronized ClientInterceptor getCredentialsInterceptor(CredentialOptions credentialOptions) throws IOException, GeneralSecurityException {
        boolean isDefaultCredentials;
        boolean bl = isDefaultCredentials = credentialOptions.getCredentialType() == CredentialOptions.CredentialType.DefaultCredentials;
        if (isDefaultCredentials && this.defaultCredentialInterceptor != null) {
            return this.defaultCredentialInterceptor;
        }
        Credentials credentials = CredentialFactory.getCredentials(credentialOptions);
        if (credentials == null) {
            return null;
        }
        CredentialsInterceptor credentialsInterceptor = new CredentialsInterceptor(credentials);
        if (isDefaultCredentials) {
            this.defaultCredentialInterceptor = credentialsInterceptor;
        }
        return credentialsInterceptor;
    }
}

