/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@InternalApi(value="For internal usage only")
@NotThreadSafe
public class ResumingStreamingResultScanner
implements ResultScanner<FlatRow> {
    private static final Meter resultsMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "scanner.results");
    private static final Timer resultsTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Debug, "scanner.results.latency");
    private final ResponseQueueReader responseQueueReader;
    private boolean isConsumed;

    public ResumingStreamingResultScanner(ResponseQueueReader responseQueueReader) {
        this.responseQueueReader = responseQueueReader;
    }

    public final FlatRow[] next(int count) throws IOException {
        FlatRow row;
        ArrayList<FlatRow> resultList = new ArrayList<FlatRow>(count);
        for (int i = 0; i < count && (row = this.next()) != null; ++i) {
            resultList.add(row);
        }
        return resultList.toArray(new FlatRow[resultList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FlatRow next() throws IOException {
        if (this.isConsumed) {
            return null;
        }
        try (Timer.Context ignored = resultsTimer.time();){
            FlatRow result = this.responseQueueReader.getNextMergedRow();
            if (result != null) {
                resultsMeter.mark();
            } else {
                this.isConsumed = true;
            }
            FlatRow flatRow = result;
            return flatRow;
        }
        catch (IOException | RuntimeException e) {
            this.isConsumed = true;
            throw e;
        }
    }

    @Override
    public int available() {
        return this.responseQueueReader.available();
    }

    @Override
    public void close() {
        if (this.isConsumed) {
            return;
        }
        this.isConsumed = true;
        this.responseQueueReader.close();
    }
}

