/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.util;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class ReferenceCountedHashMap<K, V>
extends HashMap<K, V> {
    private final Map<Object, Integer> counterMap;
    private final Callable<V> cleanerCallback;

    public ReferenceCountedHashMap() {
        this.cleanerCallback = null;
        this.counterMap = new HashMap<Object, Integer>();
    }

    public ReferenceCountedHashMap(Callable<V> cleanerCallable) {
        this.cleanerCallback = cleanerCallable;
        this.counterMap = new HashMap<Object, Integer>();
    }

    @Override
    public synchronized V put(K key, V value) {
        Integer currentCount = this.updateReference(key, 1);
        if (currentCount == 1) {
            return super.put(key, value);
        }
        return super.get(key);
    }

    @Override
    public synchronized V remove(Object key) {
        if (!super.containsKey(key)) {
            return null;
        }
        Integer currentCount = this.updateReference(key, -1);
        if (currentCount <= 0) {
            Object value = super.remove(key);
            if (this.cleanerCallback != null) {
                this.cleanerCallback.call(value);
            }
            return value;
        }
        return super.get(key);
    }

    @Override
    public void clear() {
        this.counterMap.clear();
        super.clear();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Reference-counted objects should not be cloned.");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Uncommon method for this use-case.");
    }

    private Integer updateReference(Object key, Integer updateCount) {
        Integer currentCount = updateCount + MoreObjects.firstNonNull(this.counterMap.get(key), 0);
        if (currentCount <= 0) {
            this.counterMap.remove(key);
        } else {
            this.counterMap.put(key, currentCount);
        }
        return currentCount;
    }

    public static interface Callable<I> {
        public void call(I var1);
    }
}

