/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public class ClusterAutoscalingConfig {
    private final String clusterId;
    private final String instanceId;
    private final PartialUpdateClusterRequest.Builder builder = PartialUpdateClusterRequest.newBuilder();
    private final Cluster.ClusterConfig.Builder clusterConfigBuilder = Cluster.ClusterConfig.newBuilder();

    public static ClusterAutoscalingConfig of(@Nonnull String instanceId, @Nonnull String clusterId) {
        return new ClusterAutoscalingConfig(instanceId, clusterId);
    }

    private ClusterAutoscalingConfig(@Nonnull String instanceId, @Nonnull String clusterId) {
        Preconditions.checkNotNull(instanceId, "instanceId can't be null");
        Preconditions.checkNotNull(clusterId, "clusterId can't be null");
        this.instanceId = instanceId;
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ClusterAutoscalingConfig setMinNodes(int minNodes) {
        this.builder.setUpdateMask(FieldMaskUtil.union(this.builder.getUpdateMask(), FieldMaskUtil.fromString(Cluster.class, "cluster_config.cluster_autoscaling_config.autoscaling_limits.min_serve_nodes"), new FieldMask[0]));
        this.clusterConfigBuilder.getClusterAutoscalingConfigBuilder().getAutoscalingLimitsBuilder().setMinServeNodes(minNodes);
        return this;
    }

    public ClusterAutoscalingConfig setMaxNodes(int maxNodes) {
        this.builder.setUpdateMask(FieldMaskUtil.union(this.builder.getUpdateMask(), FieldMaskUtil.fromString(Cluster.class, "cluster_config.cluster_autoscaling_config.autoscaling_limits.max_serve_nodes"), new FieldMask[0]));
        this.clusterConfigBuilder.getClusterAutoscalingConfigBuilder().getAutoscalingLimitsBuilder().setMaxServeNodes(maxNodes);
        return this;
    }

    public ClusterAutoscalingConfig setCpuUtilizationTargetPercent(int cpuUtilizationTargetPercent) {
        this.builder.setUpdateMask(FieldMaskUtil.union(this.builder.getUpdateMask(), FieldMaskUtil.fromString(Cluster.class, "cluster_config.cluster_autoscaling_config.autoscaling_targets.cpu_utilization_percent"), new FieldMask[0]));
        this.clusterConfigBuilder.getClusterAutoscalingConfigBuilder().getAutoscalingTargetsBuilder().setCpuUtilizationPercent(cpuUtilizationTargetPercent);
        return this;
    }

    public int getMinNodes() {
        return this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMinServeNodes();
    }

    public int getMaxNodes() {
        return this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMaxServeNodes();
    }

    public int getCpuUtilizationTargetPercent() {
        return this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingTargets().getCpuUtilizationPercent();
    }

    @InternalApi
    public PartialUpdateClusterRequest toProto(String projectId) {
        this.builder.getClusterBuilder().setName(NameUtil.formatClusterName(projectId, this.instanceId, this.clusterId)).setClusterConfig(this.clusterConfigBuilder.build());
        return this.builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAutoscalingConfig that = (ClusterAutoscalingConfig)o;
        return Objects.equal(this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMaxServeNodes(), that.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMaxServeNodes()) && Objects.equal(this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMinServeNodes(), that.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMinServeNodes()) && Objects.equal(this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingTargets().getCpuUtilizationPercent(), that.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingTargets().getCpuUtilizationPercent()) && Objects.equal(this.clusterId, that.clusterId) && Objects.equal(this.instanceId, that.instanceId);
    }

    public int hashCode() {
        return Objects.hashCode(this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMaxServeNodes(), this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingLimits().getMinServeNodes(), this.clusterConfigBuilder.getClusterAutoscalingConfig().getAutoscalingTargets().getCpuUtilizationPercent(), this.clusterId, this.instanceId);
    }
}

