/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.contrib.zpages;

import com.google.bigtable.repackaged.com.google.common.base.Charsets;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.Style;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.ZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.trace.config.TraceConfig;
import com.google.bigtable.repackaged.io.opencensus.trace.config.TraceParams;
import com.google.bigtable.repackaged.io.opencensus.trace.samplers.Samplers;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;

final class TraceConfigzZPageHandler
extends ZPageHandler {
    private static final String TRACE_CONFIGZ_URL = "/traceconfigz";
    private final TraceConfig traceConfig;
    private static final String CHANGE = "change";
    private static final String PERMANENT_CHANGE = "permanently";
    private static final String RESTORE_DEFAULT_CHANGE = "restore_default";
    private static final String QUERY_COMPONENT_SAMPLING_PROBABILITY = "samplingprobability";
    private static final String QUERY_COMPONENT_MAX_NUMBER_OF_ATTRIBUTES = "maxnumberofattributes";
    private static final String QUERY_COMPONENT_MAX_NUMBER_OF_ANNOTATIONS = "maxnumberofannotations";
    private static final String QUERY_COMPONENT_MAX_NUMBER_OF_NETWORK_EVENTS = "maxnumberofnetworkevents";
    private static final String QUERY_COMPONENT_MAX_NUMBER_OF_LINKS = "maxnumberoflinks";
    private static final String TRACECONFIGZ_FORM_BODY = "<form action=/traceconfigz method=get>%n<table class=\"small\" rules=\"all\">%n<td colspan=\"3\" class=\"col_head\">Permanently change <input type=\"hidden\" name=\"%s\" value=\"%s\"></td>%n<tr><td>SamplingProbability to</td> <td><input type=text size=15 name=%s value=\"\"></td> <td>(%s)</td>%n<tr><td>MaxNumberOfAttributes to</td> <td><input type=text size=15 name=%s value=\"\"></td> <td>(%d)</td>%n<tr><td>MaxNumberOfAnnotations to</td><td><input type=text size=15 name=%s value=\"\"></td> <td>(%d)</td>%n<tr><td>MaxNumberOfNetworkEvents to</td> <td><input type=text size=15 name=%s value=\"\"></td> <td>(%d)</td>%n<tr><td>MaxNumberOfLinks to</td><td><input type=text size=15 name=%s value=\"\"></td> <td>(%d)</td>%n</table>%n<input class=\"button\" type=submit value=Submit>%n</form>";
    private static final String RESTORE_DEFAULT_FORM_BODY = "<form action=/traceconfigz method=get>%n<b class=\"title\">Restore default</b> %n<input type=\"hidden\" name=\"%s\" value=\"%s\"></td>%n</br>%n<input class=\"button\" type=submit value=Reset>%n</form>";

    static TraceConfigzZPageHandler create(TraceConfig traceConfig) {
        return new TraceConfigzZPageHandler(traceConfig);
    }

    @Override
    public String getUrlPath() {
        return TRACE_CONFIGZ_URL;
    }

    private static void emitStyle(PrintWriter out) {
        out.write("<style>\n");
        out.write(Style.style);
        out.write("</style>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8)));
        out.write("<!DOCTYPE html>\n");
        out.write("<html lang=\"en\"><head>\n");
        out.write("<meta charset=\"utf-8\">\n");
        out.write("<title>TraceConfigZ</title>\n");
        out.write("<link rel=\"shortcut icon\" href=\"https://opencensus.io/images/favicon.ico\"/>\n");
        out.write("<link href=\"https://fonts.googleapis.com/css?family=Open+Sans:300\"rel=\"stylesheet\">\n");
        out.write("<link href=\"https://fonts.googleapis.com/css?family=Roboto\"rel=\"stylesheet\">\n");
        TraceConfigzZPageHandler.emitStyle(out);
        out.write("</head>\n");
        out.write("<body>\n");
        out.write("<p class=\"header\"><img class=\"oc\" src=\"https://opencensus.io/img/logo-sm.svg\" />Open<span>Census</span></p>");
        out.write("<h1 class=\"left\">Trace Configuration</h1>");
        out.write("<p></p>");
        try {
            this.maybeApplyChanges(queryMap);
        }
        catch (Throwable throwable) {
            out.printf(TRACECONFIGZ_FORM_BODY, CHANGE, PERMANENT_CHANGE, QUERY_COMPONENT_SAMPLING_PROBABILITY, "0.0001", QUERY_COMPONENT_MAX_NUMBER_OF_ATTRIBUTES, TraceParams.DEFAULT.getMaxNumberOfAttributes(), QUERY_COMPONENT_MAX_NUMBER_OF_ANNOTATIONS, TraceParams.DEFAULT.getMaxNumberOfAnnotations(), QUERY_COMPONENT_MAX_NUMBER_OF_NETWORK_EVENTS, TraceParams.DEFAULT.getMaxNumberOfNetworkEvents(), QUERY_COMPONENT_MAX_NUMBER_OF_LINKS, TraceParams.DEFAULT.getMaxNumberOfLinks());
            out.write("<br>\n");
            out.printf(RESTORE_DEFAULT_FORM_BODY, CHANGE, RESTORE_DEFAULT_CHANGE);
            out.write("<br>\n");
            TraceConfigzZPageHandler.emitTraceParamsTable(this.traceConfig.getActiveTraceParams(), out);
            out.write("</body>\n");
            out.write("</html>\n");
            out.close();
            throw throwable;
        }
        out.printf(TRACECONFIGZ_FORM_BODY, CHANGE, PERMANENT_CHANGE, QUERY_COMPONENT_SAMPLING_PROBABILITY, "0.0001", QUERY_COMPONENT_MAX_NUMBER_OF_ATTRIBUTES, TraceParams.DEFAULT.getMaxNumberOfAttributes(), QUERY_COMPONENT_MAX_NUMBER_OF_ANNOTATIONS, TraceParams.DEFAULT.getMaxNumberOfAnnotations(), QUERY_COMPONENT_MAX_NUMBER_OF_NETWORK_EVENTS, TraceParams.DEFAULT.getMaxNumberOfNetworkEvents(), QUERY_COMPONENT_MAX_NUMBER_OF_LINKS, TraceParams.DEFAULT.getMaxNumberOfLinks());
        out.write("<br>\n");
        out.printf(RESTORE_DEFAULT_FORM_BODY, CHANGE, RESTORE_DEFAULT_CHANGE);
        out.write("<br>\n");
        TraceConfigzZPageHandler.emitTraceParamsTable(this.traceConfig.getActiveTraceParams(), out);
        out.write("</body>\n");
        out.write("</html>\n");
        out.close();
    }

    private void maybeApplyChanges(Map<String, String> queryMap) {
        String changeStr = queryMap.get(CHANGE);
        if (PERMANENT_CHANGE.equals(changeStr)) {
            String maxNumverOfLinksStr;
            String maxNumberOfNetworkEventsStr;
            String maxNumberOfAnnotationsStr;
            String maxNumberOfAttributesStr;
            TraceParams.Builder traceParamsBuilder = this.traceConfig.getActiveTraceParams().toBuilder();
            String samplingProbabilityStr = queryMap.get(QUERY_COMPONENT_SAMPLING_PROBABILITY);
            if (!Strings.isNullOrEmpty(samplingProbabilityStr)) {
                double samplingProbability = Double.parseDouble(samplingProbabilityStr);
                traceParamsBuilder.setSampler(Samplers.probabilitySampler(samplingProbability));
            }
            if (!Strings.isNullOrEmpty(maxNumberOfAttributesStr = queryMap.get(QUERY_COMPONENT_MAX_NUMBER_OF_ATTRIBUTES))) {
                int maxNumberOfAttributes = Integer.parseInt(maxNumberOfAttributesStr);
                traceParamsBuilder.setMaxNumberOfAttributes(maxNumberOfAttributes);
            }
            if (!Strings.isNullOrEmpty(maxNumberOfAnnotationsStr = queryMap.get(QUERY_COMPONENT_MAX_NUMBER_OF_ANNOTATIONS))) {
                int maxNumberOfAnnotations = Integer.parseInt(maxNumberOfAnnotationsStr);
                traceParamsBuilder.setMaxNumberOfAnnotations(maxNumberOfAnnotations);
            }
            if (!Strings.isNullOrEmpty(maxNumberOfNetworkEventsStr = queryMap.get(QUERY_COMPONENT_MAX_NUMBER_OF_NETWORK_EVENTS))) {
                int maxNumberOfNetworkEvents = Integer.parseInt(maxNumberOfNetworkEventsStr);
                traceParamsBuilder.setMaxNumberOfNetworkEvents(maxNumberOfNetworkEvents);
            }
            if (!Strings.isNullOrEmpty(maxNumverOfLinksStr = queryMap.get(QUERY_COMPONENT_MAX_NUMBER_OF_LINKS))) {
                int maxNumberOfLinks = Integer.parseInt(maxNumverOfLinksStr);
                traceParamsBuilder.setMaxNumberOfLinks(maxNumberOfLinks);
            }
            this.traceConfig.updateActiveTraceParams(traceParamsBuilder.build());
        } else if (RESTORE_DEFAULT_CHANGE.equals(changeStr)) {
            this.traceConfig.updateActiveTraceParams(TraceParams.DEFAULT);
        }
    }

    private static void emitTraceParamsTable(TraceParams params, PrintWriter out) {
        out.write("<b class=\"title\">Active tracing parameters:</b><br>\n<table class=\"small\" rules=\"all\">\n  <tr>\n    <td class=\"col_headR\">Name</td>\n    <td class=\"col_head\">Value</td>\n  </tr>\n");
        out.printf("  <tr>%n    <td>Sampler</td>%n    <td>%s</td>%n  </tr>%n", params.getSampler().getDescription());
        out.printf("  <tr>%n    <td>MaxNumberOfAttributes</td>%n    <td>%d</td>%n  </tr>%n", params.getMaxNumberOfAttributes());
        out.printf("  <tr>%n    <td>MaxNumberOfAnnotations</td>%n    <td>%d</td>%n  </tr>%n", params.getMaxNumberOfAnnotations());
        out.printf("  <tr>%n    <td>MaxNumberOfNetworkEvents</td>%n    <td>%d</td>%n  </tr>%n", params.getMaxNumberOfNetworkEvents());
        out.printf("  <tr>%n    <td>MaxNumberOfLinks</td>%n    <td>%d</td>%n  </tr>%n", params.getMaxNumberOfLinks());
        out.write("</table>\n");
    }

    private TraceConfigzZPageHandler(TraceConfig traceConfig) {
        this.traceConfig = traceConfig;
    }
}

