/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerRegistry;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.JsonUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ServiceConfigUtil;
import com.google.bigtable.repackaged.io.grpc.xds.WrrLocalityLoadBalancer;
import java.util.List;
import java.util.Map;

@Internal
public final class WrrLocalityLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WrrLocalityLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "wrr_locality_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            List<ServiceConfigUtil.LbConfig> childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(rawConfig, "childPolicy"));
            if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No child policy in wrr_locality LB policy: " + rawConfig));
            }
            NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList(childConfigCandidates, LoadBalancerRegistry.getDefaultRegistry());
            if (selectedConfig.getError() != null) {
                return selectedConfig;
            }
            ServiceConfigUtil.PolicySelection policySelection = (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig();
            return NameResolver.ConfigOrError.fromConfig(new WrrLocalityLoadBalancer.WrrLocalityConfig(policySelection));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.fromThrowable(e).withDescription("Failed to parse wrr_locality LB config: " + rawConfig));
        }
    }
}

