/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class NameUtil {
    private static final Pattern TABLE_PATTERN = Pattern.compile("projects/([^/]+)/instances/([^/]+)/tables/([^/]+)");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("projects/([^/]+)/locations/([^/]+)");
    private static final Pattern BACKUP_PATTERN = Pattern.compile("projects/([^/]+)/instances/([^/]+)/clusters/([^/]+)/backups/([^/]+)");

    public static String formatProjectName(String projectId) {
        return "projects/" + projectId;
    }

    public static String formatInstanceName(String projectId, String instanceId) {
        return NameUtil.formatProjectName(projectId) + "/instances/" + instanceId;
    }

    public static String formatTableName(String projectId, String instanceId, String tableId) {
        return NameUtil.formatInstanceName(projectId, instanceId) + "/tables/" + tableId;
    }

    public static String formatLocationName(String projectId, String zone) {
        return NameUtil.formatProjectName(projectId) + "/locations/" + zone;
    }

    public static String formatBackupName(String projectId, String instanceId, String clusterId, String backupId) {
        return NameUtil.formatClusterName(projectId, instanceId, clusterId) + "/backups/" + backupId;
    }

    public static String extractTableIdFromTableName(String fullTableName) {
        Matcher matcher = TABLE_PATTERN.matcher(fullTableName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid table name: " + fullTableName);
        }
        return matcher.group(3);
    }

    public static String extractBackupIdFromBackupName(String fullBackupName) {
        Matcher matcher = BACKUP_PATTERN.matcher(fullBackupName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid backup name: " + fullBackupName);
        }
        return matcher.group(4);
    }

    public static String extractZoneIdFromLocationName(String fullLocationName) {
        Matcher matcher = LOCATION_PATTERN.matcher(fullLocationName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid location name: " + fullLocationName);
        }
        return matcher.group(2);
    }

    public static String formatClusterName(String projectId, String instanceId, String clusterId) {
        return NameUtil.formatInstanceName(projectId, instanceId) + "/clusters/" + clusterId;
    }

    public static String formatAppProfileName(String projectId, String instanceId, String appProfileId) {
        return NameUtil.formatInstanceName(projectId, instanceId) + "/appProfiles/" + appProfileId;
    }
}

