/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.stats;

import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.IntervalMetricReader;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricReader;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.Metrics;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.stats.BigtableCreateTimeSeriesExporter;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@InternalApi
public class BigtableStackdriverStatsExporter {
    static final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private static BigtableStackdriverStatsExporter instance = null;
    private static final Duration EXPORT_INTERVAL = Duration.create(60L, 0);
    private static final String RESOURCE_TYPE = "bigtable_client_raw";
    private final IntervalMetricReader intervalMetricReader;

    private BigtableStackdriverStatsExporter(MetricServiceClient metricServiceClient, Duration exportInterval, MonitoredResource monitoredResource) {
        IntervalMetricReader.Options.Builder intervalMetricReaderOptionsBuilder = IntervalMetricReader.Options.builder();
        intervalMetricReaderOptionsBuilder.setExportInterval(exportInterval);
        this.intervalMetricReader = IntervalMetricReader.create(new BigtableCreateTimeSeriesExporter(metricServiceClient, monitoredResource), MetricReader.create(MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).build()), intervalMetricReaderOptionsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Credentials credentials) throws IOException {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkState(instance == null, "Bigtable Stackdriver stats exporter is already created");
            MetricServiceClient client = BigtableStackdriverStatsExporter.createMetricServiceClient(credentials, Duration.create(60L, 0));
            MonitoredResource resourceType = MonitoredResource.newBuilder().setType(RESOURCE_TYPE).build();
            instance = new BigtableStackdriverStatsExporter(client, EXPORT_INTERVAL, resourceType);
        }
    }

    @GuardedBy(value="lock")
    @VisibleForTesting
    static MetricServiceClient createMetricServiceClient(Credentials credentials, Duration deadline) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider(InstantiatingGrpcChannelProvider.newBuilder().build());
        settingsBuilder.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
        com.google.bigtable.repackaged.org.threeten.bp.Duration stackdriverDuration = com.google.bigtable.repackaged.org.threeten.bp.Duration.ofMillis(deadline.toMillis());
        settingsBuilder.createTimeSeriesSettings().setSimpleTimeoutNoRetries(stackdriverDuration);
        return MetricServiceClient.create(settingsBuilder.build());
    }
}

