/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.stats;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.stats.MeasureMap;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContextBuilder;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.tags.Tags;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import java.util.Map;

@InternalApi(value="For internal use only")
public class StatsRecorderWrapper {
    private final ApiTracerFactory.OperationType operationType;
    private final Tagger tagger;
    private final StatsRecorder statsRecorder;
    private final TagContext parentContext;
    private final SpanName spanName;
    private final Map<String, String> statsAttributes;
    private MeasureMap attemptMeasureMap;
    private MeasureMap operationMeasureMap;

    public StatsRecorderWrapper(ApiTracerFactory.OperationType operationType, SpanName spanName, Map<String, String> statsAttributes, StatsRecorder statsRecorder) {
        this.operationType = operationType;
        this.tagger = Tags.getTagger();
        this.statsRecorder = statsRecorder;
        this.spanName = spanName;
        this.parentContext = this.tagger.getCurrentTagContext();
        this.statsAttributes = statsAttributes;
        this.attemptMeasureMap = statsRecorder.newMeasureMap();
        this.operationMeasureMap = statsRecorder.newMeasureMap();
    }

    public void recordOperation(String status, String tableId, String zone, String cluster) {
        TagContextBuilder tagCtx = this.newTagContextBuilder(tableId, zone, cluster).putLocal(BuiltinMeasureConstants.STATUS, TagValue.create(status));
        boolean isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        tagCtx.putLocal(BuiltinMeasureConstants.STREAMING, TagValue.create(Boolean.toString(isStreaming)));
        this.operationMeasureMap.record(tagCtx.build());
        this.operationMeasureMap = this.statsRecorder.newMeasureMap();
    }

    public void recordAttempt(String status, String tableId, String zone, String cluster) {
        TagContextBuilder tagCtx = this.newTagContextBuilder(tableId, zone, cluster).putLocal(BuiltinMeasureConstants.STATUS, TagValue.create(status));
        boolean isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        tagCtx.putLocal(BuiltinMeasureConstants.STREAMING, TagValue.create(Boolean.toString(isStreaming)));
        this.attemptMeasureMap.record(tagCtx.build());
        this.attemptMeasureMap = this.statsRecorder.newMeasureMap();
    }

    public void putOperationLatencies(long operationLatency) {
        this.operationMeasureMap.put(BuiltinMeasureConstants.OPERATION_LATENCIES, operationLatency);
    }

    public void putAttemptLatencies(long attemptLatency) {
        this.attemptMeasureMap.put(BuiltinMeasureConstants.ATTEMPT_LATENCIES, attemptLatency);
    }

    public void putRetryCount(int attemptCount) {
        this.operationMeasureMap.put(BuiltinMeasureConstants.RETRY_COUNT, attemptCount);
    }

    public void putApplicationLatencies(long applicationLatency) {
        this.operationMeasureMap.put(BuiltinMeasureConstants.APPLICATION_LATENCIES, applicationLatency);
    }

    public void putFirstResponseLatencies(long firstResponseLatency) {
        this.operationMeasureMap.put(BuiltinMeasureConstants.FIRST_RESPONSE_LATENCIES, firstResponseLatency);
    }

    public void putGfeLatencies(long serverLatency) {
        this.attemptMeasureMap.put(BuiltinMeasureConstants.SERVER_LATENCIES, serverLatency);
    }

    public void putGfeMissingHeaders(long connectivityErrors) {
        this.attemptMeasureMap.put(BuiltinMeasureConstants.CONNECTIVITY_ERROR_COUNT, connectivityErrors);
    }

    public void putBatchRequestThrottled(long throttledTimeMs) {
        this.operationMeasureMap.put(BuiltinMeasureConstants.THROTTLING_LATENCIES, throttledTimeMs);
    }

    private TagContextBuilder newTagContextBuilder(String tableId, String zone, String cluster) {
        TagContextBuilder tagContextBuilder = this.tagger.toBuilder(this.parentContext).putLocal(BuiltinMeasureConstants.CLIENT_NAME, TagValue.create("bigtable-java")).putLocal(BuiltinMeasureConstants.METHOD, TagValue.create(this.spanName.toString())).putLocal(BuiltinMeasureConstants.TABLE, TagValue.create(tableId)).putLocal(BuiltinMeasureConstants.ZONE, TagValue.create(zone)).putLocal(BuiltinMeasureConstants.CLUSTER, TagValue.create(cluster));
        for (Map.Entry<String, String> entry : this.statsAttributes.entrySet()) {
            tagContextBuilder.putLocal(TagKey.create(entry.getKey()), TagValue.create(entry.getValue()));
        }
        return tagContextBuilder;
    }
}

