/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.ServiceMonitoringServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.GrpcServiceMonitoringServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.ServiceMonitoringServiceStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateServiceLevelObjectiveRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateServiceRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.DeleteServiceLevelObjectiveRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.DeleteServiceRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.GetServiceLevelObjectiveRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.GetServiceRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListServiceLevelObjectivesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListServiceLevelObjectivesResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListServicesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListServicesResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Service;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ServiceLevelObjective;
import com.google.bigtable.repackaged.com.google.monitoring.v3.UpdateServiceLevelObjectiveRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.UpdateServiceRequest;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class ServiceMonitoringServiceStubSettings
extends StubSettings<ServiceMonitoringServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/monitoring")).add("https://www.googleapis.com/auth/monitoring.read")).build();
    private final UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings;
    private final UnaryCallSettings<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings;
    private final UnaryCallSettings<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings;
    private final PagedCallSettings<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings;
    private final UnaryCallSettings<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings;
    private final UnaryCallSettings<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_DESC = new PagedListDescriptor<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListServiceLevelObjectivesRequest injectToken(ListServiceLevelObjectivesRequest payload, String token) {
            return ListServiceLevelObjectivesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListServiceLevelObjectivesRequest injectPageSize(ListServiceLevelObjectivesRequest payload, int pageSize) {
            return ListServiceLevelObjectivesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListServiceLevelObjectivesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListServiceLevelObjectivesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<ServiceLevelObjective> extractResources(ListServiceLevelObjectivesResponse payload) {
            return payload.getServiceLevelObjectivesList() == null ? ImmutableList.of() : payload.getServiceLevelObjectivesList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse>(){

        @Override
        public ApiFuture<ServiceMonitoringServiceClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext<ListServicesRequest, ListServicesResponse, Service> pageContext = PageContext.create(callable, LIST_SERVICES_PAGE_STR_DESC, request, context);
            return ServiceMonitoringServiceClient.ListServicesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse>(){

        @Override
        public ApiFuture<ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse> callable, ListServiceLevelObjectivesRequest request, ApiCallContext context, ApiFuture<ListServiceLevelObjectivesResponse> futureResponse) {
            PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> pageContext = PageContext.create(callable, LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_DESC, request, context);
            return ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings() {
        return this.createServiceSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public UnaryCallSettings<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings() {
        return this.createServiceLevelObjectiveSettings;
    }

    public UnaryCallSettings<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings() {
        return this.getServiceLevelObjectiveSettings;
    }

    public PagedCallSettings<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings() {
        return this.listServiceLevelObjectivesSettings;
    }

    public UnaryCallSettings<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings() {
        return this.updateServiceLevelObjectiveSettings;
    }

    public UnaryCallSettings<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings() {
        return this.deleteServiceLevelObjectiveSettings;
    }

    public ServiceMonitoringServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceMonitoringServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceMonitoringServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceMonitoringServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceMonitoringServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.createServiceLevelObjectiveSettings = settingsBuilder.createServiceLevelObjectiveSettings().build();
        this.getServiceLevelObjectiveSettings = settingsBuilder.getServiceLevelObjectiveSettings().build();
        this.listServiceLevelObjectivesSettings = settingsBuilder.listServiceLevelObjectivesSettings().build();
        this.updateServiceLevelObjectiveSettings = settingsBuilder.updateServiceLevelObjectiveSettings().build();
        this.deleteServiceLevelObjectiveSettings = settingsBuilder.deleteServiceLevelObjectiveSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceMonitoringServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings;
        private final UnaryCallSettings.Builder<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings;
        private final UnaryCallSettings.Builder<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings;
        private final PagedCallSettings.Builder<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings;
        private final UnaryCallSettings.Builder<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings;
        private final UnaryCallSettings.Builder<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder(LIST_SERVICES_PAGE_STR_FACT);
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServiceLevelObjectivesSettings = PagedCallSettings.newBuilder(LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_FACT);
            this.updateServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServiceSettings, this.getServiceSettings, this.listServicesSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createServiceLevelObjectiveSettings, this.getServiceLevelObjectiveSettings, this.listServiceLevelObjectivesSettings, this.updateServiceLevelObjectiveSettings, this.deleteServiceLevelObjectiveSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServiceMonitoringServiceStubSettings settings) {
            super(settings);
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.createServiceLevelObjectiveSettings = settings.createServiceLevelObjectiveSettings.toBuilder();
            this.getServiceLevelObjectiveSettings = settings.getServiceLevelObjectiveSettings.toBuilder();
            this.listServiceLevelObjectivesSettings = settings.listServiceLevelObjectivesSettings.toBuilder();
            this.updateServiceLevelObjectiveSettings = settings.updateServiceLevelObjectiveSettings.toBuilder();
            this.deleteServiceLevelObjectiveSettings = settings.deleteServiceLevelObjectiveSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServiceSettings, this.getServiceSettings, this.listServicesSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createServiceLevelObjectiveSettings, this.getServiceLevelObjectiveSettings, this.listServiceLevelObjectivesSettings, this.updateServiceLevelObjectiveSettings, this.deleteServiceLevelObjectiveSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceMonitoringServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(ServiceMonitoringServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(ServiceMonitoringServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ServiceMonitoringServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ServiceMonitoringServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createServiceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_6_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_6_params"));
            builder.getServiceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            ((PagedCallSettings.Builder)builder.listServicesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            builder.updateServiceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_6_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_6_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            builder.createServiceLevelObjectiveSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_6_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_6_params"));
            builder.getServiceLevelObjectiveSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            ((PagedCallSettings.Builder)builder.listServiceLevelObjectivesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            builder.updateServiceLevelObjectiveSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_6_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_6_params"));
            builder.deleteServiceLevelObjectiveSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_7_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_7_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings() {
            return this.createServiceSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings() {
            return this.createServiceLevelObjectiveSettings;
        }

        public UnaryCallSettings.Builder<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings() {
            return this.getServiceLevelObjectiveSettings;
        }

        public PagedCallSettings.Builder<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings() {
            return this.listServiceLevelObjectivesSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings() {
            return this.updateServiceLevelObjectiveSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings() {
            return this.deleteServiceLevelObjectiveSettings;
        }

        public ServiceMonitoringServiceStubSettings build() throws IOException {
            return new ServiceMonitoringServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_6_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_7_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(30000L)).setTotalTimeout(Duration.ofMillis(30000L)).build();
            definitions.put("no_retry_6_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(30000L)).setInitialRpcTimeout(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(30000L)).setTotalTimeout(Duration.ofMillis(30000L)).build();
            definitions.put("retry_policy_7_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

