/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.services;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.InlineMe;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.services.MetricReport;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6012")
@ThreadSafe
public final class CallMetricRecorder {
    private static final CallMetricRecorder NOOP = new CallMetricRecorder().disable();
    static final Context.Key<CallMetricRecorder> CONTEXT_KEY = Context.key("com.google.bigtable.repackaged.io.grpc.services.CallMetricRecorder");
    private final AtomicReference<ConcurrentHashMap<String, Double>> utilizationMetrics = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, Double>> requestCostMetrics = new AtomicReference();
    private double cpuUtilizationMetric = 0.0;
    private double memoryUtilizationMetric = 0.0;
    private volatile boolean disabled;

    public static CallMetricRecorder getCurrent() {
        CallMetricRecorder recorder = CONTEXT_KEY.get();
        return recorder != null ? recorder : NOOP;
    }

    public CallMetricRecorder recordUtilizationMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.utilizationMetrics.get() == null) {
            this.utilizationMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.utilizationMetrics.get().put(name, value);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.recordRequestCostMetric(name, value)")
    public CallMetricRecorder recordCallMetric(String name, double value) {
        return this.recordRequestCostMetric(name, value);
    }

    public CallMetricRecorder recordRequestCostMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.requestCostMetrics.get() == null) {
            this.requestCostMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.requestCostMetrics.get().put(name, value);
        return this;
    }

    public CallMetricRecorder recordCpuUtilizationMetric(double value) {
        if (this.disabled) {
            return this;
        }
        this.cpuUtilizationMetric = value;
        return this;
    }

    public CallMetricRecorder recordMemoryUtilizationMetric(double value) {
        if (this.disabled) {
            return this;
        }
        this.memoryUtilizationMetric = value;
        return this;
    }

    Map<String, Double> finalizeAndDump() {
        this.disabled = true;
        Map savedMetrics = this.requestCostMetrics.get();
        if (savedMetrics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(savedMetrics);
    }

    MetricReport finalizeAndDump2() {
        Map<String, Double> savedRequestCostMetrics = this.finalizeAndDump();
        Map savedUtilizationMetrics = this.utilizationMetrics.get();
        if (savedUtilizationMetrics == null) {
            savedUtilizationMetrics = Collections.emptyMap();
        }
        return new MetricReport(this.cpuUtilizationMetric, this.memoryUtilizationMetric, Collections.unmodifiableMap(savedRequestCostMetrics), Collections.unmodifiableMap(savedUtilizationMetrics));
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.disabled;
    }

    private CallMetricRecorder disable() {
        this.disabled = true;
        return this;
    }
}

