/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Splitter;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessageV3;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.com.google.protobuf.util.Durations;
import com.google.bigtable.repackaged.com.google.re2j.Pattern;
import com.google.bigtable.repackaged.com.google.re2j.PatternSyntaxException;
import com.google.bigtable.repackaged.io.grpc.ChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.Grpc;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerRegistry;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.ServiceConfigUtil;
import com.google.bigtable.repackaged.io.grpc.internal.TimeProvider;
import com.google.bigtable.repackaged.io.grpc.xds.AbstractXdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.BootstrapperImpl;
import com.google.bigtable.repackaged.io.grpc.xds.ClusterSpecifierPlugin;
import com.google.bigtable.repackaged.io.grpc.xds.ClusterSpecifierPluginRegistry;
import com.google.bigtable.repackaged.io.grpc.xds.ConfigOrError;
import com.google.bigtable.repackaged.io.grpc.xds.Endpoints;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.Filter;
import com.google.bigtable.repackaged.io.grpc.xds.FilterRegistry;
import com.google.bigtable.repackaged.io.grpc.xds.LoadBalancerConfigFactory;
import com.google.bigtable.repackaged.io.grpc.xds.LoadReportClient;
import com.google.bigtable.repackaged.io.grpc.xds.LoadStatsManager2;
import com.google.bigtable.repackaged.io.grpc.xds.RouterFilter;
import com.google.bigtable.repackaged.io.grpc.xds.TlsContextManager;
import com.google.bigtable.repackaged.io.grpc.xds.VirtualHost;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import com.google.bigtable.repackaged.io.grpc.xds.internal.Matchers;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.OutlierDetection;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.FilterConfig;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RetryPolicy;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.Resource;
import com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientXdsClient
extends XdsClient
implements XdsClient.XdsResponseHandler,
XdsClient.ResourceStore {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    @VisibleForTesting
    static final String HASH_POLICY_FILTER_STATE_KEY = "com.google.bigtable.repackaged.io.grpc.channel_id";
    @VisibleForTesting
    static boolean enableFaultInjection = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION"));
    @VisibleForTesting
    static boolean enableRetry = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RETRY")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RETRY"));
    @VisibleForTesting
    static boolean enableRbac = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_RBAC")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_RBAC"));
    @VisibleForTesting
    static boolean enableRouteLookup = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_XDS_RLS_LB")) && Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_XDS_RLS_LB"));
    @VisibleForTesting
    static boolean enableLeastRequest = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) ? Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) : Boolean.parseBoolean(System.getProperty("com.google.bigtable.repackaged.io.grpc.xds.experimentalEnableLeastRequest"));
    @VisibleForTesting
    static boolean enableCustomLbConfig = Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_XDS_CUSTOM_LB_CONFIG")) || Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_XDS_CUSTOM_LB_CONFIG"));
    @VisibleForTesting
    static boolean enableOutlierDetection = Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_ENABLE_OUTLIER_DETECTION")) || Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_OUTLIER_DETECTION"));
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    private static final String TYPE_URL_CLUSTER_CONFIG_V2 = "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig";
    private static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    private static final String TYPE_URL_TYPED_STRUCT_UDPA = "type.googleapis.com/udpa.type.v1.TypedStruct";
    private static final String TYPE_URL_TYPED_STRUCT = "type.googleapis.com/xds.type.v3.TypedStruct";
    private static final String TYPE_URL_FILTER_CONFIG = "type.googleapis.com/envoy.config.route.v3.FilterConfig";
    private static final String TYPE_URL_RESOURCE_V2 = "type.googleapis.com/envoy.api.v2.Resource";
    private static final String TYPE_URL_RESOURCE_V3 = "type.googleapis.com/envoy.service.discovery.v3.Resource";
    private static final Set<Status.Code> SUPPORTED_RETRYABLE_CODES = Collections.unmodifiableSet(EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE));
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private final LoadBalancerRegistry loadBalancerRegistry = LoadBalancerRegistry.getDefaultRegistry();
    private final Map<Bootstrapper.ServerInfo, AbstractXdsClient> serverChannelMap = new HashMap<Bootstrapper.ServerInfo, AbstractXdsClient>();
    private final Map<String, ResourceSubscriber> ldsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> rdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> cdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> edsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final LoadStatsManager2 loadStatsManager;
    private final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final XdsChannelFactory xdsChannelFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private boolean reportingLoad;
    private final TlsContextManager tlsContextManager;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;

    ClientXdsClient(XdsChannelFactory xdsChannelFactory, Bootstrapper.BootstrapInfo bootstrapInfo, Context context, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, TlsContextManager tlsContextManager) {
        this.xdsChannelFactory = xdsChannelFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.context = context;
        this.timeService = timeService;
        this.loadStatsManager = new LoadStatsManager2(stopwatchSupplier);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.tlsContextManager = Preconditions.checkNotNull(tlsContextManager, "tlsContextManager");
        this.logId = InternalLogId.allocate("xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    private void maybeCreateXdsChannelWithLrs(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverChannelMap.containsKey(serverInfo)) {
            return;
        }
        AbstractXdsClient xdsChannel = new AbstractXdsClient(this.xdsChannelFactory, serverInfo, this.bootstrapInfo.node(), this, this, this.context, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier);
        LoadReportClient lrsClient = new LoadReportClient(this.loadStatsManager, xdsChannel.channel(), this.context, serverInfo.useProtocolV3(), this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverChannelMap.put(serverInfo, xdsChannel);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
    }

    private Any maybeUnwrapResources(Any resource) throws InvalidProtocolBufferException {
        if (resource.getTypeUrl().equals(TYPE_URL_RESOURCE_V2) || resource.getTypeUrl().equals(TYPE_URL_RESOURCE_V3)) {
            return ClientXdsClient.unpackCompatibleType(resource, Resource.class, TYPE_URL_RESOURCE_V3, TYPE_URL_RESOURCE_V2).getResource();
        }
        return resource;
    }

    @Override
    public void handleLdsResponse(Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> retainedRdsResources = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.LdsUpdate ldsUpdate;
            Listener listener;
            boolean isResourceV3;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                isResourceV3 = resource.getTypeUrl().equals(AbstractXdsClient.ResourceType.LDS.typeUrl());
                listener = ClientXdsClient.unpackCompatibleType(resource, Listener.class, AbstractXdsClient.ResourceType.LDS.typeUrl(), AbstractXdsClient.ResourceType.LDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("LDS response Resource index " + i + " - can't decode Listener: " + e);
                continue;
            }
            if (!ClientXdsClient.isResourceNameValid(listener.getName(), resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + listener.getName() + " for type: " + (Object)((Object)AbstractXdsClient.ResourceType.LDS));
                continue;
            }
            String listenerName = ClientXdsClient.canonifyResourceName(listener.getName());
            unpackedResources.add(listenerName);
            try {
                ldsUpdate = listener.hasApiListener() ? this.processClientSideListener(listener, retainedRdsResources, enableFaultInjection && isResourceV3) : this.processServerSideListener(listener, retainedRdsResources, enableRbac && isResourceV3);
            }
            catch (ResourceInvalidException e) {
                errors.add("LDS response Listener '" + listenerName + "' validation error: " + e.getMessage());
                invalidResources.add(listenerName);
                continue;
            }
            parsedResources.put(listenerName, new ParsedResource(ldsUpdate, resource));
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received LDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        this.handleResourceUpdate(serverInfo, AbstractXdsClient.ResourceType.LDS, parsedResources, invalidResources, retainedRdsResources, versionInfo, nonce, errors);
    }

    private XdsClient.LdsUpdate processClientSideListener(Listener listener, Set<String> rdsResources, boolean parseHttpFilter) throws ResourceInvalidException {
        HttpConnectionManager hcm;
        try {
            hcm = ClientXdsClient.unpackCompatibleType(listener.getApiListener().getApiListener(), HttpConnectionManager.class, TYPE_URL_HTTP_CONNECTION_MANAGER, TYPE_URL_HTTP_CONNECTION_MANAGER_V2);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ResourceInvalidException("Could not parse HttpConnectionManager config from ApiListener", e);
        }
        return XdsClient.LdsUpdate.forApiListener(ClientXdsClient.parseHttpConnectionManager(hcm, rdsResources, this.filterRegistry, parseHttpFilter, true));
    }

    private XdsClient.LdsUpdate processServerSideListener(Listener proto, Set<String> rdsResources, boolean parseHttpFilter) throws ResourceInvalidException {
        Set certProviderInstances = null;
        if (this.getBootstrapInfo() != null && this.getBootstrapInfo().certProviders() != null) {
            certProviderInstances = this.getBootstrapInfo().certProviders().keySet();
        }
        return XdsClient.LdsUpdate.forTcpListener(ClientXdsClient.parseServerSideListener(proto, rdsResources, this.tlsContextManager, this.filterRegistry, certProviderInstances, parseHttpFilter));
    }

    @VisibleForTesting
    static EnvoyServerProtoData.Listener parseServerSideListener(Listener proto, Set<String> rdsResources, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, Set<String> certProviderInstances, boolean parseHttpFilter) throws ResourceInvalidException {
        if (!proto.getTrafficDirection().equals(TrafficDirection.INBOUND) && !proto.getTrafficDirection().equals(TrafficDirection.UNSPECIFIED)) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " with invalid traffic direction: " + proto.getTrafficDirection());
        }
        if (!proto.getListenerFiltersList().isEmpty()) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " cannot have listener_filters");
        }
        if (proto.hasUseOriginalDst()) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " cannot have use_original_dst set to true");
        }
        String address = null;
        if (proto.getAddress().hasSocketAddress()) {
            SocketAddress socketAddress = proto.getAddress().getSocketAddress();
            address = socketAddress.getAddress();
            switch (socketAddress.getPortSpecifierCase()) {
                case NAMED_PORT: {
                    address = address + ":" + socketAddress.getNamedPort();
                    break;
                }
                case PORT_VALUE: {
                    address = address + ":" + socketAddress.getPortValue();
                    break;
                }
            }
        }
        ImmutableList.Builder filterChains = ImmutableList.builder();
        HashSet<EnvoyServerProtoData.FilterChainMatch> uniqueSet = new HashSet<EnvoyServerProtoData.FilterChainMatch>();
        for (FilterChain fc : proto.getFilterChainsList()) {
            filterChains.add(ClientXdsClient.parseFilterChain(fc, rdsResources, tlsContextManager, filterRegistry, uniqueSet, certProviderInstances, parseHttpFilter));
        }
        EnvoyServerProtoData.FilterChain defaultFilterChain = null;
        if (proto.hasDefaultFilterChain()) {
            defaultFilterChain = ClientXdsClient.parseFilterChain(proto.getDefaultFilterChain(), rdsResources, tlsContextManager, filterRegistry, null, certProviderInstances, parseHttpFilter);
        }
        return EnvoyServerProtoData.Listener.create(proto.getName(), address, (ImmutableList<EnvoyServerProtoData.FilterChain>)filterChains.build(), defaultFilterChain);
    }

    @VisibleForTesting
    static EnvoyServerProtoData.FilterChain parseFilterChain(FilterChain proto, Set<String> rdsResources, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, Set<String> certProviderInstances, boolean parseHttpFilters) throws ResourceInvalidException {
        HttpConnectionManager hcmProto;
        if (proto.getFiltersCount() != 1) {
            throw new ResourceInvalidException("FilterChain " + proto.getName() + " should contain exact one HttpConnectionManager filter");
        }
        com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Filter filter = proto.getFiltersList().get(0);
        if (!filter.hasTypedConfig()) {
            throw new ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " without typed_config");
        }
        Any any = filter.getTypedConfig();
        if (!any.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER)) {
            throw new ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " with unsupported typed_config type " + any.getTypeUrl());
        }
        try {
            hcmProto = any.unpack(HttpConnectionManager.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ResourceInvalidException("FilterChain " + proto.getName() + " with filter " + filter.getName() + " failed to unpack message", e);
        }
        com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager httpConnectionManager = ClientXdsClient.parseHttpConnectionManager(hcmProto, rdsResources, filterRegistry, parseHttpFilters, false);
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = null;
        if (proto.hasTransportSocket()) {
            DownstreamTlsContext downstreamTlsContextProto;
            if (!TRANSPORT_SOCKET_NAME_TLS.equals(proto.getTransportSocket().getName())) {
                throw new ResourceInvalidException("transport-socket with name " + proto.getTransportSocket().getName() + " not supported.");
            }
            try {
                downstreamTlsContextProto = proto.getTransportSocket().getTypedConfig().unpack(DownstreamTlsContext.class);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " failed to unpack message", e);
            }
            downstreamTlsContext = EnvoyServerProtoData.DownstreamTlsContext.fromEnvoyProtoDownstreamTlsContext(ClientXdsClient.validateDownstreamTlsContext(downstreamTlsContextProto, certProviderInstances));
        }
        EnvoyServerProtoData.FilterChainMatch filterChainMatch = ClientXdsClient.parseFilterChainMatch(proto.getFilterChainMatch());
        ClientXdsClient.checkForUniqueness(uniqueSet, filterChainMatch);
        return EnvoyServerProtoData.FilterChain.create(proto.getName(), filterChainMatch, httpConnectionManager, downstreamTlsContext, tlsContextManager);
    }

    @VisibleForTesting
    static DownstreamTlsContext validateDownstreamTlsContext(DownstreamTlsContext downstreamTlsContext, Set<String> certProviderInstances) throws ResourceInvalidException {
        if (!downstreamTlsContext.hasCommonTlsContext()) {
            throw new ResourceInvalidException("common-tls-context is required in downstream-tls-context");
        }
        ClientXdsClient.validateCommonTlsContext(downstreamTlsContext.getCommonTlsContext(), certProviderInstances, true);
        if (downstreamTlsContext.hasRequireSni()) {
            throw new ResourceInvalidException("downstream-tls-context with require-sni is not supported");
        }
        DownstreamTlsContext.OcspStaplePolicy ocspStaplePolicy = downstreamTlsContext.getOcspStaplePolicy();
        if (ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.UNRECOGNIZED && ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.LENIENT_STAPLING) {
            throw new ResourceInvalidException("downstream-tls-context with ocsp_staple_policy value " + ocspStaplePolicy.name() + " is not supported");
        }
        return downstreamTlsContext;
    }

    @VisibleForTesting
    static UpstreamTlsContext validateUpstreamTlsContext(UpstreamTlsContext upstreamTlsContext, Set<String> certProviderInstances) throws ResourceInvalidException {
        if (!upstreamTlsContext.hasCommonTlsContext()) {
            throw new ResourceInvalidException("common-tls-context is required in upstream-tls-context");
        }
        ClientXdsClient.validateCommonTlsContext(upstreamTlsContext.getCommonTlsContext(), certProviderInstances, false);
        return upstreamTlsContext;
    }

    @VisibleForTesting
    static void validateCommonTlsContext(CommonTlsContext commonTlsContext, Set<String> certProviderInstances, boolean server) throws ResourceInvalidException {
        String rootCaInstanceName;
        if (commonTlsContext.hasCustomHandshaker()) {
            throw new ResourceInvalidException("common-tls-context with custom_handshaker is not supported");
        }
        if (commonTlsContext.hasTlsParams()) {
            throw new ResourceInvalidException("common-tls-context with tls_params is not supported");
        }
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_sds_secret_config is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProvider()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_certificate_provider is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProviderInstance()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_certificate_provider_instance is not supported");
        }
        String certInstanceName = ClientXdsClient.getIdentityCertInstanceName(commonTlsContext);
        if (certInstanceName == null) {
            if (server) {
                throw new ResourceInvalidException("tls_certificate_provider_instance is required in downstream-tls-context");
            }
            if (commonTlsContext.getTlsCertificatesCount() > 0) {
                throw new ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
            if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
                throw new ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
            if (commonTlsContext.hasTlsCertificateCertificateProvider()) {
                throw new ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
        } else if (certProviderInstances == null || !certProviderInstances.contains(certInstanceName)) {
            throw new ResourceInvalidException("CertificateProvider instance name '" + certInstanceName + "' not defined in the bootstrap file.");
        }
        if ((rootCaInstanceName = ClientXdsClient.getRootCertInstanceName(commonTlsContext)) == null) {
            if (!server) {
                throw new ResourceInvalidException("ca_certificate_provider_instance is required in upstream-tls-context");
            }
        } else {
            if (certProviderInstances == null || !certProviderInstances.contains(rootCaInstanceName)) {
                throw new ResourceInvalidException("ca_certificate_provider_instance name '" + rootCaInstanceName + "' not defined in the bootstrap file.");
            }
            CertificateValidationContext certificateValidationContext = null;
            if (commonTlsContext.hasValidationContext()) {
                certificateValidationContext = commonTlsContext.getValidationContext();
            } else if (commonTlsContext.hasCombinedValidationContext() && commonTlsContext.getCombinedValidationContext().hasDefaultValidationContext()) {
                certificateValidationContext = commonTlsContext.getCombinedValidationContext().getDefaultValidationContext();
            }
            if (certificateValidationContext != null) {
                if (certificateValidationContext.getMatchSubjectAltNamesCount() > 0 && server) {
                    throw new ResourceInvalidException("match_subject_alt_names only allowed in upstream_tls_context");
                }
                if (certificateValidationContext.getVerifyCertificateSpkiCount() > 0) {
                    throw new ResourceInvalidException("verify_certificate_spki in default_validation_context is not supported");
                }
                if (certificateValidationContext.getVerifyCertificateHashCount() > 0) {
                    throw new ResourceInvalidException("verify_certificate_hash in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasRequireSignedCertificateTimestamp()) {
                    throw new ResourceInvalidException("require_signed_certificate_timestamp in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCrl()) {
                    throw new ResourceInvalidException("crl in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCustomValidatorConfig()) {
                    throw new ResourceInvalidException("custom_validator_config in default_validation_context is not supported");
                }
            }
        }
    }

    static OutlierDetection validateOutlierDetection(OutlierDetection outlierDetection) throws ResourceInvalidException {
        if (outlierDetection.hasInterval()) {
            if (!Durations.isValid(outlierDetection.getInterval())) {
                throw new ResourceInvalidException("outlier_detection interval is not a valid Duration");
            }
            if (ClientXdsClient.hasNegativeValues(outlierDetection.getInterval())) {
                throw new ResourceInvalidException("outlier_detection interval has a negative value");
            }
        }
        if (outlierDetection.hasBaseEjectionTime()) {
            if (!Durations.isValid(outlierDetection.getBaseEjectionTime())) {
                throw new ResourceInvalidException("outlier_detection base_ejection_time is not a valid Duration");
            }
            if (ClientXdsClient.hasNegativeValues(outlierDetection.getBaseEjectionTime())) {
                throw new ResourceInvalidException("outlier_detection base_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionTime()) {
            if (!Durations.isValid(outlierDetection.getMaxEjectionTime())) {
                throw new ResourceInvalidException("outlier_detection max_ejection_time is not a valid Duration");
            }
            if (ClientXdsClient.hasNegativeValues(outlierDetection.getMaxEjectionTime())) {
                throw new ResourceInvalidException("outlier_detection max_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionPercent() && outlierDetection.getMaxEjectionPercent().getValue() > 100) {
            throw new ResourceInvalidException("outlier_detection max_ejection_percent is > 100");
        }
        if (outlierDetection.hasEnforcingSuccessRate() && outlierDetection.getEnforcingSuccessRate().getValue() > 100) {
            throw new ResourceInvalidException("outlier_detection enforcing_success_rate is > 100");
        }
        if (outlierDetection.hasFailurePercentageThreshold() && outlierDetection.getFailurePercentageThreshold().getValue() > 100) {
            throw new ResourceInvalidException("outlier_detection failure_percentage_threshold is > 100");
        }
        if (outlierDetection.hasEnforcingFailurePercentage() && outlierDetection.getEnforcingFailurePercentage().getValue() > 100) {
            throw new ResourceInvalidException("outlier_detection enforcing_failure_percentage is > 100");
        }
        return outlierDetection;
    }

    static boolean hasNegativeValues(Duration duration) {
        return duration.getSeconds() < 0L || duration.getNanos() < 0;
    }

    private static String getIdentityCertInstanceName(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasTlsCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateProviderInstance().getInstanceName();
        }
        if (commonTlsContext.hasTlsCertificateCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateCertificateProviderInstance().getInstanceName();
        }
        return null;
    }

    private static String getRootCertInstanceName(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasValidationContext()) {
            if (commonTlsContext.getValidationContext().hasCaCertificateProviderInstance()) {
                return commonTlsContext.getValidationContext().getCaCertificateProviderInstance().getInstanceName();
            }
        } else if (commonTlsContext.hasCombinedValidationContext()) {
            CommonTlsContext.CombinedCertificateValidationContext combinedCertificateValidationContext = commonTlsContext.getCombinedValidationContext();
            if (combinedCertificateValidationContext.hasDefaultValidationContext() && combinedCertificateValidationContext.getDefaultValidationContext().hasCaCertificateProviderInstance()) {
                return combinedCertificateValidationContext.getDefaultValidationContext().getCaCertificateProviderInstance().getInstanceName();
            }
            if (combinedCertificateValidationContext.hasValidationContextCertificateProviderInstance()) {
                return combinedCertificateValidationContext.getValidationContextCertificateProviderInstance().getInstanceName();
            }
        }
        return null;
    }

    private static void checkForUniqueness(Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, EnvoyServerProtoData.FilterChainMatch filterChainMatch) throws ResourceInvalidException {
        if (uniqueSet != null) {
            List<EnvoyServerProtoData.FilterChainMatch> crossProduct = ClientXdsClient.getCrossProduct(filterChainMatch);
            for (EnvoyServerProtoData.FilterChainMatch cur : crossProduct) {
                if (uniqueSet.add(cur)) continue;
                throw new ResourceInvalidException("FilterChainMatch must be unique. Found duplicate: " + cur);
            }
        }
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> getCrossProduct(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        List<EnvoyServerProtoData.FilterChainMatch> expandedList = ClientXdsClient.expandOnPrefixRange(filterChainMatch);
        expandedList = ClientXdsClient.expandOnApplicationProtocols(expandedList);
        expandedList = ClientXdsClient.expandOnSourcePrefixRange(expandedList);
        expandedList = ClientXdsClient.expandOnSourcePorts(expandedList);
        return ClientXdsClient.expandOnServerNames(expandedList);
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnPrefixRange(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        if (filterChainMatch.prefixRanges().isEmpty()) {
            expandedList.add(filterChainMatch);
        } else {
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.prefixRanges()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), ImmutableList.of(cidrRange), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnApplicationProtocols(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.applicationProtocols().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String applicationProtocol : filterChainMatch.applicationProtocols()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), ImmutableList.of(applicationProtocol), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePrefixRange(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.sourcePrefixRanges().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.sourcePrefixRanges()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), ImmutableList.of(cidrRange), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePorts(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.sourcePorts().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (Integer sourcePort : filterChainMatch.sourcePorts()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), ImmutableList.of(sourcePort), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnServerNames(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.serverNames().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String serverName : filterChainMatch.serverNames()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), ImmutableList.of(serverName), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static EnvoyServerProtoData.FilterChainMatch parseFilterChainMatch(FilterChainMatch proto) throws ResourceInvalidException {
        EnvoyServerProtoData.ConnectionSourceType sourceType;
        ImmutableList.Builder prefixRanges = ImmutableList.builder();
        ImmutableList.Builder sourcePrefixRanges = ImmutableList.builder();
        try {
            for (CidrRange range : proto.getPrefixRangesList()) {
                prefixRanges.add(EnvoyServerProtoData.CidrRange.create(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
            for (CidrRange range : proto.getSourcePrefixRangesList()) {
                sourcePrefixRanges.add(EnvoyServerProtoData.CidrRange.create(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
        }
        catch (UnknownHostException e) {
            throw new ResourceInvalidException("Failed to create CidrRange", e);
        }
        switch (proto.getSourceType()) {
            case ANY: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.ANY;
                break;
            }
            case EXTERNAL: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.EXTERNAL;
                break;
            }
            case SAME_IP_OR_LOOPBACK: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK;
                break;
            }
            default: {
                throw new ResourceInvalidException("Unknown source-type: " + proto.getSourceType());
            }
        }
        return EnvoyServerProtoData.FilterChainMatch.create(proto.getDestinationPort().getValue(), (ImmutableList<EnvoyServerProtoData.CidrRange>)prefixRanges.build(), ImmutableList.copyOf(proto.getApplicationProtocolsList()), (ImmutableList<EnvoyServerProtoData.CidrRange>)sourcePrefixRanges.build(), sourceType, ImmutableList.copyOf(proto.getSourcePortsList()), ImmutableList.copyOf(proto.getServerNamesList()), proto.getTransportProtocol());
    }

    @VisibleForTesting
    static com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager parseHttpConnectionManager(HttpConnectionManager proto, Set<String> rdsResources, FilterRegistry filterRegistry, boolean parseHttpFilter, boolean isForClient) throws ResourceInvalidException {
        HttpProtocolOptions options;
        if (enableRbac && proto.getXffNumTrustedHops() != 0) {
            throw new ResourceInvalidException("HttpConnectionManager with xff_num_trusted_hops unsupported");
        }
        if (enableRbac && !proto.getOriginalIpDetectionExtensionsList().isEmpty()) {
            throw new ResourceInvalidException("HttpConnectionManager with original_ip_detection_extensions unsupported");
        }
        long maxStreamDuration = 0L;
        if (proto.hasCommonHttpProtocolOptions() && (options = proto.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
            maxStreamDuration = Durations.toNanos(options.getMaxStreamDuration());
        }
        ArrayList<Filter.NamedFilterConfig> filterConfigs = null;
        if (parseHttpFilter) {
            if (proto.getHttpFiltersList().isEmpty()) {
                throw new ResourceInvalidException("Missing HttpFilter in HttpConnectionManager.");
            }
            filterConfigs = new ArrayList<Filter.NamedFilterConfig>();
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < proto.getHttpFiltersCount(); ++i) {
                HttpFilter httpFilter = proto.getHttpFiltersList().get(i);
                String filterName = httpFilter.getName();
                if (!names.add(filterName)) {
                    throw new ResourceInvalidException("HttpConnectionManager contains duplicate HttpFilter: " + filterName);
                }
                StructOrError<Filter.FilterConfig> filterConfig = ClientXdsClient.parseHttpFilter(httpFilter, filterRegistry, isForClient);
                if (!(i != proto.getHttpFiltersCount() - 1 || filterConfig != null && ClientXdsClient.isTerminalFilter((Filter.FilterConfig)((StructOrError)filterConfig).struct))) {
                    throw new ResourceInvalidException("The last HttpFilter must be a terminal filter: " + filterName);
                }
                if (filterConfig == null) continue;
                if (filterConfig.getErrorDetail() != null) {
                    throw new ResourceInvalidException("HttpConnectionManager contains invalid HttpFilter: " + filterConfig.getErrorDetail());
                }
                if (i < proto.getHttpFiltersCount() - 1 && ClientXdsClient.isTerminalFilter(filterConfig.getStruct())) {
                    throw new ResourceInvalidException("A terminal HttpFilter must be the last filter: " + filterName);
                }
                filterConfigs.add(new Filter.NamedFilterConfig(filterName, (Filter.FilterConfig)((StructOrError)filterConfig).struct));
            }
        }
        if (proto.hasRouteConfig()) {
            List<VirtualHost> virtualHosts = ClientXdsClient.extractVirtualHosts(proto.getRouteConfig(), filterRegistry, parseHttpFilter);
            return com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager.forVirtualHosts(maxStreamDuration, virtualHosts, filterConfigs);
        }
        if (proto.hasRds()) {
            Rds rds = proto.getRds();
            if (!rds.hasConfigSource()) {
                throw new ResourceInvalidException("HttpConnectionManager contains invalid RDS: missing config_source");
            }
            if (!rds.getConfigSource().hasAds() && !rds.getConfigSource().hasSelf()) {
                throw new ResourceInvalidException("HttpConnectionManager contains invalid RDS: must specify ADS or self ConfigSource");
            }
            rdsResources.add(rds.getRouteConfigName());
            return com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager.forRdsName(maxStreamDuration, rds.getRouteConfigName(), filterConfigs);
        }
        throw new ResourceInvalidException("HttpConnectionManager neither has inlined route_config nor RDS");
    }

    private static boolean isTerminalFilter(Filter.FilterConfig filterConfig) {
        return RouterFilter.ROUTER_CONFIG.equals(filterConfig);
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Filter.FilterConfig> parseHttpFilter(HttpFilter httpFilter, FilterRegistry filterRegistry, boolean isForClient) {
        String filterName = httpFilter.getName();
        boolean isOptional = httpFilter.getIsOptional();
        if (!httpFilter.hasTypedConfig()) {
            if (isOptional) {
                return null;
            }
            return StructOrError.fromError("HttpFilter [" + filterName + "] is not optional and has no typed config");
        }
        GeneratedMessageV3 rawConfig = httpFilter.getTypedConfig();
        String typeUrl = httpFilter.getTypedConfig().getTypeUrl();
        try {
            if (typeUrl.equals(TYPE_URL_TYPED_STRUCT_UDPA)) {
                com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct typedStruct = httpFilter.getTypedConfig().unpack(com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class);
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            } else if (typeUrl.equals(TYPE_URL_TYPED_STRUCT)) {
                TypedStruct newTypedStruct = httpFilter.getTypedConfig().unpack(TypedStruct.class);
                typeUrl = newTypedStruct.getTypeUrl();
                rawConfig = newTypedStruct.getValue();
            }
        }
        catch (InvalidProtocolBufferException e) {
            return StructOrError.fromError("HttpFilter [" + filterName + "] contains invalid proto: " + e);
        }
        Filter filter = filterRegistry.get(typeUrl);
        if (isForClient && !(filter instanceof Filter.ClientInterceptorBuilder) || !isForClient && !(filter instanceof Filter.ServerInterceptorBuilder)) {
            if (isOptional) {
                return null;
            }
            return StructOrError.fromError("HttpFilter [" + filterName + "](" + typeUrl + ") is required but unsupported for " + (isForClient ? "client" : "server"));
        }
        ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfig(rawConfig);
        if (filterConfig.errorDetail != null) {
            return StructOrError.fromError("Invalid filter config for HttpFilter [" + filterName + "]: " + filterConfig.errorDetail);
        }
        return StructOrError.fromStruct((Filter.FilterConfig)filterConfig.config);
    }

    private static StructOrError<VirtualHost> parseVirtualHost(com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        String name = proto.getName();
        ArrayList<VirtualHost.Route> routes = new ArrayList<VirtualHost.Route>(proto.getRoutesCount());
        for (Route routeProto : proto.getRoutesList()) {
            StructOrError<VirtualHost.Route> route = ClientXdsClient.parseRoute(routeProto, filterRegistry, parseHttpFilter, pluginConfigMap, optionalPlugins);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                return StructOrError.fromError("Virtual host [" + name + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        if (!parseHttpFilter) {
            return StructOrError.fromStruct(VirtualHost.create(name, proto.getDomainsList(), routes, new HashMap<String, Filter.FilterConfig>()));
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (((StructOrError)overrideConfigs).errorDetail != null) {
            return StructOrError.fromError("VirtualHost [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigs).errorDetail);
        }
        return StructOrError.fromStruct(VirtualHost.create(name, proto.getDomainsList(), routes, (Map)((StructOrError)overrideConfigs).struct));
    }

    @VisibleForTesting
    static StructOrError<Map<String, Filter.FilterConfig>> parseOverrideFilterConfigs(Map<String, Any> rawFilterConfigMap, FilterRegistry filterRegistry) {
        HashMap<String, Filter.FilterConfig> overrideConfigs = new HashMap<String, Filter.FilterConfig>();
        for (String name : rawFilterConfigMap.keySet()) {
            Any anyConfig = rawFilterConfigMap.get(name);
            String typeUrl = anyConfig.getTypeUrl();
            boolean isOptional = false;
            if (typeUrl.equals(TYPE_URL_FILTER_CONFIG)) {
                FilterConfig filterConfig;
                try {
                    filterConfig = anyConfig.unpack(FilterConfig.class);
                }
                catch (InvalidProtocolBufferException e) {
                    return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
                }
                isOptional = filterConfig.getIsOptional();
                anyConfig = filterConfig.getConfig();
                typeUrl = anyConfig.getTypeUrl();
            }
            GeneratedMessageV3 rawConfig = anyConfig;
            try {
                if (typeUrl.equals(TYPE_URL_TYPED_STRUCT_UDPA)) {
                    com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct typedStruct = anyConfig.unpack(com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class);
                    typeUrl = typedStruct.getTypeUrl();
                    rawConfig = typedStruct.getValue();
                } else if (typeUrl.equals(TYPE_URL_TYPED_STRUCT)) {
                    TypedStruct newTypedStruct = anyConfig.unpack(TypedStruct.class);
                    typeUrl = newTypedStruct.getTypeUrl();
                    rawConfig = newTypedStruct.getValue();
                }
            }
            catch (InvalidProtocolBufferException e) {
                return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
            }
            Filter filter = filterRegistry.get(typeUrl);
            if (filter == null) {
                if (isOptional) continue;
                return StructOrError.fromError("HttpFilter [" + name + "](" + typeUrl + ") is required but unsupported");
            }
            ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfigOverride(rawConfig);
            if (filterConfig.errorDetail != null) {
                return StructOrError.fromError("Invalid filter config for HttpFilter [" + name + "]: " + filterConfig.errorDetail);
            }
            overrideConfigs.put(name, (Filter.FilterConfig)filterConfig.config);
        }
        return StructOrError.fromStruct(overrideConfigs);
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route> parseRoute(Route proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        StructOrError<VirtualHost.Route.RouteMatch> routeMatch = ClientXdsClient.parseRouteMatch(proto.getMatch());
        if (routeMatch == null) {
            return null;
        }
        if (routeMatch.getErrorDetail() != null) {
            return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteMatch: " + routeMatch.getErrorDetail());
        }
        Map overrideConfigs = Collections.emptyMap();
        if (parseHttpFilter) {
            StructOrError<Map<String, Filter.FilterConfig>> overrideConfigsOrError = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
            if (((StructOrError)overrideConfigsOrError).errorDetail != null) {
                return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigsOrError).errorDetail);
            }
            overrideConfigs = (Map)((StructOrError)overrideConfigsOrError).struct;
        }
        switch (proto.getActionCase()) {
            case ROUTE: {
                StructOrError<VirtualHost.Route.RouteAction> routeAction = ClientXdsClient.parseRouteAction(proto.getRoute(), filterRegistry, parseHttpFilter, pluginConfigMap, optionalPlugins);
                if (routeAction == null) {
                    return null;
                }
                if (((StructOrError)routeAction).errorDetail != null) {
                    return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteAction: " + routeAction.getErrorDetail());
                }
                return StructOrError.fromStruct(VirtualHost.Route.forAction((VirtualHost.Route.RouteMatch)((StructOrError)routeMatch).struct, (VirtualHost.Route.RouteAction)((StructOrError)routeAction).struct, overrideConfigs));
            }
            case NON_FORWARDING_ACTION: {
                return StructOrError.fromStruct(VirtualHost.Route.forNonForwardingAction((VirtualHost.Route.RouteMatch)((StructOrError)routeMatch).struct, overrideConfigs));
            }
        }
        return StructOrError.fromError("Route [" + proto.getName() + "] with unknown action type: " + proto.getActionCase());
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch> parseRouteMatch(RouteMatch proto) {
        if (proto.getQueryParametersCount() != 0) {
            return null;
        }
        StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> pathMatch = ClientXdsClient.parsePathMatcher(proto);
        if (pathMatch.getErrorDetail() != null) {
            return StructOrError.fromError(pathMatch.getErrorDetail());
        }
        Matchers.FractionMatcher fractionMatch = null;
        if (proto.hasRuntimeFraction()) {
            StructOrError<Matchers.FractionMatcher> parsedFraction = ClientXdsClient.parseFractionMatcher(proto.getRuntimeFraction().getDefaultValue());
            if (parsedFraction.getErrorDetail() != null) {
                return StructOrError.fromError(parsedFraction.getErrorDetail());
            }
            fractionMatch = parsedFraction.getStruct();
        }
        ArrayList<Matchers.HeaderMatcher> headerMatchers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher hmProto : proto.getHeadersList()) {
            StructOrError<Matchers.HeaderMatcher> headerMatcher = ClientXdsClient.parseHeaderMatcher(hmProto);
            if (headerMatcher.getErrorDetail() != null) {
                return StructOrError.fromError(headerMatcher.getErrorDetail());
            }
            headerMatchers.add(headerMatcher.getStruct());
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.create(pathMatch.getStruct(), headerMatchers, fractionMatch));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> parsePathMatcher(RouteMatch proto) {
        boolean caseSensitive = proto.getCaseSensitive().getValue();
        switch (proto.getPathSpecifierCase()) {
            case PREFIX: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPrefix(proto.getPrefix(), caseSensitive));
            }
            case PATH: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPath(proto.getPath(), caseSensitive));
            }
            case SAFE_REGEX: {
                Pattern safeRegEx;
                String rawPattern = proto.getSafeRegex().getRegex();
                try {
                    safeRegEx = Pattern.compile(rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromRegEx(safeRegEx));
            }
        }
        return StructOrError.fromError("Unknown path match type");
    }

    private static StructOrError<Matchers.FractionMatcher> parseFractionMatcher(FractionalPercent proto) {
        int numerator = proto.getNumerator();
        int denominator = 0;
        switch (proto.getDenominator()) {
            case HUNDRED: {
                denominator = 100;
                break;
            }
            case TEN_THOUSAND: {
                denominator = 10000;
                break;
            }
            case MILLION: {
                denominator = 1000000;
                break;
            }
            default: {
                return StructOrError.fromError("Unrecognized fractional percent denominator: " + proto.getDenominator());
            }
        }
        return StructOrError.fromStruct(Matchers.FractionMatcher.create(numerator, denominator));
    }

    @VisibleForTesting
    static StructOrError<Matchers.HeaderMatcher> parseHeaderMatcher(HeaderMatcher proto) {
        switch (proto.getHeaderMatchSpecifierCase()) {
            case EXACT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forExactValue(proto.getName(), proto.getExactMatch(), proto.getInvertMatch()));
            }
            case SAFE_REGEX_MATCH: {
                Pattern safeRegExMatch;
                String rawPattern = proto.getSafeRegexMatch().getRegex();
                try {
                    safeRegExMatch = Pattern.compile(rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSafeRegEx(proto.getName(), safeRegExMatch, proto.getInvertMatch()));
            }
            case RANGE_MATCH: {
                Matchers.HeaderMatcher.Range rangeMatch = Matchers.HeaderMatcher.Range.create(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forRange(proto.getName(), rangeMatch, proto.getInvertMatch()));
            }
            case PRESENT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPresent(proto.getName(), proto.getPresentMatch(), proto.getInvertMatch()));
            }
            case PREFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPrefix(proto.getName(), proto.getPrefixMatch(), proto.getInvertMatch()));
            }
            case SUFFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSuffix(proto.getName(), proto.getSuffixMatch(), proto.getInvertMatch()));
            }
        }
        return StructOrError.fromError("Unknown header matcher type");
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction> parseRouteAction(RouteAction proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> retryPolicyOrError;
        Long timeoutNano = null;
        if (proto.hasMaxStreamDuration()) {
            RouteAction.MaxStreamDuration maxStreamDuration = proto.getMaxStreamDuration();
            if (maxStreamDuration.hasGrpcTimeoutHeaderMax()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getGrpcTimeoutHeaderMax());
            } else if (maxStreamDuration.hasMaxStreamDuration()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getMaxStreamDuration());
            }
        }
        VirtualHost.Route.RouteAction.RetryPolicy retryPolicy = null;
        if (enableRetry && proto.hasRetryPolicy() && (retryPolicyOrError = ClientXdsClient.parseRetryPolicy(proto.getRetryPolicy())) != null) {
            if (((StructOrError)retryPolicyOrError).errorDetail != null) {
                return StructOrError.fromError(((StructOrError)retryPolicyOrError).errorDetail);
            }
            retryPolicy = (VirtualHost.Route.RouteAction.RetryPolicy)((StructOrError)retryPolicyOrError).struct;
        }
        ArrayList<VirtualHost.Route.RouteAction.HashPolicy> hashPolicies = new ArrayList<VirtualHost.Route.RouteAction.HashPolicy>();
        for (RouteAction.HashPolicy config : proto.getHashPolicyList()) {
            Object policy = null;
            boolean terminal = config.getTerminal();
            switch (config.getPolicySpecifierCase()) {
                case HEADER: {
                    RouteAction.HashPolicy.Header headerCfg = config.getHeader();
                    Pattern regEx = null;
                    String regExSubstitute = null;
                    if (headerCfg.hasRegexRewrite() && headerCfg.getRegexRewrite().hasPattern() && headerCfg.getRegexRewrite().getPattern().hasGoogleRe2()) {
                        regEx = Pattern.compile(headerCfg.getRegexRewrite().getPattern().getRegex());
                        regExSubstitute = headerCfg.getRegexRewrite().getSubstitution();
                    }
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forHeader(terminal, headerCfg.getHeaderName(), regEx, regExSubstitute);
                    break;
                }
                case FILTER_STATE: {
                    if (!config.getFilterState().getKey().equals(HASH_POLICY_FILTER_STATE_KEY)) break;
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forChannelId(terminal);
                    break;
                }
            }
            if (policy == null) continue;
            hashPolicies.add((VirtualHost.Route.RouteAction.HashPolicy)policy);
        }
        switch (proto.getClusterSpecifierCase()) {
            case CLUSTER: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forCluster(proto.getCluster(), hashPolicies, timeoutNano, retryPolicy));
            }
            case CLUSTER_HEADER: {
                return null;
            }
            case WEIGHTED_CLUSTERS: {
                List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                if (clusterWeights.isEmpty()) {
                    return StructOrError.fromError("No cluster found in weighted cluster list");
                }
                ArrayList<VirtualHost.Route.RouteAction.ClusterWeight> weightedClusters = new ArrayList<VirtualHost.Route.RouteAction.ClusterWeight>();
                for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                    StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> clusterWeightOrError = ClientXdsClient.parseClusterWeight(clusterWeight, filterRegistry, parseHttpFilter);
                    if (clusterWeightOrError.getErrorDetail() != null) {
                        return StructOrError.fromError("RouteAction contains invalid ClusterWeight: " + clusterWeightOrError.getErrorDetail());
                    }
                    weightedClusters.add(clusterWeightOrError.getStruct());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forWeightedClusters(weightedClusters, hashPolicies, timeoutNano, retryPolicy));
            }
            case CLUSTER_SPECIFIER_PLUGIN: {
                if (enableRouteLookup) {
                    String pluginName = proto.getClusterSpecifierPlugin();
                    ClusterSpecifierPlugin.PluginConfig pluginConfig = pluginConfigMap.get(pluginName);
                    if (pluginConfig == null) {
                        if (optionalPlugins.contains(pluginName)) {
                            return null;
                        }
                        return StructOrError.fromError("ClusterSpecifierPlugin for [" + pluginName + "] not found");
                    }
                    ClusterSpecifierPlugin.NamedPluginConfig namedPluginConfig = ClusterSpecifierPlugin.NamedPluginConfig.create(pluginName, pluginConfig);
                    return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forClusterSpecifierPlugin(namedPluginConfig, hashPolicies, timeoutNano, retryPolicy));
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> parseRetryPolicy(RetryPolicy retryPolicyProto) {
        int maxAttempts = 2;
        if (retryPolicyProto.hasNumRetries()) {
            maxAttempts = retryPolicyProto.getNumRetries().getValue() + 1;
        }
        Duration initialBackoff = Durations.fromMillis(25L);
        Duration maxBackoff = Durations.fromMillis(250L);
        if (retryPolicyProto.hasRetryBackOff()) {
            RetryPolicy.RetryBackOff retryBackOff = retryPolicyProto.getRetryBackOff();
            if (!retryBackOff.hasBaseInterval()) {
                return StructOrError.fromError("No base_interval specified in retry_backoff");
            }
            Duration originalInitialBackoff = initialBackoff = retryBackOff.getBaseInterval();
            if (Durations.compare(initialBackoff, Durations.ZERO) <= 0) {
                return StructOrError.fromError("base_interval in retry_backoff must be positive");
            }
            if (Durations.compare(initialBackoff, Durations.fromMillis(1L)) < 0) {
                initialBackoff = Durations.fromMillis(1L);
            }
            if (retryBackOff.hasMaxInterval()) {
                maxBackoff = retryPolicyProto.getRetryBackOff().getMaxInterval();
                if (Durations.compare(maxBackoff, originalInitialBackoff) < 0) {
                    return StructOrError.fromError("max_interval in retry_backoff cannot be less than base_interval");
                }
                if (Durations.compare(maxBackoff, Durations.fromMillis(1L)) < 0) {
                    maxBackoff = Durations.fromMillis(1L);
                }
            } else {
                maxBackoff = Durations.fromNanos(Durations.toNanos(initialBackoff) * 10L);
            }
        }
        Iterable<String> retryOns = Splitter.on(',').omitEmptyStrings().trimResults().split(retryPolicyProto.getRetryOn());
        ImmutableList.Builder retryableStatusCodesBuilder = ImmutableList.builder();
        for (String retryOn : retryOns) {
            Status.Code code;
            try {
                code = Status.Code.valueOf(retryOn.toUpperCase(Locale.US).replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!SUPPORTED_RETRYABLE_CODES.contains((Object)code)) continue;
            retryableStatusCodesBuilder.add((Object)code);
        }
        ImmutableCollection retryableStatusCodes = retryableStatusCodesBuilder.build();
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.RetryPolicy.create(maxAttempts, (List<Status.Code>)((Object)retryableStatusCodes), initialBackoff, maxBackoff, null));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> parseClusterWeight(WeightedCluster.ClusterWeight proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        if (!parseHttpFilter) {
            return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), new HashMap<String, Filter.FilterConfig>()));
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (((StructOrError)overrideConfigs).errorDetail != null) {
            return StructOrError.fromError("ClusterWeight [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigs).errorDetail);
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), (Map)((StructOrError)overrideConfigs).struct));
    }

    @Override
    public void handleRdsResponse(Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.RdsUpdate rdsUpdate;
            RouteConfiguration routeConfig;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                routeConfig = ClientXdsClient.unpackCompatibleType(resource, RouteConfiguration.class, AbstractXdsClient.ResourceType.RDS.typeUrl(), AbstractXdsClient.ResourceType.RDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("RDS response Resource index " + i + " - can't decode RouteConfiguration: " + e);
                continue;
            }
            if (!ClientXdsClient.isResourceNameValid(routeConfig.getName(), resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + routeConfig.getName() + " for type: " + (Object)((Object)AbstractXdsClient.ResourceType.RDS));
                continue;
            }
            String routeConfigName = ClientXdsClient.canonifyResourceName(routeConfig.getName());
            unpackedResources.add(routeConfigName);
            boolean isResourceV3 = resource.getTypeUrl().equals(AbstractXdsClient.ResourceType.RDS.typeUrl());
            try {
                rdsUpdate = ClientXdsClient.processRouteConfiguration(routeConfig, this.filterRegistry, enableFaultInjection && isResourceV3);
            }
            catch (ResourceInvalidException e) {
                errors.add("RDS response RouteConfiguration '" + routeConfigName + "' validation error: " + e.getMessage());
                invalidResources.add(routeConfigName);
                continue;
            }
            parsedResources.put(routeConfigName, new ParsedResource(rdsUpdate, resource));
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received RDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        this.handleResourceUpdate(serverInfo, AbstractXdsClient.ResourceType.RDS, parsedResources, invalidResources, Collections.emptySet(), versionInfo, nonce, errors);
    }

    private static XdsClient.RdsUpdate processRouteConfiguration(RouteConfiguration routeConfig, FilterRegistry filterRegistry, boolean parseHttpFilter) throws ResourceInvalidException {
        return new XdsClient.RdsUpdate(ClientXdsClient.extractVirtualHosts(routeConfig, filterRegistry, parseHttpFilter));
    }

    private static List<VirtualHost> extractVirtualHosts(RouteConfiguration routeConfig, FilterRegistry filterRegistry, boolean parseHttpFilter) throws ResourceInvalidException {
        HashMap<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap = new HashMap<String, ClusterSpecifierPlugin.PluginConfig>();
        ImmutableSet.Builder optionalPlugins = ImmutableSet.builder();
        if (enableRouteLookup) {
            List<com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin> plugins = routeConfig.getClusterSpecifierPluginsList();
            for (com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin plugin : plugins) {
                String pluginName = plugin.getExtension().getName();
                ClusterSpecifierPlugin.PluginConfig pluginConfig = ClientXdsClient.parseClusterSpecifierPlugin(plugin);
                if (pluginConfig != null) {
                    if (pluginConfigMap.put(pluginName, pluginConfig) == null) continue;
                    throw new ResourceInvalidException("Multiple ClusterSpecifierPlugins with the same name: " + pluginName);
                }
                optionalPlugins.add(pluginName);
            }
        }
        ArrayList<VirtualHost> virtualHosts = new ArrayList<VirtualHost>(routeConfig.getVirtualHostsCount());
        for (com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
            StructOrError<VirtualHost> virtualHost = ClientXdsClient.parseVirtualHost(virtualHostProto, filterRegistry, parseHttpFilter, pluginConfigMap, (Set<String>)((Object)optionalPlugins.build()));
            if (virtualHost.getErrorDetail() != null) {
                throw new ResourceInvalidException("RouteConfiguration contains invalid virtual host: " + virtualHost.getErrorDetail());
            }
            virtualHosts.add(virtualHost.getStruct());
        }
        return virtualHosts;
    }

    @Nullable
    private static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto) throws ResourceInvalidException {
        return ClientXdsClient.parseClusterSpecifierPlugin(pluginProto, ClusterSpecifierPluginRegistry.getDefaultRegistry());
    }

    @Nullable
    @VisibleForTesting
    static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(com.google.bigtable.repackaged.io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto, ClusterSpecifierPluginRegistry registry) throws ResourceInvalidException {
        ClusterSpecifierPlugin plugin;
        TypedExtensionConfig extension = pluginProto.getExtension();
        String pluginName = extension.getName();
        Any anyConfig = extension.getTypedConfig();
        String typeUrl = anyConfig.getTypeUrl();
        GeneratedMessageV3 rawConfig = anyConfig;
        if (typeUrl.equals(TYPE_URL_TYPED_STRUCT_UDPA) || typeUrl.equals(TYPE_URL_TYPED_STRUCT)) {
            try {
                com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct typedStruct = ClientXdsClient.unpackCompatibleType(anyConfig, com.google.bigtable.repackaged.io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class, TYPE_URL_TYPED_STRUCT_UDPA, TYPE_URL_TYPED_STRUCT);
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            }
            catch (InvalidProtocolBufferException e) {
                throw new ResourceInvalidException("ClusterSpecifierPlugin [" + pluginName + "] contains invalid proto", e);
            }
        }
        if ((plugin = registry.get(typeUrl)) == null) {
            if (!pluginProto.getIsOptional()) {
                throw new ResourceInvalidException("Unsupported ClusterSpecifierPlugin type: " + typeUrl);
            }
            return null;
        }
        ConfigOrError<? extends ClusterSpecifierPlugin.PluginConfig> pluginConfigOrError = plugin.parsePlugin(rawConfig);
        if (pluginConfigOrError.errorDetail != null) {
            throw new ResourceInvalidException(pluginConfigOrError.errorDetail);
        }
        return (ClusterSpecifierPlugin.PluginConfig)pluginConfigOrError.config;
    }

    @Override
    public void handleCdsResponse(Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> retainedEdsResources = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.CdsUpdate cdsUpdate;
            Cluster cluster;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                cluster = ClientXdsClient.unpackCompatibleType(resource, Cluster.class, AbstractXdsClient.ResourceType.CDS.typeUrl(), AbstractXdsClient.ResourceType.CDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("CDS response Resource index " + i + " - can't decode Cluster: " + e);
                continue;
            }
            if (!ClientXdsClient.isResourceNameValid(cluster.getName(), resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + cluster.getName() + " for type: " + (Object)((Object)AbstractXdsClient.ResourceType.CDS));
                continue;
            }
            String clusterName = ClientXdsClient.canonifyResourceName(cluster.getName());
            if (!this.cdsResourceSubscribers.containsKey(clusterName)) continue;
            unpackedResources.add(clusterName);
            try {
                Set certProviderInstances = null;
                if (this.getBootstrapInfo() != null && this.getBootstrapInfo().certProviders() != null) {
                    certProviderInstances = this.getBootstrapInfo().certProviders().keySet();
                }
                cdsUpdate = ClientXdsClient.processCluster(cluster, retainedEdsResources, certProviderInstances, serverInfo, this.loadBalancerRegistry);
            }
            catch (ResourceInvalidException e) {
                errors.add("CDS response Cluster '" + clusterName + "' validation error: " + e.getMessage());
                invalidResources.add(clusterName);
                continue;
            }
            parsedResources.put(clusterName, new ParsedResource(cdsUpdate, resource));
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        this.handleResourceUpdate(serverInfo, AbstractXdsClient.ResourceType.CDS, parsedResources, invalidResources, retainedEdsResources, versionInfo, nonce, errors);
    }

    @VisibleForTesting
    static XdsClient.CdsUpdate processCluster(Cluster cluster, Set<String> retainedEdsResources, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo, LoadBalancerRegistry loadBalancerRegistry) throws ResourceInvalidException {
        StructOrError<XdsClient.CdsUpdate.Builder> structOrError;
        switch (cluster.getClusterDiscoveryTypeCase()) {
            case TYPE: {
                structOrError = ClientXdsClient.parseNonAggregateCluster(cluster, retainedEdsResources, certProviderInstances, serverInfo);
                break;
            }
            case CLUSTER_TYPE: {
                structOrError = ClientXdsClient.parseAggregateCluster(cluster);
                break;
            }
            default: {
                throw new ResourceInvalidException("Cluster " + cluster.getName() + ": unspecified cluster discovery type");
            }
        }
        if (structOrError.getErrorDetail() != null) {
            throw new ResourceInvalidException(structOrError.getErrorDetail());
        }
        XdsClient.CdsUpdate.Builder updateBuilder = structOrError.getStruct();
        ImmutableMap<String, ?> lbPolicyConfig = LoadBalancerConfigFactory.newConfig(cluster, enableLeastRequest, enableCustomLbConfig);
        ServiceConfigUtil.LbConfig lbConfig = ServiceConfigUtil.unwrapLoadBalancingConfig(lbPolicyConfig);
        NameResolver.ConfigOrError configOrError = loadBalancerRegistry.getProvider(lbConfig.getPolicyName()).parseLoadBalancingPolicyConfig(lbConfig.getRawConfigValue());
        if (configOrError.getError() != null) {
            throw new ResourceInvalidException(structOrError.getErrorDetail());
        }
        updateBuilder.lbPolicyConfig(lbPolicyConfig);
        return updateBuilder.build();
    }

    private static StructOrError<XdsClient.CdsUpdate.Builder> parseAggregateCluster(Cluster cluster) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals(AGGREGATE_CLUSTER_TYPE_NAME)) {
            return StructOrError.fromError("Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
        }
        try {
            clusterConfig = ClientXdsClient.unpackCompatibleType(customType.getTypedConfig(), ClusterConfig.class, TYPE_URL_CLUSTER_CONFIG, TYPE_URL_CLUSTER_CONFIG_V2);
        }
        catch (InvalidProtocolBufferException e) {
            return StructOrError.fromError("Cluster " + clusterName + ": malformed ClusterConfig: " + e);
        }
        return StructOrError.fromStruct(XdsClient.CdsUpdate.forAggregate(clusterName, clusterConfig.getClustersList()));
    }

    private static StructOrError<XdsClient.CdsUpdate.Builder> parseNonAggregateCluster(Cluster cluster, Set<String> edsResources, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        Bootstrapper.ServerInfo lrsServerInfo = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        EnvoyServerProtoData.OutlierDetection outlierDetection = null;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                return StructOrError.fromError("Cluster " + clusterName + ": only support LRS for the same management server");
            }
            lrsServerInfo = serverInfo;
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = threshold.getMaxRequests().getValue();
            }
        }
        if (cluster.getTransportSocketMatchesCount() > 0) {
            return StructOrError.fromError("Cluster " + clusterName + ": transport-socket-matches not supported.");
        }
        if (cluster.hasTransportSocket()) {
            if (!TRANSPORT_SOCKET_NAME_TLS.equals(cluster.getTransportSocket().getName())) {
                return StructOrError.fromError("transport-socket with name " + cluster.getTransportSocket().getName() + " not supported.");
            }
            try {
                upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(ClientXdsClient.validateUpstreamTlsContext(ClientXdsClient.unpackCompatibleType(cluster.getTransportSocket().getTypedConfig(), UpstreamTlsContext.class, TYPE_URL_UPSTREAM_TLS_CONTEXT, TYPE_URL_UPSTREAM_TLS_CONTEXT_V2), certProviderInstances));
            }
            catch (InvalidProtocolBufferException | ResourceInvalidException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed UpstreamTlsContext: " + e);
            }
        }
        if (cluster.hasOutlierDetection() && enableOutlierDetection) {
            try {
                outlierDetection = EnvoyServerProtoData.OutlierDetection.fromEnvoyOutlierDetection(ClientXdsClient.validateOutlierDetection(cluster.getOutlierDetection()));
            }
            catch (ResourceInvalidException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed outlier_detection: " + e);
            }
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds() && !edsClusterConfig.getEdsConfig().hasSelf()) {
                return StructOrError.fromError("Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS or self ConfigSource");
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
                edsResources.add(edsServiceName);
            } else {
                edsResources.add(clusterName);
            }
            return StructOrError.fromStruct(XdsClient.CdsUpdate.forEds(clusterName, edsServiceName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext, outlierDetection));
        }
        if (type.equals(Cluster.DiscoveryType.LOGICAL_DNS)) {
            if (!cluster.hasLoadAssignment()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single host");
            }
            ClusterLoadAssignment assignment = cluster.getLoadAssignment();
            if (assignment.getEndpointsCount() != 1 || assignment.getEndpoints(0).getLbEndpointsCount() != 1) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single locality_lb_endpoint and a single lb_endpoint");
            }
            LbEndpoint lbEndpoint = assignment.getEndpoints(0).getLbEndpoints(0);
            if (!(lbEndpoint.hasEndpoint() && lbEndpoint.getEndpoint().hasAddress() && lbEndpoint.getEndpoint().getAddress().hasSocketAddress())) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have an endpoint with address and socket_address");
            }
            SocketAddress socketAddress = lbEndpoint.getEndpoint().getAddress().getSocketAddress();
            if (!socketAddress.getResolverName().isEmpty()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters must NOT have a custom resolver name set");
            }
            if (socketAddress.getPortSpecifierCase() != SocketAddress.PortSpecifierCase.PORT_VALUE) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters socket_address must have port_value");
            }
            String dnsHostName = String.format(Locale.US, "%s:%d", socketAddress.getAddress(), socketAddress.getPortValue());
            return StructOrError.fromStruct(XdsClient.CdsUpdate.forLogicalDns(clusterName, dnsHostName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext));
        }
        return StructOrError.fromError("Cluster " + clusterName + ": unsupported built-in discovery type: " + type);
    }

    @Override
    public void handleEdsResponse(Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.EdsUpdate edsUpdate;
            ClusterLoadAssignment assignment;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                assignment = ClientXdsClient.unpackCompatibleType(resource, ClusterLoadAssignment.class, AbstractXdsClient.ResourceType.EDS.typeUrl(), AbstractXdsClient.ResourceType.EDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("EDS response Resource index " + i + " - can't decode ClusterLoadAssignment: " + e);
                continue;
            }
            if (!ClientXdsClient.isResourceNameValid(assignment.getClusterName(), resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + assignment.getClusterName() + " for type: " + (Object)((Object)AbstractXdsClient.ResourceType.EDS));
                continue;
            }
            String clusterName = ClientXdsClient.canonifyResourceName(assignment.getClusterName());
            if (!this.edsResourceSubscribers.containsKey(clusterName)) continue;
            unpackedResources.add(clusterName);
            try {
                edsUpdate = ClientXdsClient.processClusterLoadAssignment(assignment);
            }
            catch (ResourceInvalidException e) {
                errors.add("EDS response ClusterLoadAssignment '" + clusterName + "' validation error: " + e.getMessage());
                invalidResources.add(clusterName);
                continue;
            }
            parsedResources.put(clusterName, new ParsedResource(edsUpdate, resource));
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        this.handleResourceUpdate(serverInfo, AbstractXdsClient.ResourceType.EDS, parsedResources, invalidResources, Collections.emptySet(), versionInfo, nonce, errors);
    }

    private static XdsClient.EdsUpdate processClusterLoadAssignment(ClusterLoadAssignment assignment) throws ResourceInvalidException {
        HashMap priorities = new HashMap();
        LinkedHashMap<com.google.bigtable.repackaged.io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<com.google.bigtable.repackaged.io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints>();
        ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
        int maxPriority = -1;
        for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
            StructOrError<Endpoints.LocalityLbEndpoints> structOrError = ClientXdsClient.parseLocalityLbEndpoints(localityLbEndpointsProto);
            if (structOrError == null) continue;
            if (structOrError.getErrorDetail() != null) {
                throw new ResourceInvalidException(structOrError.getErrorDetail());
            }
            Endpoints.LocalityLbEndpoints localityLbEndpoints = structOrError.getStruct();
            int priority = localityLbEndpoints.priority();
            maxPriority = Math.max(maxPriority, priority);
            com.google.bigtable.repackaged.io.grpc.xds.Locality locality = ClientXdsClient.parseLocality(localityLbEndpointsProto.getLocality());
            localityLbEndpointsMap.put(locality, localityLbEndpoints);
            if (!priorities.containsKey(priority)) {
                priorities.put(priority, new HashSet());
            }
            if (((Set)priorities.get(priority)).add(locality)) continue;
            throw new ResourceInvalidException("ClusterLoadAssignment has duplicate locality:" + locality + " for priority:" + priority);
        }
        if (priorities.size() != maxPriority + 1) {
            throw new ResourceInvalidException("ClusterLoadAssignment has sparse priorities");
        }
        for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
            dropOverloads.add(ClientXdsClient.parseDropOverload(dropOverloadProto));
        }
        return new XdsClient.EdsUpdate(assignment.getClusterName(), localityLbEndpointsMap, dropOverloads);
    }

    private static com.google.bigtable.repackaged.io.grpc.xds.Locality parseLocality(Locality proto) {
        return com.google.bigtable.repackaged.io.grpc.xds.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), ClientXdsClient.getRatePerMillion(proto.getDropPercentage()));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) {
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return StructOrError.fromError("negative priority");
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            SocketAddress socketAddress = endpoint.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup(ImmutableList.of(addr)), endpoint.getLoadBalancingWeight().getValue(), isHealthy));
        }
        return StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority()));
    }

    private static <T extends Message> T unpackCompatibleType(Any any, Class<T> clazz, String typeUrl, String compatibleTypeUrl) throws InvalidProtocolBufferException {
        if (any.getTypeUrl().equals(compatibleTypeUrl)) {
            any = any.toBuilder().setTypeUrl(typeUrl).build();
        }
        return any.unpack(clazz);
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Override
    public void handleStreamClosed(Status error) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cleanUpResourceTimers();
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
    }

    @Override
    public void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            if (!subscriber.serverInfo.equals(serverInfo)) continue;
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            if (!subscriber.serverInfo.equals(serverInfo)) continue;
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            if (!subscriber.serverInfo.equals(serverInfo)) continue;
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            if (!subscriber.serverInfo.equals(serverInfo)) continue;
            subscriber.restartTimer();
        }
    }

    @Override
    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (ClientXdsClient.this.isShutdown) {
                    return;
                }
                ClientXdsClient.this.isShutdown = true;
                for (AbstractXdsClient xdsChannel : ClientXdsClient.this.serverChannelMap.values()) {
                    xdsChannel.shutdown();
                }
                if (ClientXdsClient.this.reportingLoad) {
                    for (LoadReportClient lrsClient : ClientXdsClient.this.serverLrsClientMap.values()) {
                        lrsClient.stopLoadReporting();
                    }
                }
                ClientXdsClient.this.cleanUpResourceTimers();
            }
        });
    }

    @Override
    boolean isShutDown() {
        return this.isShutdown;
    }

    private Map<String, ResourceSubscriber> getSubscribedResourcesMap(AbstractXdsClient.ResourceType type) {
        switch (type) {
            case LDS: {
                return this.ldsResourceSubscribers;
            }
            case RDS: {
                return this.rdsResourceSubscribers;
            }
            case CDS: {
                return this.cdsResourceSubscribers;
            }
            case EDS: {
                return this.edsResourceSubscribers;
            }
        }
        throw new AssertionError((Object)"Unknown resource type");
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, AbstractXdsClient.ResourceType type) {
        Map<String, ResourceSubscriber> resources = this.getSubscribedResourcesMap(type);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : resources.keySet()) {
            if (!resources.get(key).serverInfo.equals(serverInfo)) continue;
            builder.add(key);
        }
        ImmutableCollection retVal = builder.build();
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    ListenableFuture<Map<AbstractXdsClient.ResourceType, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture<Map<AbstractXdsClient.ResourceType, Map<String, XdsClient.ResourceMetadata>>> future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (AbstractXdsClient.ResourceType type : AbstractXdsClient.ResourceType.values()) {
                    if (type == AbstractXdsClient.ResourceType.UNKNOWN) continue;
                    ImmutableMap.Builder<String, XdsClient.ResourceMetadata> metadataMap = ImmutableMap.builder();
                    for (Map.Entry resourceEntry : ClientXdsClient.this.getSubscribedResourcesMap(type).entrySet()) {
                        metadataMap.put((String)resourceEntry.getKey(), ((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put(type, metadataMap.buildOrThrow());
                }
                future.set(metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    TlsContextManager getTlsContextManager() {
        return this.tlsContextManager;
    }

    @Override
    void watchLdsResource(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe LDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.LDS, resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelLdsResourceWatch(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ClientXdsClient.this.ldsResourceSubscribers.remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                    }
                }
            }
        });
    }

    @Override
    void watchRdsResource(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe RDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.RDS, resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelRdsResourceWatch(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ClientXdsClient.this.rdsResourceSubscribers.remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                    }
                }
            }
        });
    }

    @Override
    void watchCdsResource(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.CDS, resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelCdsResourceWatch(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ClientXdsClient.this.cdsResourceSubscribers.remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                    }
                }
            }
        });
    }

    @Override
    void watchEdsResource(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe EDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.EDS, resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelEdsResourceWatch(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ClientXdsClient.this.edsResourceSubscribers.remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                    }
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2.ClusterDropStats dropCounter = this.loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ((LoadReportClient)ClientXdsClient.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, com.google.bigtable.repackaged.io.grpc.xds.Locality locality) {
        LoadStatsManager2.ClusterLocalityStats loadCounter = this.loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ((LoadReportClient)ClientXdsClient.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return loadCounter;
    }

    @Override
    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public String toString() {
        return this.logId.toString();
    }

    private void cleanUpResourceTimers() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
    }

    private void handleResourceUpdate(Bootstrapper.ServerInfo serverInfo, AbstractXdsClient.ResourceType type, Map<String, ParsedResource> parsedResources, Set<String> invalidResources, Set<String> retainedResources, String version, String nonce, List<String> errors) {
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument(invalidResources.isEmpty(), "found invalid resources but missing errors");
            this.serverChannelMap.get(serverInfo).ackResponse(type, version, nonce);
        } else {
            errorDetail = Joiner.on('\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", new Object[]{type, version, nonce, errorDetail});
            this.serverChannelMap.get(serverInfo).nackResponse(type, nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        for (Map.Entry<String, ResourceSubscriber> entry : this.getSubscribedResourcesMap(type).entrySet()) {
            String resourceName = entry.getKey();
            ResourceSubscriber subscriber = entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), version, updateTime);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(version, updateTime, errorDetail);
            }
            if (type != AbstractXdsClient.ResourceType.LDS && type != AbstractXdsClient.ResourceType.CDS) continue;
            if (invalidResources.contains(resourceName)) {
                if (subscriber.data != null) {
                    this.retainDependentResource(subscriber, retainedResources);
                    continue;
                }
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail));
                continue;
            }
            subscriber.onAbsent();
            if (subscriber.absent) continue;
            this.retainDependentResource(subscriber, retainedResources);
        }
        if (type == AbstractXdsClient.ResourceType.LDS || type == AbstractXdsClient.ResourceType.CDS) {
            Map<String, ResourceSubscriber> dependentSubscribers = type == AbstractXdsClient.ResourceType.LDS ? this.rdsResourceSubscribers : this.edsResourceSubscribers;
            for (String resource : dependentSubscribers.keySet()) {
                if (retainedResources.contains(resource)) continue;
                dependentSubscribers.get(resource).onAbsent();
            }
        }
    }

    private void retainDependentResource(ResourceSubscriber subscriber, Set<String> retainedResources) {
        if (subscriber.data == null) {
            return;
        }
        String resourceName = null;
        if (subscriber.type == AbstractXdsClient.ResourceType.LDS) {
            XdsClient.LdsUpdate ldsUpdate = (XdsClient.LdsUpdate)subscriber.data;
            com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager hcm = ldsUpdate.httpConnectionManager();
            if (hcm != null) {
                resourceName = hcm.rdsName();
            }
        } else if (subscriber.type == AbstractXdsClient.ResourceType.CDS) {
            XdsClient.CdsUpdate cdsUpdate = (XdsClient.CdsUpdate)subscriber.data;
            resourceName = cdsUpdate.edsServiceName();
        }
        if (resourceName != null) {
            retainedResources.add(resourceName);
        }
    }

    static abstract class XdsChannelFactory {
        static final XdsChannelFactory DEFAULT_XDS_CHANNEL_FACTORY = new XdsChannelFactory(){

            @Override
            ManagedChannel create(Bootstrapper.ServerInfo serverInfo) {
                String target = serverInfo.target();
                ChannelCredentials channelCredentials = serverInfo.channelCredentials();
                return ((ManagedChannelBuilder)Grpc.newChannelBuilder(target, channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES)).build();
            }
        };

        XdsChannelFactory() {
        }

        abstract ManagedChannel create(Bootstrapper.ServerInfo var1);
    }

    @VisibleForTesting
    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        private static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        private static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, "struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = Preconditions.checkNotNull(errorDetail, "errorDetail");
        }

        @Nullable
        @VisibleForTesting
        T getStruct() {
            return this.struct;
        }

        @Nullable
        @VisibleForTesting
        String getErrorDetail() {
            return this.errorDetail;
        }
    }

    @VisibleForTesting
    static final class ResourceInvalidException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ResourceInvalidException(String message) {
            super(message, null, false, false);
        }

        ResourceInvalidException(String message, Throwable cause) {
            super(cause != null ? message + ": " + cause.getMessage() : message, cause, false, false);
        }
    }

    private final class ResourceSubscriber {
        @Nullable
        private final Bootstrapper.ServerInfo serverInfo;
        @Nullable
        private final AbstractXdsClient xdsChannel;
        private final AbstractXdsClient.ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher> watchers = new HashSet<XdsClient.ResourceWatcher>();
        @Nullable
        private XdsClient.ResourceUpdate data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        ResourceSubscriber(AbstractXdsClient.ResourceType type, String resource) {
            ClientXdsClient.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.serverInfo = this.getServerInfo(resource);
            if (this.serverInfo == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                this.xdsChannel = null;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            ClientXdsClient.this.maybeCreateXdsChannelWithLrs(this.serverInfo);
            this.xdsChannel = (AbstractXdsClient)ClientXdsClient.this.serverChannelMap.get(this.serverInfo);
            if (this.xdsChannel.isInBackoff()) {
                return;
            }
            this.restartTimer();
        }

        @Nullable
        private Bootstrapper.ServerInfo getServerInfo(String resource) {
            if (BootstrapperImpl.enableFederation && resource.startsWith("xdstp:")) {
                Bootstrapper.AuthorityInfo authorityInfo;
                URI uri = URI.create(resource);
                String authority = uri.getAuthority();
                if (authority == null) {
                    authority = "";
                }
                if ((authorityInfo = ClientXdsClient.this.bootstrapInfo.authorities().get(authority)) == null || authorityInfo.xdsServers().isEmpty()) {
                    return null;
                }
                return (Bootstrapper.ServerInfo)authorityInfo.xdsServers().get(0);
            }
            return (Bootstrapper.ServerInfo)ClientXdsClient.this.bootstrapInfo.servers().get(0);
        }

        void addWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument(!this.watchers.contains(watcher), "watcher %s already registered", (Object)watcher);
            this.watchers.add(watcher);
            if (this.errorDescription != null) {
                watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                return;
            }
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument(this.watchers.contains(watcher), "watcher %s not registered", (Object)watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = ClientXdsClient.this.syncContext.schedule(new ResourceNotFound(), 15L, TimeUnit.SECONDS, ClientXdsClient.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            ClientXdsClient.this.logger.log(logLevel, message, new Object[]{this.type, this.resource, this.serverInfo != null ? this.serverInfo.target() : "unknown"});
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(ParsedResource parsedResource, String version, long updateTime) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            XdsClient.ResourceUpdate oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", new Object[]{this.serverInfo != null ? this.serverInfo.target() : "unknown", this.type, this.resource});
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    this.notifyWatcher(watcher, this.data);
                }
            }
        }

        void onAbsent() {
            boolean isStateOfTheWorld;
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean ignoreResourceDeletionEnabled = this.serverInfo != null && this.serverInfo.ignoreResourceDeletion();
            boolean bl = isStateOfTheWorld = this.type == AbstractXdsClient.ResourceType.LDS || this.type == AbstractXdsClient.ResourceType.CDS;
            if (ignoreResourceDeletionEnabled && isStateOfTheWorld && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", new Object[]{this.serverInfo.target(), this.type, this.resource});
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode(error.getCode()).withDescription(description + "nodeID: " + ClientXdsClient.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher watcher : this.watchers) {
                watcher.onError(errorAugmented);
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher watcher, XdsClient.ResourceUpdate update) {
            switch (this.type) {
                case LDS: {
                    ((XdsClient.LdsResourceWatcher)watcher).onChanged((XdsClient.LdsUpdate)update);
                    break;
                }
                case RDS: {
                    ((XdsClient.RdsResourceWatcher)watcher).onChanged((XdsClient.RdsUpdate)update);
                    break;
                }
                case CDS: {
                    ((XdsClient.CdsResourceWatcher)watcher).onChanged((XdsClient.CdsUpdate)update);
                    break;
                }
                case EDS: {
                    ((XdsClient.EdsResourceWatcher)watcher).onChanged((XdsClient.EdsUpdate)update);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"should never be here");
                }
            }
        }
    }

    private static final class ParsedResource {
        private final XdsClient.ResourceUpdate resourceUpdate;
        private final Any rawResource;

        private ParsedResource(XdsClient.ResourceUpdate resourceUpdate, Any rawResource) {
            this.resourceUpdate = Preconditions.checkNotNull(resourceUpdate, "resourceUpdate");
            this.rawResource = Preconditions.checkNotNull(rawResource, "rawResource");
        }

        private XdsClient.ResourceUpdate getResourceUpdate() {
            return this.resourceUpdate;
        }

        private Any getRawResource() {
            return this.rawResource;
        }
    }
}

