/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent;

import com.google.bigtable.repackaged.com.google.protobuf.DoubleValue;
import com.google.bigtable.repackaged.com.google.protobuf.Int64Value;
import com.google.bigtable.repackaged.com.google.protobuf.Timestamp;
import com.google.bigtable.repackaged.io.opencensus.common.Function;
import com.google.bigtable.repackaged.io.opencensus.common.Functions;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.data.AttachmentValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.data.Exemplar;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Distribution;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Summary;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.DistributionValue;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.LabelKey;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.LabelValue;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.Metric;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.MetricDescriptor;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.Point;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.SummaryValue;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.TimeSeries;
import com.google.bigtable.repackaged.io.opencensus.proto.resource.v1.Resource;
import com.google.bigtable.repackaged.io.opencensus.resource.Resource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class MetricsProtoUtils {
    static Metric toMetricProto(com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric metric, @Nullable Resource resource) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setMetricDescriptor(MetricsProtoUtils.toMetricDescriptorProto(metric.getMetricDescriptor()));
        for (com.google.bigtable.repackaged.io.opencensus.metrics.export.TimeSeries timeSeries : metric.getTimeSeriesList()) {
            builder.addTimeseries(MetricsProtoUtils.toTimeSeriesProto(timeSeries));
        }
        if (resource != null) {
            builder.setResource(MetricsProtoUtils.toResourceProto(resource));
        }
        return builder.build();
    }

    private static MetricDescriptor toMetricDescriptorProto(com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor metricDescriptor) {
        MetricDescriptor.Builder builder = MetricDescriptor.newBuilder();
        builder.setName(metricDescriptor.getName()).setDescription(metricDescriptor.getDescription()).setUnit(metricDescriptor.getUnit()).setType(MetricsProtoUtils.toTypeProto(metricDescriptor.getType()));
        for (com.google.bigtable.repackaged.io.opencensus.metrics.LabelKey labelKey : metricDescriptor.getLabelKeys()) {
            builder.addLabelKeys(MetricsProtoUtils.toLabelKeyProto(labelKey));
        }
        return builder.build();
    }

    private static MetricDescriptor.Type toTypeProto(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_INT64: {
                return MetricDescriptor.Type.CUMULATIVE_INT64;
            }
            case CUMULATIVE_DOUBLE: {
                return MetricDescriptor.Type.CUMULATIVE_DOUBLE;
            }
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION;
            }
            case GAUGE_INT64: {
                return MetricDescriptor.Type.GAUGE_INT64;
            }
            case GAUGE_DOUBLE: {
                return MetricDescriptor.Type.GAUGE_DOUBLE;
            }
            case GAUGE_DISTRIBUTION: {
                return MetricDescriptor.Type.GAUGE_DISTRIBUTION;
            }
            case SUMMARY: {
                return MetricDescriptor.Type.SUMMARY;
            }
        }
        return MetricDescriptor.Type.UNRECOGNIZED;
    }

    private static LabelKey toLabelKeyProto(com.google.bigtable.repackaged.io.opencensus.metrics.LabelKey labelKey) {
        return LabelKey.newBuilder().setKey(labelKey.getKey()).setDescription(labelKey.getDescription()).build();
    }

    private static com.google.bigtable.repackaged.io.opencensus.proto.resource.v1.Resource toResourceProto(Resource resource) {
        Resource.Builder builder = com.google.bigtable.repackaged.io.opencensus.proto.resource.v1.Resource.newBuilder();
        if (resource.getType() != null) {
            builder.setType(resource.getType());
        }
        builder.putAllLabels(resource.getLabels());
        return builder.build();
    }

    private static TimeSeries toTimeSeriesProto(com.google.bigtable.repackaged.io.opencensus.metrics.export.TimeSeries timeSeries) {
        TimeSeries.Builder builder = TimeSeries.newBuilder();
        if (timeSeries.getStartTimestamp() != null) {
            builder.setStartTimestamp(MetricsProtoUtils.toTimestampProto(timeSeries.getStartTimestamp()));
        }
        for (LabelValue labelValue : timeSeries.getLabelValues()) {
            builder.addLabelValues(MetricsProtoUtils.toLabelValueProto(labelValue));
        }
        for (com.google.bigtable.repackaged.io.opencensus.metrics.export.Point point : timeSeries.getPoints()) {
            builder.addPoints(MetricsProtoUtils.toPointProto(point));
        }
        return builder.build();
    }

    private static com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.LabelValue toLabelValueProto(LabelValue labelValue) {
        LabelValue.Builder builder = com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.LabelValue.newBuilder();
        if (labelValue.getValue() == null) {
            builder.setHasValue(false);
        } else {
            builder.setHasValue(true).setValue(labelValue.getValue());
        }
        return builder.build();
    }

    private static Point toPointProto(com.google.bigtable.repackaged.io.opencensus.metrics.export.Point point) {
        final Point.Builder builder = Point.newBuilder();
        builder.setTimestamp(MetricsProtoUtils.toTimestampProto(point.getTimestamp()));
        point.getValue().match(new Function<Double, Void>(){

            @Override
            public Void apply(Double arg) {
                builder.setDoubleValue(arg);
                return null;
            }
        }, new Function<Long, Void>(){

            @Override
            public Void apply(Long arg) {
                builder.setInt64Value(arg);
                return null;
            }
        }, new Function<Distribution, Void>(){

            @Override
            public Void apply(Distribution arg) {
                builder.setDistributionValue(MetricsProtoUtils.toDistributionProto(arg));
                return null;
            }
        }, new Function<Summary, Void>(){

            @Override
            public Void apply(Summary arg) {
                builder.setSummaryValue(MetricsProtoUtils.toSummaryProto(arg));
                return null;
            }
        }, Functions.throwAssertionError());
        return builder.build();
    }

    private static DistributionValue toDistributionProto(Distribution distribution) {
        DistributionValue.Builder builder = DistributionValue.newBuilder();
        builder.setSum(distribution.getSum()).setCount(distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        if (distribution.getBucketOptions() != null) {
            builder.setBucketOptions(MetricsProtoUtils.toBucketOptionsProto(distribution.getBucketOptions()));
        }
        for (Distribution.Bucket bucket : distribution.getBuckets()) {
            builder.addBuckets(MetricsProtoUtils.toBucketProto(bucket));
        }
        return builder.build();
    }

    private static DistributionValue.BucketOptions toBucketOptionsProto(Distribution.BucketOptions bucketOptions) {
        final DistributionValue.BucketOptions.Builder builder = DistributionValue.BucketOptions.newBuilder();
        bucketOptions.match(new Function<Distribution.BucketOptions.ExplicitOptions, Void>(){

            @Override
            public Void apply(Distribution.BucketOptions.ExplicitOptions arg) {
                builder.setExplicit(DistributionValue.BucketOptions.Explicit.newBuilder().addAllBounds(arg.getBucketBoundaries()).build());
                return null;
            }
        }, Functions.throwAssertionError());
        return builder.build();
    }

    private static DistributionValue.Bucket toBucketProto(Distribution.Bucket bucket) {
        DistributionValue.Bucket.Builder builder = DistributionValue.Bucket.newBuilder().setCount(bucket.getCount());
        Exemplar exemplar = bucket.getExemplar();
        if (exemplar != null) {
            builder.setExemplar(MetricsProtoUtils.toExemplarProto(exemplar));
        }
        return builder.build();
    }

    private static DistributionValue.Exemplar toExemplarProto(Exemplar exemplar) {
        HashMap<String, String> stringAttachments = new HashMap<String, String>();
        for (Map.Entry<String, AttachmentValue> entry : exemplar.getAttachments().entrySet()) {
            stringAttachments.put(entry.getKey(), entry.getValue().getValue());
        }
        return DistributionValue.Exemplar.newBuilder().setValue(exemplar.getValue()).setTimestamp(MetricsProtoUtils.toTimestampProto(exemplar.getTimestamp())).putAllAttachments(stringAttachments).build();
    }

    private static SummaryValue toSummaryProto(Summary summary) {
        SummaryValue.Builder builder = SummaryValue.newBuilder();
        if (summary.getSum() != null) {
            builder.setSum(DoubleValue.of(summary.getSum()));
        }
        if (summary.getCount() != null) {
            builder.setCount(Int64Value.of(summary.getCount()));
        }
        builder.setSnapshot(MetricsProtoUtils.toSnapshotProto(summary.getSnapshot()));
        return builder.build();
    }

    private static SummaryValue.Snapshot toSnapshotProto(Summary.Snapshot snapshot) {
        SummaryValue.Snapshot.Builder builder = SummaryValue.Snapshot.newBuilder();
        if (snapshot.getSum() != null) {
            builder.setSum(DoubleValue.of(snapshot.getSum()));
        }
        if (snapshot.getCount() != null) {
            builder.setCount(Int64Value.of(snapshot.getCount()));
        }
        for (Summary.Snapshot.ValueAtPercentile valueAtPercentile : snapshot.getValueAtPercentiles()) {
            builder.addPercentileValues(SummaryValue.Snapshot.ValueAtPercentile.newBuilder().setValue(valueAtPercentile.getValue()).setPercentile(valueAtPercentile.getPercentile()).build());
        }
        return builder.build();
    }

    static Timestamp toTimestampProto(com.google.bigtable.repackaged.io.opencensus.common.Timestamp timestamp) {
        return Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    private MetricsProtoUtils() {
    }
}

