/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.net.bytebuddy.ByteBuddy;
import com.google.bigtable.repackaged.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.google.bigtable.repackaged.net.bytebuddy.matcher.ElementMatchers;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.ChronoUnit;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.util.ModifyTableBuilder;
import com.google.cloud.bigtable.hbase.wrappers.AdminClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase2_x.ApiFutureUtils;
import com.google.cloud.bigtable.hbase2_x.adapters.admin.TableAdapter2x;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AbstractBigtableAdmin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public abstract class BigtableAsyncAdmin
implements AsyncAdmin {
    private final Logger LOG = new Logger(this.getClass());
    private final Set<TableName> disabledTables;
    private final AdminClientWrapper bigtableTableAdminClient;
    private final BigtableHBaseSettings settings;
    private final CommonConnection asyncConnection;
    private final String bigtableInstanceName;
    private String snapshotClusterId;
    private final int ttlSeconds;
    private static Class<? extends BigtableAsyncAdmin> asyncAdminClass = null;

    public BigtableAsyncAdmin(CommonConnection asyncConnection) throws IOException {
        this.LOG.debug("Creating BigtableAsyncAdmin", new Object[0]);
        this.settings = asyncConnection.getBigtableSettings();
        this.bigtableTableAdminClient = asyncConnection.getBigtableApi().getAdminClient();
        this.bigtableInstanceName = asyncConnection.getBigtableSettings().getInstanceId();
        this.disabledTables = asyncConnection.getDisabledTables();
        this.asyncConnection = asyncConnection;
        Configuration configuration = asyncConnection.getConfiguration();
        this.snapshotClusterId = configuration.get("google.bigtable.snapshot.cluster.id");
        this.ttlSeconds = configuration.getInt("google.bigtable.snapshot.default.ttl.secs", 86400);
        if (this.ttlSeconds <= 0) {
            throw new IllegalArgumentException("google.bigtable.snapshot.default.ttl.secs must be > 0");
        }
    }

    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[][] splitKeys) {
        if (desc.getTableName() == null) {
            return ApiFutureUtils.failedFuture(new IllegalArgumentException("TableName cannot be null"));
        }
        CreateTableRequest request = TableAdapter2x.adapt(desc, splitKeys);
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.createTableAsync(request)).handle((resp, ex) -> {
            if (ex != null) {
                throw new CompletionException(AbstractBigtableAdmin.convertToTableExistsException(desc.getTableName(), ex));
            }
            return null;
        });
    }

    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) {
        return CompletableFuture.supplyAsync(() -> AbstractBigtableAdmin.createSplitKeys(startKey, endKey, numRegions)).thenCompose(keys -> this.createTable(desc, (byte[][])keys));
    }

    public CompletableFuture<Void> createTable(TableDescriptor desc) {
        return this.createTable(desc, null);
    }

    public CompletableFuture<Void> disableTable(TableName tableName) {
        return this.tableExists(tableName).thenApply(exists -> {
            if (!exists.booleanValue()) {
                throw new CompletionException((Throwable)new TableNotFoundException(tableName));
            }
            if (this.disabledTables.contains(tableName)) {
                throw new CompletionException((Throwable)new TableNotEnabledException(tableName));
            }
            this.disabledTables.add(tableName);
            this.LOG.warn("Table " + tableName + " was disabled in memory only.", new Object[0]);
            return null;
        });
    }

    public CompletableFuture<Void> enableTable(TableName tableName) {
        return this.tableExists(tableName).thenApply(exists -> {
            if (!exists.booleanValue()) {
                throw new CompletionException((Throwable)new TableNotFoundException(tableName));
            }
            if (!this.disabledTables.contains(tableName)) {
                throw new CompletionException((Throwable)new TableNotDisabledException(tableName));
            }
            this.disabledTables.remove(tableName);
            this.LOG.warn("Table " + tableName + " was enabled in memory only.", new Object[0]);
            return null;
        });
    }

    public CompletableFuture<Void> deleteTable(TableName tableName) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.deleteTableAsync(tableName.getNameAsString())).thenAccept(r -> this.disabledTables.remove(tableName));
    }

    public CompletableFuture<Boolean> tableExists(TableName tableName) {
        return this.listTableNames(Optional.of(Pattern.compile(tableName.getNameAsString()))).thenApply(r -> r.stream().anyMatch(e -> e.equals((Object)tableName)));
    }

    private CompletableFuture<List<TableName>> listTableNames(Optional<Pattern> tableNamePattern) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.listTablesAsync()).thenApply(r -> r.stream().filter(e -> !tableNamePattern.isPresent() || ((Pattern)tableNamePattern.get()).matcher((CharSequence)e).matches()).map(TableName::valueOf).collect(Collectors.toList()));
    }

    public CompletableFuture<List<TableName>> listTableNames(boolean includeSysTables) {
        return this.listTableNames(Optional.empty());
    }

    public CompletableFuture<List<TableName>> listTableNames(Pattern tableNamePattern, boolean includeSysTables) {
        return this.listTableNames(Optional.of(tableNamePattern));
    }

    private CompletableFuture<List<TableDescriptor>> listTables(Optional<Pattern> tableNamePattern) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.listTablesAsync()).thenApply(r -> r.stream().filter(t -> !tableNamePattern.isPresent() || ((Pattern)tableNamePattern.get()).matcher((CharSequence)t).matches()).map(m -> Table.newBuilder().setName(NameUtil.formatTableName(this.settings.getProjectId(), this.settings.getInstanceId(), m)).build()).map(com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table::fromProto).map(TableAdapter2x::adapt).collect(Collectors.toList()));
    }

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(boolean includeSysTables) {
        return this.listTables(Optional.empty());
    }

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(Pattern pattern, boolean includeSysTables) {
        return this.listTables(Optional.of(pattern));
    }

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(List<TableName> tableNames) {
        Preconditions.checkNotNull(tableNames, "tableNames is null");
        if (tableNames.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.listTablesAsync()).thenApply(t -> tableNames.stream().filter(inputTableName -> t.contains(inputTableName.getNameAsString())).map(tbName -> {
            try {
                return this.getDescriptor((TableName)tbName).join();
            }
            catch (CompletionException ex) {
                if (ex.getCause() instanceof TableNotFoundException) {
                    return null;
                }
                throw ex;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public CompletableFuture<Boolean> isTableDisabled(TableName tableName) {
        return CompletableFuture.completedFuture(this.disabledTables.contains(tableName));
    }

    public CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        return CompletableFuture.completedFuture(!this.disabledTables.contains(tableName));
    }

    public CompletableFuture<TableDescriptor> getDescriptor(TableName tableName) {
        if (tableName == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.getTableAsync(tableName.getNameAsString())).handle((resp, ex) -> {
            if (ex != null) {
                if (Status.fromThrowable(ex).getCode() == Status.Code.NOT_FOUND) {
                    throw new CompletionException((Throwable)new TableNotFoundException(tableName));
                }
                throw new CompletionException((Throwable)ex);
            }
            return TableAdapter2x.adapt(resp);
        });
    }

    public CompletableFuture<Void> deleteSnapshot(String snapshotId) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.deleteBackupAsync(this.getBackupClusterId(), snapshotId));
    }

    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("Unsupported - please use deleteSnapshots");
    }

    public CompletableFuture<Void> addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamilyDesc) {
        return this.modifyColumns(ModifyTableBuilder.newBuilder(tableName).add(TableAdapter2x.toHColumnDescriptor(columnFamilyDesc)));
    }

    public CompletableFuture<Void> deleteColumnFamily(TableName tableName, byte[] columnName) {
        return this.modifyColumns(ModifyTableBuilder.newBuilder(tableName).delete(Bytes.toString((byte[])columnName)));
    }

    public CompletableFuture<Void> modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamilyDesc) {
        return this.modifyColumns(ModifyTableBuilder.newBuilder(tableName).modify(TableAdapter2x.toHColumnDescriptor(columnFamilyDesc)));
    }

    public CompletableFuture<Void> modifyTable(TableDescriptor newDescriptor) {
        return ((CompletableFuture)this.getDescriptor(newDescriptor.getTableName()).thenApply(descriptor -> ModifyTableBuilder.buildModifications(new HTableDescriptor(newDescriptor), new HTableDescriptor(descriptor)))).thenCompose(this::modifyColumns);
    }

    private CompletableFuture<Void> modifyColumns(ModifyTableBuilder modifications) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.modifyFamiliesAsync(modifications.build())).thenApply(r -> null);
    }

    public CompletableFuture<Void> restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("In place table restorations are not supported. Please use cloneSnapshot");
    }

    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("In place table restorations are not supported. Please use cloneSnapshot");
    }

    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("In place table restorations are not supported. Please use cloneSnapshot");
    }

    public CompletableFuture<Void> truncateTable(TableName tableName, boolean preserveSplits) {
        if (!preserveSplits) {
            this.LOG.info("truncate will preserveSplits. The passed in variable is ignored.", new Object[0]);
        }
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.dropAllRowsAsync(tableName.getNameAsString()));
    }

    public CompletableFuture<Void> deleteSnapshots() {
        throw new UnsupportedOperationException("use deleteSnapshot instead");
    }

    public CompletableFuture<Void> deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("use deleteSnapshot instead");
    }

    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern) {
        throw new UnsupportedOperationException("use deleteSnapshot instead");
    }

    public CompletableFuture<Void> snapshot(String snapshotId, TableName tableName) {
        Instant expireTime = Instant.now().plus((long)this.ttlSeconds, ChronoUnit.SECONDS);
        if (Strings.isNullOrEmpty(snapshotId)) {
            throw new IllegalArgumentException("Snapshot name cannot be null");
        }
        if (Strings.isNullOrEmpty(tableName.getNameAsString())) {
            throw new IllegalArgumentException("Table name cannot be null");
        }
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.createBackupAsync(CreateBackupRequest.of(this.getBackupClusterId(), snapshotId).setExpireTime(expireTime).setSourceTableId(tableName.getNameAsString()))).thenAccept(backup -> {});
    }

    public CompletableFuture<Void> cloneSnapshot(String snapshotId, TableName tableName) {
        return ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.restoreTableAsync(RestoreTableRequest.of(this.getBackupClusterId(), snapshotId).setTableId(tableName.getNameAsString()))).thenAccept(backup -> {});
    }

    public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot");
    }

    public CompletableFuture<List<SnapshotDescription>> listSnapshots() {
        return CompletableFuture.supplyAsync(this::getBackupClusterId).thenCompose(c -> ApiFutureUtils.toCompletableFuture(this.bigtableTableAdminClient.listBackupsAsync((String)c)).thenApply(r -> r.stream().map(b -> new SnapshotDescription(b)).collect(Collectors.toList())));
    }

    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Pattern pattern) {
        Preconditions.checkNotNull(pattern);
        if (pattern.matcher("").matches()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return this.listSnapshots().thenApply(r -> BigtableAsyncAdmin.filter(r, d -> pattern.matcher(d.getName()).matches()));
    }

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotPattern) {
        throw new UnsupportedOperationException("Unsupported - please use listSnapshots");
    }

    private static <T> List<T> filter(Collection<T> r, Predicate<T> predicate) {
        return r.stream().filter(predicate).collect(Collectors.toList());
    }

    private synchronized String getBackupClusterId() {
        if (this.snapshotClusterId == null) {
            List<Cluster> clusters = this.asyncConnection.getBigtableApi().getAdminClient().listClusters(this.asyncConnection.getBigtableSettings().getInstanceId());
            Preconditions.checkState(clusters.size() == 1, String.format("Project '%s' / Instance '%s' has %d clusters. There must be exactly 1 for this operation to work.", this.asyncConnection.getBigtableSettings().getProjectId(), this.asyncConnection.getBigtableSettings().getInstanceId(), clusters.size()));
            this.snapshotClusterId = clusters.get(0).getId();
        }
        return this.snapshotClusterId;
    }

    public CompletableFuture<Boolean> isTableAvailable(TableName tableName) {
        return this.tableExists(tableName).handle((exists, ex) -> {
            if (ex != null) {
                throw new CompletionException((Throwable)ex);
            }
            if (!exists.booleanValue()) {
                throw new CompletionException((Throwable)new TableNotFoundException(tableName));
            }
            return true;
        });
    }

    public CompletableFuture<List<RegionInfo>> getRegions(TableName tableName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new CopyOnWriteArrayList<HRegionInfo>(this.asyncConnection.getAllRegionInfos(tableName));
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> snapshot(SnapshotDescription snapshot) {
        Objects.requireNonNull(snapshot);
        return this.snapshot(snapshot.getName(), snapshot.getTableName());
    }

    private static synchronized Class<? extends BigtableAsyncAdmin> getSubclass() {
        if (asyncAdminClass == null) {
            asyncAdminClass = new ByteBuddy().subclass(BigtableAsyncAdmin.class).method(ElementMatchers.isAbstract()).intercept(InvocationHandlerAdapter.of(new AbstractBigtableAdmin.UnsupportedOperationsHandler())).make().load(BigtableAsyncAdmin.class.getClassLoader()).getLoaded();
        }
        return asyncAdminClass;
    }

    public static BigtableAsyncAdmin createInstance(CommonConnection connection) throws IOException {
        try {
            return BigtableAsyncAdmin.getSubclass().getDeclaredConstructor(CommonConnection.class).newInstance(connection);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfInstanceOf(e.getTargetException(), IOException.class);
            Throwables.throwIfInstanceOf(e.getTargetException(), RuntimeException.class);
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

