/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.cloud.bigtable.hbase.AbstractBigtableTable;
import com.google.cloud.bigtable.hbase.BatchExecutor;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.CheckAndMutateUtil;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.GetAdapter;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase2_x.ApiFutureUtils;
import com.google.cloud.bigtable.hbase2_x.BigtableTable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;

@InternalApi(value="For internal usage only")
public class BigtableAsyncTable
implements AsyncTable<ScanResultConsumer> {
    private static final Logger LOG = new Logger(AbstractBigtableTable.class);
    private static final Tracer TRACER = Tracing.getTracer();
    private final CommonConnection connection;
    private final DataClientWrapper clientWrapper;
    private final HBaseRequestAdapter hbaseAdapter;
    private final TableName tableName;
    private BatchExecutor batchExecutor;

    private static <T, R> List<R> map(List<T> list, Function<T, R> f) {
        return list.stream().map(f).collect(Collectors.toList());
    }

    public BigtableAsyncTable(CommonConnection connection, HBaseRequestAdapter hbaseAdapter) {
        this.connection = connection;
        this.clientWrapper = connection.getBigtableApi().getDataClient();
        this.hbaseAdapter = hbaseAdapter;
        this.tableName = hbaseAdapter.getTableName();
    }

    protected synchronized BatchExecutor getBatchExecutor() {
        if (this.batchExecutor == null) {
            this.batchExecutor = new BatchExecutor(this.connection.getBigtableApi(), this.connection.getBigtableSettings(), this.hbaseAdapter);
        }
        return this.batchExecutor;
    }

    public CompletableFuture<Result> append(Append append) {
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.readModifyWriteRowAsync(this.hbaseAdapter.adapt(append))).thenApply(response -> append.isReturnResults() ? response : null);
    }

    public <T> List<CompletableFuture<T>> batch(List<? extends Row> actions) {
        return BigtableAsyncTable.map(this.asyncRequests(actions), f -> f);
    }

    public AsyncTable.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(this.clientWrapper, this.hbaseAdapter, row, family);
    }

    public AsyncTable.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] bytes, Filter filter) {
        throw new UnsupportedOperationException("not implemented");
    }

    public CompletableFuture<Void> delete(Delete delete) {
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.mutateRowAsync(this.hbaseAdapter.adapt(delete)));
    }

    public List<CompletableFuture<Void>> delete(List<Delete> deletes) {
        return BigtableAsyncTable.map(this.asyncRequests(deletes), cf -> cf.thenApply(r -> null));
    }

    private <T> List<CompletableFuture<?>> asyncRequests(List<? extends Row> actions) {
        return BigtableAsyncTable.map(this.getBatchExecutor().issueAsyncRowRequests(actions, new Object[actions.size()], null), ApiFutureUtils::toCompletableFuture);
    }

    public CompletableFuture<Result> get(Get get) {
        Filters.Filter filter = Adapters.GET_ADAPTER.buildFilter(get);
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.readRowAsync(this.tableName.getNameAsString(), ByteStringer.wrap(get.getRow()), filter));
    }

    public CompletableFuture<Boolean> exists(Get get) {
        return this.get(GetAdapter.setCheckExistenceOnly(get)).thenApply(r -> !r.isEmpty());
    }

    public List<CompletableFuture<Result>> get(List<Get> gets) {
        return BigtableAsyncTable.map(this.asyncRequests(gets), f -> f);
    }

    public List<CompletableFuture<Boolean>> exists(List<Get> gets) {
        List<Get> existGets = BigtableAsyncTable.map(gets, GetAdapter::setCheckExistenceOnly);
        return BigtableAsyncTable.map(this.get(existGets), cf -> cf.thenApply(r -> !r.isEmpty()));
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public CompletableFuture<TableDescriptor> getDescriptor() {
        throw new UnsupportedOperationException("not implemented");
    }

    public AsyncTableRegionLocator getRegionLocator() {
        throw new UnsupportedOperationException("not implemented");
    }

    public TableName getName() {
        return this.tableName;
    }

    public long getOperationTimeout(TimeUnit timeUnit) {
        throw new UnsupportedOperationException("getOperationTimeout");
    }

    public long getReadRpcTimeout(TimeUnit arg0) {
        throw new UnsupportedOperationException("getReadRpcTimeout");
    }

    public long getRpcTimeout(TimeUnit arg0) {
        throw new UnsupportedOperationException("getRpcTimeout");
    }

    public long getScanTimeout(TimeUnit arg0) {
        throw new UnsupportedOperationException("getScanTimeout");
    }

    public long getWriteRpcTimeout(TimeUnit arg0) {
        throw new UnsupportedOperationException("getWriteRpcTimeout");
    }

    public CompletableFuture<Result> increment(Increment increment) {
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.readModifyWriteRowAsync(this.hbaseAdapter.adapt(increment)));
    }

    public CompletableFuture<Void> mutateRow(RowMutations rowMutations) {
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.mutateRowAsync(this.hbaseAdapter.adapt(rowMutations)));
    }

    public CompletableFuture<Void> put(Put put) {
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.mutateRowAsync(this.hbaseAdapter.adapt(put)));
    }

    public List<CompletableFuture<Void>> put(List<Put> puts) {
        return BigtableAsyncTable.map(this.asyncRequests(puts), f -> f.thenApply(r -> null));
    }

    public CompletableFuture<List<Result>> scanAll(Scan scan) {
        if (AbstractBigtableTable.hasWhileMatchFilter(scan.getFilter())) {
            throw new UnsupportedOperationException("scanAll with while match filter is not allowed");
        }
        return ApiFutureUtils.toCompletableFuture(this.clientWrapper.readRowsAsync(this.hbaseAdapter.adapt(scan)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultScanner getScanner(Scan scan) {
        LOG.trace("getScanner(Scan)", new Object[0]);
        Span span = TRACER.spanBuilder("BigtableTable.scan").startSpan();
        try (Scope scope = TRACER.withSpan(span);){
            ResultScanner scanner = this.clientWrapper.readRows(this.hbaseAdapter.adapt(scan));
            if (AbstractBigtableTable.hasWhileMatchFilter(scan.getFilter())) {
                ResultScanner resultScanner2 = Adapters.BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER.adapt(scanner, span);
                return resultScanner2;
            }
            ResultScanner resultScanner = scanner;
            return resultScanner;
        }
        catch (Throwable throwable7) {
            LOG.error("Encountered exception when executing getScanner.", throwable7, new Object[0]);
            span.setStatus(Status.UNKNOWN);
            span.end();
            return new ResultScanner(){

                public boolean renewLease() {
                    return false;
                }

                public Result next() throws IOException {
                    throw throwable7;
                }

                public ScanMetrics getScanMetrics() {
                    return null;
                }

                public void close() {
                }
            };
        }
    }

    public void scan(Scan scan, final ScanResultConsumer consumer) {
        if (AbstractBigtableTable.hasWhileMatchFilter(scan.getFilter())) {
            throw new UnsupportedOperationException("scan with consumer and while match filter is not allowed");
        }
        Query query = this.hbaseAdapter.adapt(scan);
        this.clientWrapper.readRowsAsync(query, new StreamObserver<Result>(){

            @Override
            public void onNext(Result value) {
                consumer.onNext(value);
            }

            @Override
            public void onError(Throwable t) {
                consumer.onError(t);
            }

            @Override
            public void onCompleted() {
                consumer.onComplete();
            }
        });
    }

    public CompletableFuture coprocessorService(Function arg0, ServiceCaller arg1, byte[] arg2) {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public AsyncTable.CoprocessorServiceBuilder coprocessorService(Function arg0, ServiceCaller arg1, AsyncTable.CoprocessorCallback arg2) {
        throw new UnsupportedOperationException("coprocessorService");
    }

    static final class CheckAndMutateBuilderImpl
    implements AsyncTable.CheckAndMutateBuilder {
        private final CheckAndMutateUtil.RequestBuilder builder;
        private final DataClientWrapper clientWrapper;

        public CheckAndMutateBuilderImpl(DataClientWrapper clientWrapper, HBaseRequestAdapter hbaseAdapter, byte[] row, byte[] family) {
            this.clientWrapper = clientWrapper;
            this.builder = new CheckAndMutateUtil.RequestBuilder(hbaseAdapter, row, family);
        }

        public AsyncTable.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.builder.qualifier(qualifier);
            return this;
        }

        public AsyncTable.CheckAndMutateBuilder ifNotExists() {
            this.builder.ifNotExists();
            return this;
        }

        public AsyncTable.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            Preconditions.checkNotNull(compareOp, "compareOp is null");
            if (compareOp != CompareOperator.NOT_EQUAL) {
                Preconditions.checkNotNull(value, "value is null for compareOperator: " + compareOp);
            }
            this.builder.ifMatches(BigtableTable.toCompareOp(compareOp), value);
            return this;
        }

        public AsyncTable.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            this.builder.timeRange(timeRange.getMin(), timeRange.getMax());
            return this;
        }

        public CompletableFuture<Boolean> thenPut(Put put) {
            try {
                this.builder.withPut(put);
                return this.call();
            }
            catch (Exception e) {
                return ApiFutureUtils.failedFuture(e);
            }
        }

        public CompletableFuture<Boolean> thenDelete(Delete delete) {
            try {
                this.builder.withDelete(delete);
                return this.call();
            }
            catch (Exception e) {
                return ApiFutureUtils.failedFuture(e);
            }
        }

        public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
            try {
                this.builder.withMutations(mutation);
                return this.call();
            }
            catch (Exception e) {
                return ApiFutureUtils.failedFuture(e);
            }
        }

        private CompletableFuture<Boolean> call() {
            ConditionalRowMutation mutation = this.builder.build();
            return ApiFutureUtils.toCompletableFuture(this.clientWrapper.checkAndMutateRowAsync(mutation)).thenApply(response -> CheckAndMutateUtil.wasMutationApplied(mutation, response));
        }
    }
}

